/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedProductDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisionedProductDetail> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::name)).setter(ProvisionedProductDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::arn)).setter(ProvisionedProductDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::type)).setter(ProvisionedProductDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::id)).setter(ProvisionedProductDetail.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::statusAsString)).setter(ProvisionedProductDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::statusMessage)).setter(ProvisionedProductDetail.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::createdTime)).setter(ProvisionedProductDetail.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::idempotencyToken)).setter(ProvisionedProductDetail.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final SdkField<String> LAST_RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastRecordId").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::lastRecordId)).setter(ProvisionedProductDetail.setter(Builder::lastRecordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRecordId").build()}).build();
    private static final SdkField<String> LAST_PROVISIONING_RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastProvisioningRecordId").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::lastProvisioningRecordId)).setter(ProvisionedProductDetail.setter(Builder::lastProvisioningRecordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastProvisioningRecordId").build()}).build();
    private static final SdkField<String> LAST_SUCCESSFUL_PROVISIONING_RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastSuccessfulProvisioningRecordId").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::lastSuccessfulProvisioningRecordId)).setter(ProvisionedProductDetail.setter(Builder::lastSuccessfulProvisioningRecordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulProvisioningRecordId").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::productId)).setter(ProvisionedProductDetail.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::provisioningArtifactId)).setter(ProvisionedProductDetail.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> LAUNCH_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchRoleArn").getter(ProvisionedProductDetail.getter(ProvisionedProductDetail::launchRoleArn)).setter(ProvisionedProductDetail.setter(Builder::launchRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, TYPE_FIELD, ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATED_TIME_FIELD, IDEMPOTENCY_TOKEN_FIELD, LAST_RECORD_ID_FIELD, LAST_PROVISIONING_RECORD_ID_FIELD, LAST_SUCCESSFUL_PROVISIONING_RECORD_ID_FIELD, PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, LAUNCH_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String type;
    private final String id;
    private final String status;
    private final String statusMessage;
    private final Instant createdTime;
    private final String idempotencyToken;
    private final String lastRecordId;
    private final String lastProvisioningRecordId;
    private final String lastSuccessfulProvisioningRecordId;
    private final String productId;
    private final String provisioningArtifactId;
    private final String launchRoleArn;

    private ProvisionedProductDetail(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.type = builder.type;
        this.id = builder.id;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdTime = builder.createdTime;
        this.idempotencyToken = builder.idempotencyToken;
        this.lastRecordId = builder.lastRecordId;
        this.lastProvisioningRecordId = builder.lastProvisioningRecordId;
        this.lastSuccessfulProvisioningRecordId = builder.lastSuccessfulProvisioningRecordId;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.launchRoleArn = builder.launchRoleArn;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String type() {
        return this.type;
    }

    public final String id() {
        return this.id;
    }

    public final ProvisionedProductStatus status() {
        return ProvisionedProductStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public final String lastRecordId() {
        return this.lastRecordId;
    }

    public final String lastProvisioningRecordId() {
        return this.lastProvisioningRecordId;
    }

    public final String lastSuccessfulProvisioningRecordId() {
        return this.lastSuccessfulProvisioningRecordId;
    }

    public final String productId() {
        return this.productId;
    }

    public final String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public final String launchRoleArn() {
        return this.launchRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastProvisioningRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulProvisioningRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedProductDetail)) {
            return false;
        }
        ProvisionedProductDetail other = (ProvisionedProductDetail)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.lastRecordId(), other.lastRecordId()) && Objects.equals(this.lastProvisioningRecordId(), other.lastProvisioningRecordId()) && Objects.equals(this.lastSuccessfulProvisioningRecordId(), other.lastSuccessfulProvisioningRecordId()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.launchRoleArn(), other.launchRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionedProductDetail").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Type", (Object)this.type()).add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreatedTime", (Object)this.createdTime()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("LastRecordId", (Object)this.lastRecordId()).add("LastProvisioningRecordId", (Object)this.lastProvisioningRecordId()).add("LastSuccessfulProvisioningRecordId", (Object)this.lastSuccessfulProvisioningRecordId()).add("ProductId", (Object)this.productId()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("LaunchRoleArn", (Object)this.launchRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "LastRecordId": {
                return Optional.ofNullable(clazz.cast(this.lastRecordId()));
            }
            case "LastProvisioningRecordId": {
                return Optional.ofNullable(clazz.cast(this.lastProvisioningRecordId()));
            }
            case "LastSuccessfulProvisioningRecordId": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulProvisioningRecordId()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "LaunchRoleArn": {
                return Optional.ofNullable(clazz.cast(this.launchRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedProductDetail, T> g) {
        return obj -> g.apply((ProvisionedProductDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String type;
        private String id;
        private String status;
        private String statusMessage;
        private Instant createdTime;
        private String idempotencyToken;
        private String lastRecordId;
        private String lastProvisioningRecordId;
        private String lastSuccessfulProvisioningRecordId;
        private String productId;
        private String provisioningArtifactId;
        private String launchRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedProductDetail model) {
            this.name(model.name);
            this.arn(model.arn);
            this.type(model.type);
            this.id(model.id);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.createdTime(model.createdTime);
            this.idempotencyToken(model.idempotencyToken);
            this.lastRecordId(model.lastRecordId);
            this.lastProvisioningRecordId(model.lastProvisioningRecordId);
            this.lastSuccessfulProvisioningRecordId(model.lastSuccessfulProvisioningRecordId);
            this.productId(model.productId);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.launchRoleArn(model.launchRoleArn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProvisionedProductStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final String getLastRecordId() {
            return this.lastRecordId;
        }

        public final void setLastRecordId(String lastRecordId) {
            this.lastRecordId = lastRecordId;
        }

        @Override
        public final Builder lastRecordId(String lastRecordId) {
            this.lastRecordId = lastRecordId;
            return this;
        }

        public final String getLastProvisioningRecordId() {
            return this.lastProvisioningRecordId;
        }

        public final void setLastProvisioningRecordId(String lastProvisioningRecordId) {
            this.lastProvisioningRecordId = lastProvisioningRecordId;
        }

        @Override
        public final Builder lastProvisioningRecordId(String lastProvisioningRecordId) {
            this.lastProvisioningRecordId = lastProvisioningRecordId;
            return this;
        }

        public final String getLastSuccessfulProvisioningRecordId() {
            return this.lastSuccessfulProvisioningRecordId;
        }

        public final void setLastSuccessfulProvisioningRecordId(String lastSuccessfulProvisioningRecordId) {
            this.lastSuccessfulProvisioningRecordId = lastSuccessfulProvisioningRecordId;
        }

        @Override
        public final Builder lastSuccessfulProvisioningRecordId(String lastSuccessfulProvisioningRecordId) {
            this.lastSuccessfulProvisioningRecordId = lastSuccessfulProvisioningRecordId;
            return this;
        }

        public final String getProductId() {
            return this.productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final String getLaunchRoleArn() {
            return this.launchRoleArn;
        }

        public final void setLaunchRoleArn(String launchRoleArn) {
            this.launchRoleArn = launchRoleArn;
        }

        @Override
        public final Builder launchRoleArn(String launchRoleArn) {
            this.launchRoleArn = launchRoleArn;
            return this;
        }

        public ProvisionedProductDetail build() {
            return new ProvisionedProductDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionedProductDetail> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder type(String var1);

        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(ProvisionedProductStatus var1);

        public Builder statusMessage(String var1);

        public Builder createdTime(Instant var1);

        public Builder idempotencyToken(String var1);

        public Builder lastRecordId(String var1);

        public Builder lastProvisioningRecordId(String var1);

        public Builder lastSuccessfulProvisioningRecordId(String var1);

        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder launchRoleArn(String var1);
    }
}

