/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OrganizationNodeType {
    ORGANIZATION("ORGANIZATION"),
    ORGANIZATIONAL_UNIT("ORGANIZATIONAL_UNIT"),
    ACCOUNT("ACCOUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OrganizationNodeType> VALUE_MAP;
    private final String value;

    private OrganizationNodeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrganizationNodeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OrganizationNodeType> knownValues() {
        EnumSet<OrganizationNodeType> knownValues = EnumSet.allOf(OrganizationNodeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OrganizationNodeType.class, OrganizationNodeType::toString);
    }
}

