/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ProvisionedProductDetailsCopier {
    static List<ProvisionedProductDetail> copy(Collection<? extends ProvisionedProductDetail> provisionedProductDetailsParam) {
        List<ProvisionedProductDetail> list;
        if (provisionedProductDetailsParam == null || provisionedProductDetailsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ProvisionedProductDetail> modifiableList = new ArrayList<>();
            provisionedProductDetailsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ProvisionedProductDetail> copyFromBuilder(
            Collection<? extends ProvisionedProductDetail.Builder> provisionedProductDetailsParam) {
        List<ProvisionedProductDetail> list;
        if (provisionedProductDetailsParam == null || provisionedProductDetailsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ProvisionedProductDetail> modifiableList = new ArrayList<>();
            provisionedProductDetailsParam.forEach(entry -> {
                ProvisionedProductDetail member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ProvisionedProductDetail.Builder> copyToBuilder(
            Collection<? extends ProvisionedProductDetail> provisionedProductDetailsParam) {
        List<ProvisionedProductDetail.Builder> list;
        if (provisionedProductDetailsParam == null || provisionedProductDetailsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ProvisionedProductDetail.Builder> modifiableList = new ArrayList<>();
            provisionedProductDetailsParam.forEach(entry -> {
                ProvisionedProductDetail.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
