/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyProductResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<CopyProductResponse.Builder, CopyProductResponse> {
    private static final SdkField<String> COPY_PRODUCT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CopyProductToken").getter(getter(CopyProductResponse::copyProductToken))
            .setter(setter(Builder::copyProductToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyProductToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_PRODUCT_TOKEN_FIELD));

    private final String copyProductToken;

    private CopyProductResponse(BuilderImpl builder) {
        super(builder);
        this.copyProductToken = builder.copyProductToken;
    }

    /**
     * <p>
     * The token to use to track the progress of the operation.
     * </p>
     * 
     * @return The token to use to track the progress of the operation.
     */
    public final String copyProductToken() {
        return copyProductToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(copyProductToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyProductResponse)) {
            return false;
        }
        CopyProductResponse other = (CopyProductResponse) obj;
        return Objects.equals(copyProductToken(), other.copyProductToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyProductResponse").add("CopyProductToken", copyProductToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CopyProductToken":
            return Optional.ofNullable(clazz.cast(copyProductToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyProductResponse, T> g) {
        return obj -> g.apply((CopyProductResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo, CopyableBuilder<Builder, CopyProductResponse> {
        /**
         * <p>
         * The token to use to track the progress of the operation.
         * </p>
         * 
         * @param copyProductToken
         *        The token to use to track the progress of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyProductToken(String copyProductToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private String copyProductToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyProductResponse model) {
            super(model);
            copyProductToken(model.copyProductToken);
        }

        public final String getCopyProductToken() {
            return copyProductToken;
        }

        public final void setCopyProductToken(String copyProductToken) {
            this.copyProductToken = copyProductToken;
        }

        @Override
        public final Builder copyProductToken(String copyProductToken) {
            this.copyProductToken = copyProductToken;
            return this;
        }

        @Override
        public CopyProductResponse build() {
            return new CopyProductResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
