/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCloudFormationTemplateResponse
extends ServerlessApplicationRepositoryResponse
implements ToCopyableBuilder<Builder, CreateCloudFormationTemplateResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(CreateCloudFormationTemplateResponse.getter(CreateCloudFormationTemplateResponse::applicationId)).setter(CreateCloudFormationTemplateResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(CreateCloudFormationTemplateResponse.getter(CreateCloudFormationTemplateResponse::creationTime)).setter(CreateCloudFormationTemplateResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpirationTime").getter(CreateCloudFormationTemplateResponse.getter(CreateCloudFormationTemplateResponse::expirationTime)).setter(CreateCloudFormationTemplateResponse.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationTime").build()}).build();
    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SemanticVersion").getter(CreateCloudFormationTemplateResponse.getter(CreateCloudFormationTemplateResponse::semanticVersion)).setter(CreateCloudFormationTemplateResponse.setter(Builder::semanticVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateCloudFormationTemplateResponse.getter(CreateCloudFormationTemplateResponse::statusAsString)).setter(CreateCloudFormationTemplateResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateId").getter(CreateCloudFormationTemplateResponse.getter(CreateCloudFormationTemplateResponse::templateId)).setter(CreateCloudFormationTemplateResponse.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()}).build();
    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateUrl").getter(CreateCloudFormationTemplateResponse.getter(CreateCloudFormationTemplateResponse::templateUrl)).setter(CreateCloudFormationTemplateResponse.setter(Builder::templateUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, CREATION_TIME_FIELD, EXPIRATION_TIME_FIELD, SEMANTIC_VERSION_FIELD, STATUS_FIELD, TEMPLATE_ID_FIELD, TEMPLATE_URL_FIELD));
    private final String applicationId;
    private final String creationTime;
    private final String expirationTime;
    private final String semanticVersion;
    private final String status;
    private final String templateId;
    private final String templateUrl;

    private CreateCloudFormationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.creationTime = builder.creationTime;
        this.expirationTime = builder.expirationTime;
        this.semanticVersion = builder.semanticVersion;
        this.status = builder.status;
        this.templateId = builder.templateId;
        this.templateUrl = builder.templateUrl;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String expirationTime() {
        return this.expirationTime;
    }

    public final String semanticVersion() {
        return this.semanticVersion;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final String templateUrl() {
        return this.templateUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationTemplateResponse)) {
            return false;
        }
        CreateCloudFormationTemplateResponse other = (CreateCloudFormationTemplateResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.templateUrl(), other.templateUrl());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCloudFormationTemplateResponse").add("ApplicationId", (Object)this.applicationId()).add("CreationTime", (Object)this.creationTime()).add("ExpirationTime", (Object)this.expirationTime()).add("SemanticVersion", (Object)this.semanticVersion()).add("Status", (Object)this.statusAsString()).add("TemplateId", (Object)this.templateId()).add("TemplateUrl", (Object)this.templateUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "SemanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "TemplateUrl": {
                return Optional.ofNullable(clazz.cast(this.templateUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudFormationTemplateResponse, T> g) {
        return obj -> g.apply((CreateCloudFormationTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String creationTime;
        private String expirationTime;
        private String semanticVersion;
        private String status;
        private String templateId;
        private String templateUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFormationTemplateResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.creationTime(model.creationTime);
            this.expirationTime(model.expirationTime);
            this.semanticVersion(model.semanticVersion);
            this.status(model.status);
            this.templateId(model.templateId);
            this.templateUrl(model.templateUrl);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public final Builder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public final String getTemplateUrl() {
            return this.templateUrl;
        }

        @Override
        public final Builder templateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        public final void setTemplateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
        }

        @Override
        public CreateCloudFormationTemplateResponse build() {
            return new CreateCloudFormationTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCloudFormationTemplateResponse> {
        public Builder applicationId(String var1);

        public Builder creationTime(String var1);

        public Builder expirationTime(String var1);

        public Builder semanticVersion(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder templateId(String var1);

        public Builder templateUrl(String var1);
    }
}

