/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The supported source types from which logs and events are collected in Amazon Security Lake. For the list of
 * supported Amazon Web Services, see the <a
 * href="https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html">Amazon Security Lake User
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogSourceResource implements SdkPojo, Serializable,
        ToCopyableBuilder<LogSourceResource.Builder, LogSourceResource> {
    private static final SdkField<AwsLogSourceResource> AWS_LOG_SOURCE_FIELD = SdkField
            .<AwsLogSourceResource> builder(MarshallingType.SDK_POJO).memberName("awsLogSource")
            .getter(getter(LogSourceResource::awsLogSource)).setter(setter(Builder::awsLogSource))
            .constructor(AwsLogSourceResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLogSource").build()).build();

    private static final SdkField<CustomLogSourceResource> CUSTOM_LOG_SOURCE_FIELD = SdkField
            .<CustomLogSourceResource> builder(MarshallingType.SDK_POJO).memberName("customLogSource")
            .getter(getter(LogSourceResource::customLogSource)).setter(setter(Builder::customLogSource))
            .constructor(CustomLogSourceResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLogSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_LOG_SOURCE_FIELD,
            CUSTOM_LOG_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsLogSourceResource awsLogSource;

    private final CustomLogSourceResource customLogSource;

    private final Type type;

    private LogSourceResource(BuilderImpl builder) {
        this.awsLogSource = builder.awsLogSource;
        this.customLogSource = builder.customLogSource;
        this.type = builder.type;
    }

    /**
     * <p>
     * Amazon Security Lake supports log and event collection for natively supported Amazon Web Services.
     * </p>
     * 
     * @return Amazon Security Lake supports log and event collection for natively supported Amazon Web Services.
     */
    public final AwsLogSourceResource awsLogSource() {
        return awsLogSource;
    }

    /**
     * <p>
     * Amazon Security Lake supports custom source types. For a detailed list, see the Amazon Security Lake User Guide.
     * </p>
     * 
     * @return Amazon Security Lake supports custom source types. For a detailed list, see the Amazon Security Lake User
     *         Guide.
     */
    public final CustomLogSourceResource customLogSource() {
        return customLogSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsLogSource());
        hashCode = 31 * hashCode + Objects.hashCode(customLogSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogSourceResource)) {
            return false;
        }
        LogSourceResource other = (LogSourceResource) obj;
        return Objects.equals(awsLogSource(), other.awsLogSource()) && Objects.equals(customLogSource(), other.customLogSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogSourceResource").add("AwsLogSource", awsLogSource())
                .add("CustomLogSource", customLogSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsLogSource":
            return Optional.ofNullable(clazz.cast(awsLogSource()));
        case "customLogSource":
            return Optional.ofNullable(clazz.cast(customLogSource()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #awsLogSource()} initialized to the given value.
     *
     * <p>
     * Amazon Security Lake supports log and event collection for natively supported Amazon Web Services.
     * </p>
     * 
     * @param awsLogSource
     *        Amazon Security Lake supports log and event collection for natively supported Amazon Web Services.
     */
    public static LogSourceResource fromAwsLogSource(AwsLogSourceResource awsLogSource) {
        return builder().awsLogSource(awsLogSource).build();
    }

    /**
     * Create an instance of this class with {@link #awsLogSource()} initialized to the given value.
     *
     * <p>
     * Amazon Security Lake supports log and event collection for natively supported Amazon Web Services.
     * </p>
     * 
     * @param awsLogSource
     *        Amazon Security Lake supports log and event collection for natively supported Amazon Web Services.
     */
    public static LogSourceResource fromAwsLogSource(Consumer<AwsLogSourceResource.Builder> awsLogSource) {
        AwsLogSourceResource.Builder builder = AwsLogSourceResource.builder();
        awsLogSource.accept(builder);
        return fromAwsLogSource(builder.build());
    }

    /**
     * Create an instance of this class with {@link #customLogSource()} initialized to the given value.
     *
     * <p>
     * Amazon Security Lake supports custom source types. For a detailed list, see the Amazon Security Lake User Guide.
     * </p>
     * 
     * @param customLogSource
     *        Amazon Security Lake supports custom source types. For a detailed list, see the Amazon Security Lake User
     *        Guide.
     */
    public static LogSourceResource fromCustomLogSource(CustomLogSourceResource customLogSource) {
        return builder().customLogSource(customLogSource).build();
    }

    /**
     * Create an instance of this class with {@link #customLogSource()} initialized to the given value.
     *
     * <p>
     * Amazon Security Lake supports custom source types. For a detailed list, see the Amazon Security Lake User Guide.
     * </p>
     * 
     * @param customLogSource
     *        Amazon Security Lake supports custom source types. For a detailed list, see the Amazon Security Lake User
     *        Guide.
     */
    public static LogSourceResource fromCustomLogSource(Consumer<CustomLogSourceResource.Builder> customLogSource) {
        CustomLogSourceResource.Builder builder = CustomLogSourceResource.builder();
        customLogSource.accept(builder);
        return fromCustomLogSource(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogSourceResource, T> g) {
        return obj -> g.apply((LogSourceResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogSourceResource> {
        /**
         * <p>
         * Amazon Security Lake supports log and event collection for natively supported Amazon Web Services.
         * </p>
         * 
         * @param awsLogSource
         *        Amazon Security Lake supports log and event collection for natively supported Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLogSource(AwsLogSourceResource awsLogSource);

        /**
         * <p>
         * Amazon Security Lake supports log and event collection for natively supported Amazon Web Services.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsLogSourceResource.Builder} avoiding
         * the need to create one manually via {@link AwsLogSourceResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsLogSourceResource.Builder#build()} is called immediately and
         * its result is passed to {@link #awsLogSource(AwsLogSourceResource)}.
         * 
         * @param awsLogSource
         *        a consumer that will call methods on {@link AwsLogSourceResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLogSource(AwsLogSourceResource)
         */
        default Builder awsLogSource(Consumer<AwsLogSourceResource.Builder> awsLogSource) {
            return awsLogSource(AwsLogSourceResource.builder().applyMutation(awsLogSource).build());
        }

        /**
         * <p>
         * Amazon Security Lake supports custom source types. For a detailed list, see the Amazon Security Lake User
         * Guide.
         * </p>
         * 
         * @param customLogSource
         *        Amazon Security Lake supports custom source types. For a detailed list, see the Amazon Security Lake
         *        User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLogSource(CustomLogSourceResource customLogSource);

        /**
         * <p>
         * Amazon Security Lake supports custom source types. For a detailed list, see the Amazon Security Lake User
         * Guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomLogSourceResource.Builder} avoiding
         * the need to create one manually via {@link CustomLogSourceResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLogSourceResource.Builder#build()} is called immediately
         * and its result is passed to {@link #customLogSource(CustomLogSourceResource)}.
         * 
         * @param customLogSource
         *        a consumer that will call methods on {@link CustomLogSourceResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customLogSource(CustomLogSourceResource)
         */
        default Builder customLogSource(Consumer<CustomLogSourceResource.Builder> customLogSource) {
            return customLogSource(CustomLogSourceResource.builder().applyMutation(customLogSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsLogSourceResource awsLogSource;

        private CustomLogSourceResource customLogSource;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(LogSourceResource model) {
            awsLogSource(model.awsLogSource);
            customLogSource(model.customLogSource);
        }

        public final AwsLogSourceResource.Builder getAwsLogSource() {
            return awsLogSource != null ? awsLogSource.toBuilder() : null;
        }

        public final void setAwsLogSource(AwsLogSourceResource.BuilderImpl awsLogSource) {
            Object oldValue = this.awsLogSource;
            this.awsLogSource = awsLogSource != null ? awsLogSource.build() : null;
            handleUnionValueChange(Type.AWS_LOG_SOURCE, oldValue, this.awsLogSource);
        }

        @Override
        public final Builder awsLogSource(AwsLogSourceResource awsLogSource) {
            Object oldValue = this.awsLogSource;
            this.awsLogSource = awsLogSource;
            handleUnionValueChange(Type.AWS_LOG_SOURCE, oldValue, this.awsLogSource);
            return this;
        }

        public final CustomLogSourceResource.Builder getCustomLogSource() {
            return customLogSource != null ? customLogSource.toBuilder() : null;
        }

        public final void setCustomLogSource(CustomLogSourceResource.BuilderImpl customLogSource) {
            Object oldValue = this.customLogSource;
            this.customLogSource = customLogSource != null ? customLogSource.build() : null;
            handleUnionValueChange(Type.CUSTOM_LOG_SOURCE, oldValue, this.customLogSource);
        }

        @Override
        public final Builder customLogSource(CustomLogSourceResource customLogSource) {
            Object oldValue = this.customLogSource;
            this.customLogSource = customLogSource;
            handleUnionValueChange(Type.CUSTOM_LOG_SOURCE, oldValue, this.customLogSource);
            return this;
        }

        @Override
        public LogSourceResource build() {
            return new LogSourceResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see LogSourceResource#type()
     */
    public enum Type {
        AWS_LOG_SOURCE,

        CUSTOM_LOG_SOURCE,

        UNKNOWN_TO_SDK_VERSION
    }
}
