/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon Security Lake can collect logs and events from natively-supported Amazon Web Services services and custom
 * sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogSource implements SdkPojo, Serializable, ToCopyableBuilder<LogSource.Builder, LogSource> {
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("account")
            .getter(getter(LogSource::account)).setter(setter(Builder::account))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("account").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(LogSource::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<List<LogSourceResource>> SOURCES_FIELD = SdkField
            .<List<LogSourceResource>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(LogSource::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogSourceResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogSourceResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD, REGION_FIELD,
            SOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String account;

    private final String region;

    private final List<LogSourceResource> sources;

    private LogSource(BuilderImpl builder) {
        this.account = builder.account;
        this.region = builder.region;
        this.sources = builder.sources;
    }

    /**
     * <p>
     * Specify the account from which you want to collect logs.
     * </p>
     * 
     * @return Specify the account from which you want to collect logs.
     */
    public final String account() {
        return account;
    }

    /**
     * <p>
     * Specify the Regions from which you want to collect logs.
     * </p>
     * 
     * @return Specify the Regions from which you want to collect logs.
     */
    public final String region() {
        return region;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the sources from which you want to collect logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return Specify the sources from which you want to collect logs.
     */
    public final List<LogSourceResource> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogSource)) {
            return false;
        }
        LogSource other = (LogSource) obj;
        return Objects.equals(account(), other.account()) && Objects.equals(region(), other.region())
                && hasSources() == other.hasSources() && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogSource").add("Account", account()).add("Region", region())
                .add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "account":
            return Optional.ofNullable(clazz.cast(account()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogSource, T> g) {
        return obj -> g.apply((LogSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogSource> {
        /**
         * <p>
         * Specify the account from which you want to collect logs.
         * </p>
         * 
         * @param account
         *        Specify the account from which you want to collect logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * Specify the Regions from which you want to collect logs.
         * </p>
         * 
         * @param region
         *        Specify the Regions from which you want to collect logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Specify the sources from which you want to collect logs.
         * </p>
         * 
         * @param sources
         *        Specify the sources from which you want to collect logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<LogSourceResource> sources);

        /**
         * <p>
         * Specify the sources from which you want to collect logs.
         * </p>
         * 
         * @param sources
         *        Specify the sources from which you want to collect logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(LogSourceResource... sources);

        /**
         * <p>
         * Specify the sources from which you want to collect logs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.LogSourceResource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securitylake.model.LogSourceResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.LogSourceResource.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<LogSourceResource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.LogSourceResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<LogSourceResource>)
         */
        Builder sources(Consumer<LogSourceResource.Builder>... sources);
    }

    static final class BuilderImpl implements Builder {
        private String account;

        private String region;

        private List<LogSourceResource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LogSource model) {
            account(model.account);
            region(model.region);
            sources(model.sources);
        }

        public final String getAccount() {
            return account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final List<LogSourceResource.Builder> getSources() {
            List<LogSourceResource.Builder> result = LogSourceResourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<LogSourceResource.BuilderImpl> sources) {
            this.sources = LogSourceResourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<LogSourceResource> sources) {
            this.sources = LogSourceResourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(LogSourceResource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<LogSourceResource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> LogSourceResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LogSource build() {
            return new LogSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
