/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.model.FindingHistoryRecord;
import software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest;
import software.amazon.awssdk.services.securityhub.model.GetFindingHistoryResponse;

public class GetFindingHistoryIterable
implements SdkIterable<GetFindingHistoryResponse> {
    private final SecurityHubClient client;
    private final GetFindingHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetFindingHistoryIterable(SecurityHubClient client, GetFindingHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetFindingHistoryResponseFetcher();
    }

    public Iterator<GetFindingHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FindingHistoryRecord> records() {
        Function<GetFindingHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.records() != null) {
                return response.records().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetFindingHistoryResponseFetcher
    implements SyncPageFetcher<GetFindingHistoryResponse> {
        private GetFindingHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetFindingHistoryResponse nextPage(GetFindingHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetFindingHistoryIterable.this.client.getFindingHistory(GetFindingHistoryIterable.this.firstRequest);
            }
            return GetFindingHistoryIterable.this.client.getFindingHistory((GetFindingHistoryRequest)((Object)GetFindingHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

