/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.Standard;

public class DescribeStandardsIterable
implements SdkIterable<DescribeStandardsResponse> {
    private final SecurityHubClient client;
    private final DescribeStandardsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeStandardsIterable(SecurityHubClient client, DescribeStandardsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeStandardsResponseFetcher();
    }

    public Iterator<DescribeStandardsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Standard> standards() {
        Function<DescribeStandardsResponse, Iterator> getIterator = response -> {
            if (response != null && response.standards() != null) {
                return response.standards().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeStandardsResponseFetcher
    implements SyncPageFetcher<DescribeStandardsResponse> {
        private DescribeStandardsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStandardsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeStandardsResponse nextPage(DescribeStandardsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStandardsIterable.this.client.describeStandards(DescribeStandardsIterable.this.firstRequest);
            }
            return DescribeStandardsIterable.this.client.describeStandards((DescribeStandardsRequest)((Object)DescribeStandardsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

