/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2LaunchTemplateDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2LaunchTemplateDetails> {
    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchTemplateName").getter(AwsEc2LaunchTemplateDetails.getter(AwsEc2LaunchTemplateDetails::launchTemplateName)).setter(AwsEc2LaunchTemplateDetails.setter(Builder::launchTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AwsEc2LaunchTemplateDetails.getter(AwsEc2LaunchTemplateDetails::id)).setter(AwsEc2LaunchTemplateDetails.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<AwsEc2LaunchTemplateDataDetails> LAUNCH_TEMPLATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplateData").getter(AwsEc2LaunchTemplateDetails.getter(AwsEc2LaunchTemplateDetails::launchTemplateData)).setter(AwsEc2LaunchTemplateDetails.setter(Builder::launchTemplateData)).constructor(AwsEc2LaunchTemplateDataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateData").build()}).build();
    private static final SdkField<Long> DEFAULT_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DefaultVersionNumber").getter(AwsEc2LaunchTemplateDetails.getter(AwsEc2LaunchTemplateDetails::defaultVersionNumber)).setter(AwsEc2LaunchTemplateDetails.setter(Builder::defaultVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionNumber").build()}).build();
    private static final SdkField<Long> LATEST_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LatestVersionNumber").getter(AwsEc2LaunchTemplateDetails.getter(AwsEc2LaunchTemplateDetails::latestVersionNumber)).setter(AwsEc2LaunchTemplateDetails.setter(Builder::latestVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_NAME_FIELD, ID_FIELD, LAUNCH_TEMPLATE_DATA_FIELD, DEFAULT_VERSION_NUMBER_FIELD, LATEST_VERSION_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String launchTemplateName;
    private final String id;
    private final AwsEc2LaunchTemplateDataDetails launchTemplateData;
    private final Long defaultVersionNumber;
    private final Long latestVersionNumber;

    private AwsEc2LaunchTemplateDetails(BuilderImpl builder) {
        this.launchTemplateName = builder.launchTemplateName;
        this.id = builder.id;
        this.launchTemplateData = builder.launchTemplateData;
        this.defaultVersionNumber = builder.defaultVersionNumber;
        this.latestVersionNumber = builder.latestVersionNumber;
    }

    public final String launchTemplateName() {
        return this.launchTemplateName;
    }

    public final String id() {
        return this.id;
    }

    public final AwsEc2LaunchTemplateDataDetails launchTemplateData() {
        return this.launchTemplateData;
    }

    public final Long defaultVersionNumber() {
        return this.defaultVersionNumber;
    }

    public final Long latestVersionNumber() {
        return this.latestVersionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDetails other = (AwsEc2LaunchTemplateDetails)obj;
        return Objects.equals(this.launchTemplateName(), other.launchTemplateName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.launchTemplateData(), other.launchTemplateData()) && Objects.equals(this.defaultVersionNumber(), other.defaultVersionNumber()) && Objects.equals(this.latestVersionNumber(), other.latestVersionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2LaunchTemplateDetails").add("LaunchTemplateName", (Object)this.launchTemplateName()).add("Id", (Object)this.id()).add("LaunchTemplateData", (Object)this.launchTemplateData()).add("DefaultVersionNumber", (Object)this.defaultVersionNumber()).add("LatestVersionNumber", (Object)this.latestVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateName": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateName()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LaunchTemplateData": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateData()));
            }
            case "DefaultVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionNumber()));
            }
            case "LatestVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.latestVersionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String launchTemplateName;
        private String id;
        private AwsEc2LaunchTemplateDataDetails launchTemplateData;
        private Long defaultVersionNumber;
        private Long latestVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDetails model) {
            this.launchTemplateName(model.launchTemplateName);
            this.id(model.id);
            this.launchTemplateData(model.launchTemplateData);
            this.defaultVersionNumber(model.defaultVersionNumber);
            this.latestVersionNumber(model.latestVersionNumber);
        }

        public final String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final AwsEc2LaunchTemplateDataDetails.Builder getLaunchTemplateData() {
            return this.launchTemplateData != null ? this.launchTemplateData.toBuilder() : null;
        }

        public final void setLaunchTemplateData(AwsEc2LaunchTemplateDataDetails.BuilderImpl launchTemplateData) {
            this.launchTemplateData = launchTemplateData != null ? launchTemplateData.build() : null;
        }

        @Override
        public final Builder launchTemplateData(AwsEc2LaunchTemplateDataDetails launchTemplateData) {
            this.launchTemplateData = launchTemplateData;
            return this;
        }

        public final Long getDefaultVersionNumber() {
            return this.defaultVersionNumber;
        }

        public final void setDefaultVersionNumber(Long defaultVersionNumber) {
            this.defaultVersionNumber = defaultVersionNumber;
        }

        @Override
        public final Builder defaultVersionNumber(Long defaultVersionNumber) {
            this.defaultVersionNumber = defaultVersionNumber;
            return this;
        }

        public final Long getLatestVersionNumber() {
            return this.latestVersionNumber;
        }

        public final void setLatestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
        }

        @Override
        public final Builder latestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        public AwsEc2LaunchTemplateDetails build() {
            return new AwsEc2LaunchTemplateDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2LaunchTemplateDetails> {
        public Builder launchTemplateName(String var1);

        public Builder id(String var1);

        public Builder launchTemplateData(AwsEc2LaunchTemplateDataDetails var1);

        default public Builder launchTemplateData(Consumer<AwsEc2LaunchTemplateDataDetails.Builder> launchTemplateData) {
            return this.launchTemplateData((AwsEc2LaunchTemplateDataDetails)((AwsEc2LaunchTemplateDataDetails.Builder)AwsEc2LaunchTemplateDataDetails.builder().applyMutation(launchTemplateData)).build());
        }

        public Builder defaultVersionNumber(Long var1);

        public Builder latestVersionNumber(Long var1);
    }
}

