/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.schemas.DefaultSchemasAsyncClient;
import software.amazon.awssdk.services.schemas.DefaultSchemasBaseClientBuilder;
import software.amazon.awssdk.services.schemas.SchemasAsyncClient;
import software.amazon.awssdk.services.schemas.SchemasAsyncClientBuilder;
import software.amazon.awssdk.services.schemas.SchemasServiceClientConfiguration;
import software.amazon.awssdk.services.schemas.endpoints.SchemasEndpointProvider;

@SdkInternalApi
final class DefaultSchemasAsyncClientBuilder
extends DefaultSchemasBaseClientBuilder<SchemasAsyncClientBuilder, SchemasAsyncClient>
implements SchemasAsyncClientBuilder {
    DefaultSchemasAsyncClientBuilder() {
    }

    @Override
    public DefaultSchemasAsyncClientBuilder endpointProvider(SchemasEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SchemasAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSchemasAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SchemasServiceClientConfiguration serviceClientConfiguration = SchemasServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSchemasAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

