/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.scheduler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>RetryPolicy</code> object that includes information about the retry policy settings, including the maximum
 * age of an event, and the maximum number of times EventBridge Scheduler will try to deliver the event to a target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryPolicy implements SdkPojo, Serializable, ToCopyableBuilder<RetryPolicy.Builder, RetryPolicy> {
    private static final SdkField<Integer> MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumEventAgeInSeconds")
            .getter(getter(RetryPolicy::maximumEventAgeInSeconds)).setter(setter(Builder::maximumEventAgeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEventAgeInSeconds").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumRetryAttempts").getter(getter(RetryPolicy::maximumRetryAttempts))
            .setter(setter(Builder::maximumRetryAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maximumEventAgeInSeconds;

    private final Integer maximumRetryAttempts;

    private RetryPolicy(BuilderImpl builder) {
        this.maximumEventAgeInSeconds = builder.maximumEventAgeInSeconds;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
    }

    /**
     * <p>
     * The maximum amount of time, in seconds, to continue to make retry attempts.
     * </p>
     * 
     * @return The maximum amount of time, in seconds, to continue to make retry attempts.
     */
    public final Integer maximumEventAgeInSeconds() {
        return maximumEventAgeInSeconds;
    }

    /**
     * <p>
     * The maximum number of retry attempts to make before the request fails. Retry attempts with exponential backoff
     * continue until either the maximum number of attempts is made or until the duration of the
     * <code>MaximumEventAgeInSeconds</code> is reached.
     * </p>
     * 
     * @return The maximum number of retry attempts to make before the request fails. Retry attempts with exponential
     *         backoff continue until either the maximum number of attempts is made or until the duration of the
     *         <code>MaximumEventAgeInSeconds</code> is reached.
     */
    public final Integer maximumRetryAttempts() {
        return maximumRetryAttempts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumEventAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRetryAttempts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryPolicy)) {
            return false;
        }
        RetryPolicy other = (RetryPolicy) obj;
        return Objects.equals(maximumEventAgeInSeconds(), other.maximumEventAgeInSeconds())
                && Objects.equals(maximumRetryAttempts(), other.maximumRetryAttempts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetryPolicy").add("MaximumEventAgeInSeconds", maximumEventAgeInSeconds())
                .add("MaximumRetryAttempts", maximumRetryAttempts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumEventAgeInSeconds":
            return Optional.ofNullable(clazz.cast(maximumEventAgeInSeconds()));
        case "MaximumRetryAttempts":
            return Optional.ofNullable(clazz.cast(maximumRetryAttempts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryPolicy, T> g) {
        return obj -> g.apply((RetryPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetryPolicy> {
        /**
         * <p>
         * The maximum amount of time, in seconds, to continue to make retry attempts.
         * </p>
         * 
         * @param maximumEventAgeInSeconds
         *        The maximum amount of time, in seconds, to continue to make retry attempts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumEventAgeInSeconds(Integer maximumEventAgeInSeconds);

        /**
         * <p>
         * The maximum number of retry attempts to make before the request fails. Retry attempts with exponential
         * backoff continue until either the maximum number of attempts is made or until the duration of the
         * <code>MaximumEventAgeInSeconds</code> is reached.
         * </p>
         * 
         * @param maximumRetryAttempts
         *        The maximum number of retry attempts to make before the request fails. Retry attempts with exponential
         *        backoff continue until either the maximum number of attempts is made or until the duration of the
         *        <code>MaximumEventAgeInSeconds</code> is reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRetryAttempts(Integer maximumRetryAttempts);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumEventAgeInSeconds;

        private Integer maximumRetryAttempts;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryPolicy model) {
            maximumEventAgeInSeconds(model.maximumEventAgeInSeconds);
            maximumRetryAttempts(model.maximumRetryAttempts);
        }

        public final Integer getMaximumEventAgeInSeconds() {
            return maximumEventAgeInSeconds;
        }

        public final void setMaximumEventAgeInSeconds(Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
        }

        @Override
        public final Builder maximumEventAgeInSeconds(Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        @Override
        public RetryPolicy build() {
            return new RetryPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
