/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.OutputResolutionStackInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.StringListInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackConfigInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackConfigInput> {
    private static final SdkField<OutputResolutionStackInput> OUTPUT_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputResolution").getter(StackConfigInput.getter(StackConfigInput::outputResolution)).setter(StackConfigInput.setter(Builder::outputResolution)).constructor(OutputResolutionStackInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputResolution").build()}).build();
    private static final SdkField<List<String>> TARGET_BANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetBands").getter(StackConfigInput.getter(StackConfigInput::targetBands)).setter(StackConfigInput.setter(Builder::targetBands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_RESOLUTION_FIELD, TARGET_BANDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final OutputResolutionStackInput outputResolution;
    private final List<String> targetBands;

    private StackConfigInput(BuilderImpl builder) {
        this.outputResolution = builder.outputResolution;
        this.targetBands = builder.targetBands;
    }

    public final OutputResolutionStackInput outputResolution() {
        return this.outputResolution;
    }

    public final boolean hasTargetBands() {
        return this.targetBands != null && !(this.targetBands instanceof SdkAutoConstructList);
    }

    public final List<String> targetBands() {
        return this.targetBands;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputResolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetBands() ? this.targetBands() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackConfigInput)) {
            return false;
        }
        StackConfigInput other = (StackConfigInput)obj;
        return Objects.equals(this.outputResolution(), other.outputResolution()) && this.hasTargetBands() == other.hasTargetBands() && Objects.equals(this.targetBands(), other.targetBands());
    }

    public final String toString() {
        return ToString.builder((String)"StackConfigInput").add("OutputResolution", (Object)this.outputResolution()).add("TargetBands", this.hasTargetBands() ? this.targetBands() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputResolution": {
                return Optional.ofNullable(clazz.cast(this.outputResolution()));
            }
            case "TargetBands": {
                return Optional.ofNullable(clazz.cast(this.targetBands()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackConfigInput, T> g) {
        return obj -> g.apply((StackConfigInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OutputResolutionStackInput outputResolution;
        private List<String> targetBands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StackConfigInput model) {
            this.outputResolution(model.outputResolution);
            this.targetBands(model.targetBands);
        }

        public final OutputResolutionStackInput.Builder getOutputResolution() {
            return this.outputResolution != null ? this.outputResolution.toBuilder() : null;
        }

        public final void setOutputResolution(OutputResolutionStackInput.BuilderImpl outputResolution) {
            this.outputResolution = outputResolution != null ? outputResolution.build() : null;
        }

        @Override
        public final Builder outputResolution(OutputResolutionStackInput outputResolution) {
            this.outputResolution = outputResolution;
            return this;
        }

        public final Collection<String> getTargetBands() {
            if (this.targetBands instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetBands;
        }

        public final void setTargetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
        }

        @Override
        public final Builder targetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBands(String ... targetBands) {
            this.targetBands(Arrays.asList(targetBands));
            return this;
        }

        public StackConfigInput build() {
            return new StackConfigInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackConfigInput> {
        public Builder outputResolution(OutputResolutionStackInput var1);

        default public Builder outputResolution(Consumer<OutputResolutionStackInput.Builder> outputResolution) {
            return this.outputResolution((OutputResolutionStackInput)((OutputResolutionStackInput.Builder)OutputResolutionStackInput.builder().applyMutation(outputResolution)).build());
        }

        public Builder targetBands(Collection<String> var1);

        public Builder targetBands(String ... var1);
    }
}

