/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ZonalStatistics {
    MEAN("MEAN"),
    MEDIAN("MEDIAN"),
    STANDARD_DEVIATION("STANDARD_DEVIATION"),
    MAX("MAX"),
    MIN("MIN"),
    SUM("SUM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ZonalStatistics> VALUE_MAP;
    private final String value;

    private ZonalStatistics(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ZonalStatistics fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ZonalStatistics> knownValues() {
        EnumSet<ZonalStatistics> knownValues = EnumSet.allOf(ZonalStatistics.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ZonalStatistics.class, ZonalStatistics::toString);
    }
}

