/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * OutputResolution Configuration indicating the target resolution for the output of Resampling operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputResolutionResamplingInput implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputResolutionResamplingInput.Builder, OutputResolutionResamplingInput> {
    private static final SdkField<UserDefined> USER_DEFINED_FIELD = SdkField.<UserDefined> builder(MarshallingType.SDK_POJO)
            .memberName("UserDefined").getter(getter(OutputResolutionResamplingInput::userDefined))
            .setter(setter(Builder::userDefined)).constructor(UserDefined::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefined").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_DEFINED_FIELD));

    private static final long serialVersionUID = 1L;

    private final UserDefined userDefined;

    private OutputResolutionResamplingInput(BuilderImpl builder) {
        this.userDefined = builder.userDefined;
    }

    /**
     * <p>
     * User Defined Resolution for the output of Resampling operation defined by value and unit.
     * </p>
     * 
     * @return User Defined Resolution for the output of Resampling operation defined by value and unit.
     */
    public final UserDefined userDefined() {
        return userDefined;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userDefined());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputResolutionResamplingInput)) {
            return false;
        }
        OutputResolutionResamplingInput other = (OutputResolutionResamplingInput) obj;
        return Objects.equals(userDefined(), other.userDefined());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputResolutionResamplingInput").add("UserDefined", userDefined()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserDefined":
            return Optional.ofNullable(clazz.cast(userDefined()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputResolutionResamplingInput, T> g) {
        return obj -> g.apply((OutputResolutionResamplingInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputResolutionResamplingInput> {
        /**
         * <p>
         * User Defined Resolution for the output of Resampling operation defined by value and unit.
         * </p>
         * 
         * @param userDefined
         *        User Defined Resolution for the output of Resampling operation defined by value and unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefined(UserDefined userDefined);

        /**
         * <p>
         * User Defined Resolution for the output of Resampling operation defined by value and unit.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserDefined.Builder} avoiding the need to
         * create one manually via {@link UserDefined#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserDefined.Builder#build()} is called immediately and its result
         * is passed to {@link #userDefined(UserDefined)}.
         * 
         * @param userDefined
         *        a consumer that will call methods on {@link UserDefined.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userDefined(UserDefined)
         */
        default Builder userDefined(Consumer<UserDefined.Builder> userDefined) {
            return userDefined(UserDefined.builder().applyMutation(userDefined).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UserDefined userDefined;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputResolutionResamplingInput model) {
            userDefined(model.userDefined);
        }

        public final UserDefined.Builder getUserDefined() {
            return userDefined != null ? userDefined.toBuilder() : null;
        }

        public final void setUserDefined(UserDefined.BuilderImpl userDefined) {
            this.userDefined = userDefined != null ? userDefined.build() : null;
        }

        @Override
        public final Builder userDefined(UserDefined userDefined) {
            this.userDefined = userDefined;
            return this;
        }

        @Override
        public OutputResolutionResamplingInput build() {
            return new OutputResolutionResamplingInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
