/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakeredge.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakeredge.model.EdgeDeployment;
import software.amazon.awssdk.services.sagemakeredge.model.EdgeDeploymentsCopier;
import software.amazon.awssdk.services.sagemakeredge.model.SagemakerEdgeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeploymentsResponse
extends SagemakerEdgeResponse
implements ToCopyableBuilder<Builder, GetDeploymentsResponse> {
    private static final SdkField<List<EdgeDeployment>> DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Deployments").getter(GetDeploymentsResponse.getter(GetDeploymentsResponse::deployments)).setter(GetDeploymentsResponse.setter(Builder::deployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EdgeDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENTS_FIELD));
    private final List<EdgeDeployment> deployments;

    private GetDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.deployments = builder.deployments;
    }

    public final boolean hasDeployments() {
        return this.deployments != null && !(this.deployments instanceof SdkAutoConstructList);
    }

    public final List<EdgeDeployment> deployments() {
        return this.deployments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeployments() ? this.deployments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentsResponse)) {
            return false;
        }
        GetDeploymentsResponse other = (GetDeploymentsResponse)((Object)obj);
        return this.hasDeployments() == other.hasDeployments() && Objects.equals(this.deployments(), other.deployments());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeploymentsResponse").add("Deployments", this.hasDeployments() ? this.deployments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Deployments": {
                return Optional.ofNullable(clazz.cast(this.deployments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentsResponse, T> g) {
        return obj -> g.apply((GetDeploymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SagemakerEdgeResponse.BuilderImpl
    implements Builder {
        private List<EdgeDeployment> deployments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentsResponse model) {
            super(model);
            this.deployments(model.deployments);
        }

        public final List<EdgeDeployment.Builder> getDeployments() {
            List<EdgeDeployment.Builder> result = EdgeDeploymentsCopier.copyToBuilder(this.deployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeployments(Collection<EdgeDeployment.BuilderImpl> deployments) {
            this.deployments = EdgeDeploymentsCopier.copyFromBuilder(deployments);
        }

        @Override
        public final Builder deployments(Collection<EdgeDeployment> deployments) {
            this.deployments = EdgeDeploymentsCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(EdgeDeployment ... deployments) {
            this.deployments(Arrays.asList(deployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Consumer<EdgeDeployment.Builder> ... deployments) {
            this.deployments(Stream.of(deployments).map(c -> (EdgeDeployment)((EdgeDeployment.Builder)EdgeDeployment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDeploymentsResponse build() {
            return new GetDeploymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SagemakerEdgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeploymentsResponse> {
        public Builder deployments(Collection<EdgeDeployment> var1);

        public Builder deployments(EdgeDeployment ... var1);

        public Builder deployments(Consumer<EdgeDeployment.Builder> ... var1);
    }
}

