/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The collection of settings used by an AutoML job V2 for the text generation problem type.
 * </p>
 * <note>
 * <p>
 * The text generation models that support fine-tuning in Autopilot are currently accessible exclusively in regions
 * supported by Canvas. Refer to the documentation of Canvas for the <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html">full list of its supported Regions</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextGenerationJobConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TextGenerationJobConfig.Builder, TextGenerationJobConfig> {
    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField
            .<AutoMLJobCompletionCriteria> builder(MarshallingType.SDK_POJO).memberName("CompletionCriteria")
            .getter(getter(TextGenerationJobConfig::completionCriteria)).setter(setter(Builder::completionCriteria))
            .constructor(AutoMLJobCompletionCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build())
            .build();

    private static final SdkField<String> BASE_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseModelName").getter(getter(TextGenerationJobConfig::baseModelName))
            .setter(setter(Builder::baseModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseModelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_CRITERIA_FIELD,
            BASE_MODEL_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoMLJobCompletionCriteria completionCriteria;

    private final String baseModelName;

    private TextGenerationJobConfig(BuilderImpl builder) {
        this.completionCriteria = builder.completionCriteria;
        this.baseModelName = builder.baseModelName;
    }

    /**
     * Returns the value of the CompletionCriteria property for this object.
     * 
     * @return The value of the CompletionCriteria property for this object.
     */
    public final AutoMLJobCompletionCriteria completionCriteria() {
        return completionCriteria;
    }

    /**
     * <p>
     * The name of the base model to fine-tune. Autopilot supports fine-tuning a variety of large language models. For
     * information on the list of supported models, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/src/AWSIronmanApiDoc/build/server-root/sagemaker/latest/dg/llms-finetuning-models.html#llms-finetuning-supported-llms"
     * >Text generation models supporting fine-tuning in Autopilot</a>. If no <code>BaseModelName</code> is provided,
     * the default model used is Falcon-7B-Instruct.
     * </p>
     * 
     * @return The name of the base model to fine-tune. Autopilot supports fine-tuning a variety of large language
     *         models. For information on the list of supported models, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/src/AWSIronmanApiDoc/build/server-root/sagemaker/latest/dg/llms-finetuning-models.html#llms-finetuning-supported-llms"
     *         >Text generation models supporting fine-tuning in Autopilot</a>. If no <code>BaseModelName</code> is
     *         provided, the default model used is Falcon-7B-Instruct.
     */
    public final String baseModelName() {
        return baseModelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(baseModelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextGenerationJobConfig)) {
            return false;
        }
        TextGenerationJobConfig other = (TextGenerationJobConfig) obj;
        return Objects.equals(completionCriteria(), other.completionCriteria())
                && Objects.equals(baseModelName(), other.baseModelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextGenerationJobConfig").add("CompletionCriteria", completionCriteria())
                .add("BaseModelName", baseModelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompletionCriteria":
            return Optional.ofNullable(clazz.cast(completionCriteria()));
        case "BaseModelName":
            return Optional.ofNullable(clazz.cast(baseModelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextGenerationJobConfig, T> g) {
        return obj -> g.apply((TextGenerationJobConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextGenerationJobConfig> {
        /**
         * Sets the value of the CompletionCriteria property for this object.
         *
         * @param completionCriteria
         *        The new value for the CompletionCriteria property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria);

        /**
         * Sets the value of the CompletionCriteria property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AutoMLJobCompletionCriteria.Builder}
         * avoiding the need to create one manually via {@link AutoMLJobCompletionCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMLJobCompletionCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #completionCriteria(AutoMLJobCompletionCriteria)}.
         * 
         * @param completionCriteria
         *        a consumer that will call methods on {@link AutoMLJobCompletionCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #completionCriteria(AutoMLJobCompletionCriteria)
         */
        default Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return completionCriteria(AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria).build());
        }

        /**
         * <p>
         * The name of the base model to fine-tune. Autopilot supports fine-tuning a variety of large language models.
         * For information on the list of supported models, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/src/AWSIronmanApiDoc/build/server-root/sagemaker/latest/dg/llms-finetuning-models.html#llms-finetuning-supported-llms"
         * >Text generation models supporting fine-tuning in Autopilot</a>. If no <code>BaseModelName</code> is
         * provided, the default model used is Falcon-7B-Instruct.
         * </p>
         * 
         * @param baseModelName
         *        The name of the base model to fine-tune. Autopilot supports fine-tuning a variety of large language
         *        models. For information on the list of supported models, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/src/AWSIronmanApiDoc/build/server-root/sagemaker/latest/dg/llms-finetuning-models.html#llms-finetuning-supported-llms"
         *        >Text generation models supporting fine-tuning in Autopilot</a>. If no <code>BaseModelName</code> is
         *        provided, the default model used is Falcon-7B-Instruct.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseModelName(String baseModelName);
    }

    static final class BuilderImpl implements Builder {
        private AutoMLJobCompletionCriteria completionCriteria;

        private String baseModelName;

        private BuilderImpl() {
        }

        private BuilderImpl(TextGenerationJobConfig model) {
            completionCriteria(model.completionCriteria);
            baseModelName(model.baseModelName);
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return completionCriteria != null ? completionCriteria.toBuilder() : null;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final String getBaseModelName() {
            return baseModelName;
        }

        public final void setBaseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
        }

        @Override
        public final Builder baseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
            return this;
        }

        @Override
        public TextGenerationJobConfig build() {
            return new TextGenerationJobConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
