/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of the production variant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductionVariantStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductionVariantStatus.Builder, ProductionVariantStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ProductionVariantStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ProductionVariantStatus::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ProductionVariantStatus::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_MESSAGE_FIELD, START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String statusMessage;

    private final Instant startTime;

    private ProductionVariantStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The endpoint variant status which describes the current deployment stage status or operational status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Creating</code>: Creating inference resources for the production variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleting</code>: Terminating inference resources for the production variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Updating</code>: Updating capacity for the production variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ActivatingTraffic</code>: Turning on traffic for the production variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the automatic rollback configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VariantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The endpoint variant status which describes the current deployment stage status or operational
     *         status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Creating</code>: Creating inference resources for the production variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleting</code>: Terminating inference resources for the production variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Updating</code>: Updating capacity for the production variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ActivatingTraffic</code>: Turning on traffic for the production variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the automatic rollback
     *         configuration.
     *         </p>
     *         </li>
     * @see VariantStatus
     */
    public final VariantStatus status() {
        return VariantStatus.fromValue(status);
    }

    /**
     * <p>
     * The endpoint variant status which describes the current deployment stage status or operational status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Creating</code>: Creating inference resources for the production variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleting</code>: Terminating inference resources for the production variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Updating</code>: Updating capacity for the production variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ActivatingTraffic</code>: Turning on traffic for the production variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the automatic rollback configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VariantStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The endpoint variant status which describes the current deployment stage status or operational
     *         status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Creating</code>: Creating inference resources for the production variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleting</code>: Terminating inference resources for the production variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Updating</code>: Updating capacity for the production variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ActivatingTraffic</code>: Turning on traffic for the production variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the automatic rollback
     *         configuration.
     *         </p>
     *         </li>
     * @see VariantStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message that describes the status of the production variant.
     * </p>
     * 
     * @return A message that describes the status of the production variant.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The start time of the current status change.
     * </p>
     * 
     * @return The start time of the current status change.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantStatus)) {
            return false;
        }
        ProductionVariantStatus other = (ProductionVariantStatus) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProductionVariantStatus").add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantStatus, T> g) {
        return obj -> g.apply((ProductionVariantStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductionVariantStatus> {
        /**
         * <p>
         * The endpoint variant status which describes the current deployment stage status or operational status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Creating</code>: Creating inference resources for the production variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleting</code>: Terminating inference resources for the production variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Updating</code>: Updating capacity for the production variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ActivatingTraffic</code>: Turning on traffic for the production variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the automatic rollback configuration.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The endpoint variant status which describes the current deployment stage status or operational
         *        status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Creating</code>: Creating inference resources for the production variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleting</code>: Terminating inference resources for the production variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Updating</code>: Updating capacity for the production variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ActivatingTraffic</code>: Turning on traffic for the production variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the automatic rollback
         *        configuration.
         *        </p>
         *        </li>
         * @see VariantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VariantStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The endpoint variant status which describes the current deployment stage status or operational status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Creating</code>: Creating inference resources for the production variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleting</code>: Terminating inference resources for the production variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Updating</code>: Updating capacity for the production variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ActivatingTraffic</code>: Turning on traffic for the production variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the automatic rollback configuration.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The endpoint variant status which describes the current deployment stage status or operational
         *        status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Creating</code>: Creating inference resources for the production variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleting</code>: Terminating inference resources for the production variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Updating</code>: Updating capacity for the production variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ActivatingTraffic</code>: Turning on traffic for the production variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the automatic rollback
         *        configuration.
         *        </p>
         *        </li>
         * @see VariantStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VariantStatus
         */
        Builder status(VariantStatus status);

        /**
         * <p>
         * A message that describes the status of the production variant.
         * </p>
         * 
         * @param statusMessage
         *        A message that describes the status of the production variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The start time of the current status change.
         * </p>
         * 
         * @param startTime
         *        The start time of the current status change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String statusMessage;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantStatus model) {
            status(model.status);
            statusMessage(model.statusMessage);
            startTime(model.startTime);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VariantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public ProductionVariantStatus build() {
            return new ProductionVariantStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
