/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigDetails;

public class ListStudioLifecycleConfigsIterable
implements SdkIterable<ListStudioLifecycleConfigsResponse> {
    private final SageMakerClient client;
    private final ListStudioLifecycleConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStudioLifecycleConfigsIterable(SageMakerClient client, ListStudioLifecycleConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStudioLifecycleConfigsResponseFetcher();
    }

    public Iterator<ListStudioLifecycleConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StudioLifecycleConfigDetails> studioLifecycleConfigs() {
        Function<ListStudioLifecycleConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.studioLifecycleConfigs() != null) {
                return response.studioLifecycleConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStudioLifecycleConfigsResponseFetcher
    implements SyncPageFetcher<ListStudioLifecycleConfigsResponse> {
        private ListStudioLifecycleConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListStudioLifecycleConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStudioLifecycleConfigsResponse nextPage(ListStudioLifecycleConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListStudioLifecycleConfigsIterable.this.client.listStudioLifecycleConfigs(ListStudioLifecycleConfigsIterable.this.firstRequest);
            }
            return ListStudioLifecycleConfigsIterable.this.client.listStudioLifecycleConfigs((ListStudioLifecycleConfigsRequest)((Object)ListStudioLifecycleConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

