/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardsResponse;
import software.amazon.awssdk.services.sagemaker.model.ModelCardSummary;

public class ListModelCardsIterable
implements SdkIterable<ListModelCardsResponse> {
    private final SageMakerClient client;
    private final ListModelCardsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelCardsIterable(SageMakerClient client, ListModelCardsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListModelCardsResponseFetcher();
    }

    public Iterator<ListModelCardsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ModelCardSummary> modelCardSummaries() {
        Function<ListModelCardsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelCardSummaries() != null) {
                return response.modelCardSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelCardsResponseFetcher
    implements SyncPageFetcher<ListModelCardsResponse> {
        private ListModelCardsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelCardsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelCardsResponse nextPage(ListModelCardsResponse previousPage) {
            if (previousPage == null) {
                return ListModelCardsIterable.this.client.listModelCards(ListModelCardsIterable.this.firstRequest);
            }
            return ListModelCardsIterable.this.client.listModelCards((ListModelCardsRequest)((Object)ListModelCardsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

