/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAliasesResponse;

public class ListAliasesPublisher
implements SdkPublisher<ListAliasesResponse> {
    private final SageMakerAsyncClient client;
    private final ListAliasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAliasesPublisher(SageMakerAsyncClient client, ListAliasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAliasesPublisher(SageMakerAsyncClient client, ListAliasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAliasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAliasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> sageMakerImageVersionAliases() {
        Function<ListAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sageMakerImageVersionAliases() != null) {
                return response.sageMakerImageVersionAliases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAliasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAliasesResponseFetcher
    implements AsyncPageFetcher<ListAliasesResponse> {
        private ListAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAliasesResponse> nextPage(ListAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAliasesPublisher.this.client.listAliases(ListAliasesPublisher.this.firstRequest);
            }
            return ListAliasesPublisher.this.client.listAliases((ListAliasesRequest)((Object)ListAliasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

