/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelCardExportJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelCardExportJobSummary> {
    private static final SdkField<String> MODEL_CARD_EXPORT_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardExportJobName").getter(ModelCardExportJobSummary.getter(ModelCardExportJobSummary::modelCardExportJobName)).setter(ModelCardExportJobSummary.setter(Builder::modelCardExportJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobName").build()}).build();
    private static final SdkField<String> MODEL_CARD_EXPORT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardExportJobArn").getter(ModelCardExportJobSummary.getter(ModelCardExportJobSummary::modelCardExportJobArn)).setter(ModelCardExportJobSummary.setter(Builder::modelCardExportJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardExportJobArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ModelCardExportJobSummary.getter(ModelCardExportJobSummary::statusAsString)).setter(ModelCardExportJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelCardName").getter(ModelCardExportJobSummary.getter(ModelCardExportJobSummary::modelCardName)).setter(ModelCardExportJobSummary.setter(Builder::modelCardName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()}).build();
    private static final SdkField<Integer> MODEL_CARD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ModelCardVersion").getter(ModelCardExportJobSummary.getter(ModelCardExportJobSummary::modelCardVersion)).setter(ModelCardExportJobSummary.setter(Builder::modelCardVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardVersion").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ModelCardExportJobSummary.getter(ModelCardExportJobSummary::createdAt)).setter(ModelCardExportJobSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedAt").getter(ModelCardExportJobSummary.getter(ModelCardExportJobSummary::lastModifiedAt)).setter(ModelCardExportJobSummary.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_EXPORT_JOB_NAME_FIELD, MODEL_CARD_EXPORT_JOB_ARN_FIELD, STATUS_FIELD, MODEL_CARD_NAME_FIELD, MODEL_CARD_VERSION_FIELD, CREATED_AT_FIELD, LAST_MODIFIED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelCardExportJobName;
    private final String modelCardExportJobArn;
    private final String status;
    private final String modelCardName;
    private final Integer modelCardVersion;
    private final Instant createdAt;
    private final Instant lastModifiedAt;

    private ModelCardExportJobSummary(BuilderImpl builder) {
        this.modelCardExportJobName = builder.modelCardExportJobName;
        this.modelCardExportJobArn = builder.modelCardExportJobArn;
        this.status = builder.status;
        this.modelCardName = builder.modelCardName;
        this.modelCardVersion = builder.modelCardVersion;
        this.createdAt = builder.createdAt;
        this.lastModifiedAt = builder.lastModifiedAt;
    }

    public final String modelCardExportJobName() {
        return this.modelCardExportJobName;
    }

    public final String modelCardExportJobArn() {
        return this.modelCardExportJobArn;
    }

    public final ModelCardExportJobStatus status() {
        return ModelCardExportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String modelCardName() {
        return this.modelCardName;
    }

    public final Integer modelCardVersion() {
        return this.modelCardVersion;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardExportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardExportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelCardVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelCardExportJobSummary)) {
            return false;
        }
        ModelCardExportJobSummary other = (ModelCardExportJobSummary)obj;
        return Objects.equals(this.modelCardExportJobName(), other.modelCardExportJobName()) && Objects.equals(this.modelCardExportJobArn(), other.modelCardExportJobArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.modelCardName(), other.modelCardName()) && Objects.equals(this.modelCardVersion(), other.modelCardVersion()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ModelCardExportJobSummary").add("ModelCardExportJobName", (Object)this.modelCardExportJobName()).add("ModelCardExportJobArn", (Object)this.modelCardExportJobArn()).add("Status", (Object)this.statusAsString()).add("ModelCardName", (Object)this.modelCardName()).add("ModelCardVersion", (Object)this.modelCardVersion()).add("CreatedAt", (Object)this.createdAt()).add("LastModifiedAt", (Object)this.lastModifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelCardExportJobName": {
                return Optional.ofNullable(clazz.cast(this.modelCardExportJobName()));
            }
            case "ModelCardExportJobArn": {
                return Optional.ofNullable(clazz.cast(this.modelCardExportJobArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ModelCardName": {
                return Optional.ofNullable(clazz.cast(this.modelCardName()));
            }
            case "ModelCardVersion": {
                return Optional.ofNullable(clazz.cast(this.modelCardVersion()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelCardExportJobSummary, T> g) {
        return obj -> g.apply((ModelCardExportJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelCardExportJobName;
        private String modelCardExportJobArn;
        private String status;
        private String modelCardName;
        private Integer modelCardVersion;
        private Instant createdAt;
        private Instant lastModifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelCardExportJobSummary model) {
            this.modelCardExportJobName(model.modelCardExportJobName);
            this.modelCardExportJobArn(model.modelCardExportJobArn);
            this.status(model.status);
            this.modelCardName(model.modelCardName);
            this.modelCardVersion(model.modelCardVersion);
            this.createdAt(model.createdAt);
            this.lastModifiedAt(model.lastModifiedAt);
        }

        public final String getModelCardExportJobName() {
            return this.modelCardExportJobName;
        }

        public final void setModelCardExportJobName(String modelCardExportJobName) {
            this.modelCardExportJobName = modelCardExportJobName;
        }

        @Override
        public final Builder modelCardExportJobName(String modelCardExportJobName) {
            this.modelCardExportJobName = modelCardExportJobName;
            return this;
        }

        public final String getModelCardExportJobArn() {
            return this.modelCardExportJobArn;
        }

        public final void setModelCardExportJobArn(String modelCardExportJobArn) {
            this.modelCardExportJobArn = modelCardExportJobArn;
        }

        @Override
        public final Builder modelCardExportJobArn(String modelCardExportJobArn) {
            this.modelCardExportJobArn = modelCardExportJobArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelCardExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelCardName() {
            return this.modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final Integer getModelCardVersion() {
            return this.modelCardVersion;
        }

        public final void setModelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
        }

        @Override
        public final Builder modelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public ModelCardExportJobSummary build() {
            return new ModelCardExportJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelCardExportJobSummary> {
        public Builder modelCardExportJobName(String var1);

        public Builder modelCardExportJobArn(String var1);

        public Builder status(String var1);

        public Builder status(ModelCardExportJobStatus var1);

        public Builder modelCardName(String var1);

        public Builder modelCardVersion(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder lastModifiedAt(Instant var1);
    }
}

