/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageVersionSortBy {
    CREATION_TIME("CREATION_TIME"),
    LAST_MODIFIED_TIME("LAST_MODIFIED_TIME"),
    VERSION("VERSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageVersionSortBy> VALUE_MAP;
    private final String value;

    private ImageVersionSortBy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageVersionSortBy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageVersionSortBy> knownValues() {
        EnumSet<ImageVersionSortBy> knownValues = EnumSet.allOf(ImageVersionSortBy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageVersionSortBy.class, ImageVersionSortBy::toString);
    }
}

