/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.DriftCheckBias;
import software.amazon.awssdk.services.sagemaker.model.DriftCheckExplainability;
import software.amazon.awssdk.services.sagemaker.model.DriftCheckModelDataQuality;
import software.amazon.awssdk.services.sagemaker.model.DriftCheckModelQuality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DriftCheckBaselines
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DriftCheckBaselines> {
    private static final SdkField<DriftCheckBias> BIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Bias").getter(DriftCheckBaselines.getter(DriftCheckBaselines::bias)).setter(DriftCheckBaselines.setter(Builder::bias)).constructor(DriftCheckBias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bias").build()}).build();
    private static final SdkField<DriftCheckExplainability> EXPLAINABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Explainability").getter(DriftCheckBaselines.getter(DriftCheckBaselines::explainability)).setter(DriftCheckBaselines.setter(Builder::explainability)).constructor(DriftCheckExplainability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Explainability").build()}).build();
    private static final SdkField<DriftCheckModelQuality> MODEL_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelQuality").getter(DriftCheckBaselines.getter(DriftCheckBaselines::modelQuality)).setter(DriftCheckBaselines.setter(Builder::modelQuality)).constructor(DriftCheckModelQuality::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuality").build()}).build();
    private static final SdkField<DriftCheckModelDataQuality> MODEL_DATA_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelDataQuality").getter(DriftCheckBaselines.getter(DriftCheckBaselines::modelDataQuality)).setter(DriftCheckBaselines.setter(Builder::modelDataQuality)).constructor(DriftCheckModelDataQuality::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataQuality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIAS_FIELD, EXPLAINABILITY_FIELD, MODEL_QUALITY_FIELD, MODEL_DATA_QUALITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final DriftCheckBias bias;
    private final DriftCheckExplainability explainability;
    private final DriftCheckModelQuality modelQuality;
    private final DriftCheckModelDataQuality modelDataQuality;

    private DriftCheckBaselines(BuilderImpl builder) {
        this.bias = builder.bias;
        this.explainability = builder.explainability;
        this.modelQuality = builder.modelQuality;
        this.modelDataQuality = builder.modelDataQuality;
    }

    public final DriftCheckBias bias() {
        return this.bias;
    }

    public final DriftCheckExplainability explainability() {
        return this.explainability;
    }

    public final DriftCheckModelQuality modelQuality() {
        return this.modelQuality;
    }

    public final DriftCheckModelDataQuality modelDataQuality() {
        return this.modelDataQuality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bias());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainability());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQuality());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataQuality());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DriftCheckBaselines)) {
            return false;
        }
        DriftCheckBaselines other = (DriftCheckBaselines)obj;
        return Objects.equals(this.bias(), other.bias()) && Objects.equals(this.explainability(), other.explainability()) && Objects.equals(this.modelQuality(), other.modelQuality()) && Objects.equals(this.modelDataQuality(), other.modelDataQuality());
    }

    public final String toString() {
        return ToString.builder((String)"DriftCheckBaselines").add("Bias", (Object)this.bias()).add("Explainability", (Object)this.explainability()).add("ModelQuality", (Object)this.modelQuality()).add("ModelDataQuality", (Object)this.modelDataQuality()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bias": {
                return Optional.ofNullable(clazz.cast(this.bias()));
            }
            case "Explainability": {
                return Optional.ofNullable(clazz.cast(this.explainability()));
            }
            case "ModelQuality": {
                return Optional.ofNullable(clazz.cast(this.modelQuality()));
            }
            case "ModelDataQuality": {
                return Optional.ofNullable(clazz.cast(this.modelDataQuality()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DriftCheckBaselines, T> g) {
        return obj -> g.apply((DriftCheckBaselines)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DriftCheckBias bias;
        private DriftCheckExplainability explainability;
        private DriftCheckModelQuality modelQuality;
        private DriftCheckModelDataQuality modelDataQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(DriftCheckBaselines model) {
            this.bias(model.bias);
            this.explainability(model.explainability);
            this.modelQuality(model.modelQuality);
            this.modelDataQuality(model.modelDataQuality);
        }

        public final DriftCheckBias.Builder getBias() {
            return this.bias != null ? this.bias.toBuilder() : null;
        }

        public final void setBias(DriftCheckBias.BuilderImpl bias) {
            this.bias = bias != null ? bias.build() : null;
        }

        @Override
        public final Builder bias(DriftCheckBias bias) {
            this.bias = bias;
            return this;
        }

        public final DriftCheckExplainability.Builder getExplainability() {
            return this.explainability != null ? this.explainability.toBuilder() : null;
        }

        public final void setExplainability(DriftCheckExplainability.BuilderImpl explainability) {
            this.explainability = explainability != null ? explainability.build() : null;
        }

        @Override
        public final Builder explainability(DriftCheckExplainability explainability) {
            this.explainability = explainability;
            return this;
        }

        public final DriftCheckModelQuality.Builder getModelQuality() {
            return this.modelQuality != null ? this.modelQuality.toBuilder() : null;
        }

        public final void setModelQuality(DriftCheckModelQuality.BuilderImpl modelQuality) {
            this.modelQuality = modelQuality != null ? modelQuality.build() : null;
        }

        @Override
        public final Builder modelQuality(DriftCheckModelQuality modelQuality) {
            this.modelQuality = modelQuality;
            return this;
        }

        public final DriftCheckModelDataQuality.Builder getModelDataQuality() {
            return this.modelDataQuality != null ? this.modelDataQuality.toBuilder() : null;
        }

        public final void setModelDataQuality(DriftCheckModelDataQuality.BuilderImpl modelDataQuality) {
            this.modelDataQuality = modelDataQuality != null ? modelDataQuality.build() : null;
        }

        @Override
        public final Builder modelDataQuality(DriftCheckModelDataQuality modelDataQuality) {
            this.modelDataQuality = modelDataQuality;
            return this;
        }

        public DriftCheckBaselines build() {
            return new DriftCheckBaselines(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DriftCheckBaselines> {
        public Builder bias(DriftCheckBias var1);

        default public Builder bias(Consumer<DriftCheckBias.Builder> bias) {
            return this.bias((DriftCheckBias)((DriftCheckBias.Builder)DriftCheckBias.builder().applyMutation(bias)).build());
        }

        public Builder explainability(DriftCheckExplainability var1);

        default public Builder explainability(Consumer<DriftCheckExplainability.Builder> explainability) {
            return this.explainability((DriftCheckExplainability)((DriftCheckExplainability.Builder)DriftCheckExplainability.builder().applyMutation(explainability)).build());
        }

        public Builder modelQuality(DriftCheckModelQuality var1);

        default public Builder modelQuality(Consumer<DriftCheckModelQuality.Builder> modelQuality) {
            return this.modelQuality((DriftCheckModelQuality)((DriftCheckModelQuality.Builder)DriftCheckModelQuality.builder().applyMutation(modelQuality)).build());
        }

        public Builder modelDataQuality(DriftCheckModelDataQuality var1);

        default public Builder modelDataQuality(Consumer<DriftCheckModelDataQuality.Builder> modelDataQuality) {
            return this.modelDataQuality((DriftCheckModelDataQuality)((DriftCheckModelDataQuality.Builder)DriftCheckModelDataQuality.builder().applyMutation(modelDataQuality)).build());
        }
    }
}

