/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringAlertHistorySummary;

public class ListMonitoringAlertHistoryPublisher
implements SdkPublisher<ListMonitoringAlertHistoryResponse> {
    private final SageMakerAsyncClient client;
    private final ListMonitoringAlertHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMonitoringAlertHistoryPublisher(SageMakerAsyncClient client, ListMonitoringAlertHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMonitoringAlertHistoryPublisher(SageMakerAsyncClient client, ListMonitoringAlertHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMonitoringAlertHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMonitoringAlertHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MonitoringAlertHistorySummary> monitoringAlertHistory() {
        Function<ListMonitoringAlertHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.monitoringAlertHistory() != null) {
                return response.monitoringAlertHistory().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMonitoringAlertHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMonitoringAlertHistoryResponseFetcher
    implements AsyncPageFetcher<ListMonitoringAlertHistoryResponse> {
        private ListMonitoringAlertHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitoringAlertHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMonitoringAlertHistoryResponse> nextPage(ListMonitoringAlertHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListMonitoringAlertHistoryPublisher.this.client.listMonitoringAlertHistory(ListMonitoringAlertHistoryPublisher.this.firstRequest);
            }
            return ListMonitoringAlertHistoryPublisher.this.client.listMonitoringAlertHistory((ListMonitoringAlertHistoryRequest)((Object)ListMonitoringAlertHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

