/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ArtifactSummary;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse;

public class ListArtifactsIterable
implements SdkIterable<ListArtifactsResponse> {
    private final SageMakerClient client;
    private final ListArtifactsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListArtifactsIterable(SageMakerClient client, ListArtifactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListArtifactsResponseFetcher();
    }

    public Iterator<ListArtifactsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ArtifactSummary> artifactSummaries() {
        Function<ListArtifactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.artifactSummaries() != null) {
                return response.artifactSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListArtifactsResponseFetcher
    implements SyncPageFetcher<ListArtifactsResponse> {
        private ListArtifactsResponseFetcher() {
        }

        public boolean hasNextPage(ListArtifactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListArtifactsResponse nextPage(ListArtifactsResponse previousPage) {
            if (previousPage == null) {
                return ListArtifactsIterable.this.client.listArtifacts(ListArtifactsIterable.this.firstRequest);
            }
            return ListArtifactsIterable.this.client.listArtifacts((ListArtifactsRequest)((Object)ListArtifactsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

