/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.
 * </p>
 * <p>
 * For more information about publishing S3 Storage Lens metrics to CloudWatch, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_view_metrics_cloudwatch.html">Monitor S3
 * Storage Lens metrics in CloudWatch</a> in the <i>Amazon S3 User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchMetrics.Builder, CloudWatchMetrics> {
    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsEnabled")
            .getter(getter(CloudWatchMetrics::isEnabled))
            .setter(setter(Builder::isEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEnabled")
                    .unmarshallLocationName("IsEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isEnabled;

    private CloudWatchMetrics(BuilderImpl builder) {
        this.isEnabled = builder.isEnabled;
    }

    /**
     * <p>
     * A container that indicates whether CloudWatch publishing for S3 Storage Lens metrics is enabled. A value of
     * <code>true</code> indicates that CloudWatch publishing for S3 Storage Lens metrics is enabled.
     * </p>
     * 
     * @return A container that indicates whether CloudWatch publishing for S3 Storage Lens metrics is enabled. A value
     *         of <code>true</code> indicates that CloudWatch publishing for S3 Storage Lens metrics is enabled.
     */
    public final Boolean isEnabled() {
        return isEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchMetrics)) {
            return false;
        }
        CloudWatchMetrics other = (CloudWatchMetrics) obj;
        return Objects.equals(isEnabled(), other.isEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchMetrics").add("IsEnabled", isEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsEnabled":
            return Optional.ofNullable(clazz.cast(isEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchMetrics, T> g) {
        return obj -> g.apply((CloudWatchMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchMetrics> {
        /**
         * <p>
         * A container that indicates whether CloudWatch publishing for S3 Storage Lens metrics is enabled. A value of
         * <code>true</code> indicates that CloudWatch publishing for S3 Storage Lens metrics is enabled.
         * </p>
         * 
         * @param isEnabled
         *        A container that indicates whether CloudWatch publishing for S3 Storage Lens metrics is enabled. A
         *        value of <code>true</code> indicates that CloudWatch publishing for S3 Storage Lens metrics is
         *        enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEnabled(Boolean isEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchMetrics model) {
            isEnabled(model.isEnabled);
        }

        public final Boolean getIsEnabled() {
            return isEnabled;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        @Override
        public CloudWatchMetrics build() {
            return new CloudWatchMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
