/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.internal.interceptors;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.S3SignerExecutionAttribute;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpMethod;

@SdkInternalApi
public class PayloadSigningInterceptor
implements ExecutionInterceptor {
    public Optional<RequestBody> modifyHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        executionAttributes.putAttribute(S3SignerExecutionAttribute.ENABLE_PAYLOAD_SIGNING, (Object)true);
        if (!context.requestBody().isPresent() && context.httpRequest().method() == SdkHttpMethod.POST) {
            return Optional.of(RequestBody.fromBytes((byte[])new byte[0]));
        }
        return context.requestBody();
    }
}

