/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMultiRegionAccessPointRoutesRequest extends S3ControlRequest implements
        ToCopyableBuilder<GetMultiRegionAccessPointRoutesRequest.Builder, GetMultiRegionAccessPointRoutesRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(GetMultiRegionAccessPointRoutesRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> MRAP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Mrap")
            .getter(getter(GetMultiRegionAccessPointRoutesRequest::mrap))
            .setter(setter(Builder::mrap))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("mrap")
                    .unmarshallLocationName("mrap").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, MRAP_FIELD));

    private final String accountId;

    private final String mrap;

    private GetMultiRegionAccessPointRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.mrap = builder.mrap;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for the owner of the Multi-Region Access Point.
     * </p>
     * 
     * @return The Amazon Web Services account ID for the owner of the Multi-Region Access Point.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Multi-Region Access Point ARN.
     * </p>
     * 
     * @return The Multi-Region Access Point ARN.
     */
    public final String mrap() {
        return mrap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(mrap());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMultiRegionAccessPointRoutesRequest)) {
            return false;
        }
        GetMultiRegionAccessPointRoutesRequest other = (GetMultiRegionAccessPointRoutesRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(mrap(), other.mrap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMultiRegionAccessPointRoutesRequest").add("AccountId", accountId()).add("Mrap", mrap())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Mrap":
            return Optional.ofNullable(clazz.cast(mrap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMultiRegionAccessPointRoutesRequest, T> g) {
        return obj -> g.apply((GetMultiRegionAccessPointRoutesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMultiRegionAccessPointRoutesRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID for the owner of the Multi-Region Access Point.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID for the owner of the Multi-Region Access Point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Multi-Region Access Point ARN.
         * </p>
         * 
         * @param mrap
         *        The Multi-Region Access Point ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mrap(String mrap);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String mrap;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMultiRegionAccessPointRoutesRequest model) {
            super(model);
            accountId(model.accountId);
            mrap(model.mrap);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getMrap() {
            return mrap;
        }

        public final void setMrap(String mrap) {
            this.mrap = mrap;
        }

        @Override
        public final Builder mrap(String mrap) {
            this.mrap = mrap;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMultiRegionAccessPointRoutesRequest build() {
            return new GetMultiRegionAccessPointRoutesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
