/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.endpoints;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;

/**
 * The parameters object used to resolve an endpoint for the S3Control service.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class S3ControlEndpointParams {
    private final Region region;

    private final Boolean useFIPS;

    private final Boolean useDualStack;

    private final String endpoint;

    private final String accountId;

    private final Boolean requiresAccountId;

    private final String outpostId;

    private final String bucket;

    private final String accessPointName;

    private final Boolean useArnRegion;

    private S3ControlEndpointParams(BuilderImpl builder) {
        this.region = builder.region;
        this.useFIPS = builder.useFIPS;
        this.useDualStack = builder.useDualStack;
        this.endpoint = builder.endpoint;
        this.accountId = builder.accountId;
        this.requiresAccountId = builder.requiresAccountId;
        this.outpostId = builder.outpostId;
        this.bucket = builder.bucket;
        this.accessPointName = builder.accessPointName;
        this.useArnRegion = builder.useArnRegion;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Region region() {
        return region;
    }

    public Boolean useFips() {
        return useFIPS;
    }

    public Boolean useDualStack() {
        return useDualStack;
    }

    public String endpoint() {
        return endpoint;
    }

    public String accountId() {
        return accountId;
    }

    public Boolean requiresAccountId() {
        return requiresAccountId;
    }

    public String outpostId() {
        return outpostId;
    }

    public String bucket() {
        return bucket;
    }

    public String accessPointName() {
        return accessPointName;
    }

    public Boolean useArnRegion() {
        return useArnRegion;
    }

    public interface Builder {
        Builder region(Region region);

        Builder useFips(Boolean useFIPS);

        Builder useDualStack(Boolean useDualStack);

        Builder endpoint(String endpoint);

        Builder accountId(String accountId);

        Builder requiresAccountId(Boolean requiresAccountId);

        Builder outpostId(String outpostId);

        Builder bucket(String bucket);

        Builder accessPointName(String accessPointName);

        Builder useArnRegion(Boolean useArnRegion);

        S3ControlEndpointParams build();
    }

    private static class BuilderImpl implements Builder {
        private Region region;

        private Boolean useFIPS = false;

        private Boolean useDualStack = false;

        private String endpoint;

        private String accountId;

        private Boolean requiresAccountId;

        private String outpostId;

        private String bucket;

        private String accessPointName;

        private Boolean useArnRegion;

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public Builder requiresAccountId(Boolean requiresAccountId) {
            this.requiresAccountId = requiresAccountId;
            return this;
        }

        @Override
        public Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        @Override
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public Builder accessPointName(String accessPointName) {
            this.accessPointName = accessPointName;
            return this;
        }

        @Override
        public Builder useArnRegion(Boolean useArnRegion) {
            this.useArnRegion = useArnRegion;
            return this;
        }

        @Override
        public S3ControlEndpointParams build() {
            return new S3ControlEndpointParams(this);
        }
    }
}
