/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The S3 Metadata configuration for a general purpose bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataConfiguration.Builder, MetadataConfiguration> {
    private static final SdkField<JournalTableConfiguration> JOURNAL_TABLE_CONFIGURATION_FIELD = SdkField
            .<JournalTableConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("JournalTableConfiguration")
            .getter(getter(MetadataConfiguration::journalTableConfiguration))
            .setter(setter(Builder::journalTableConfiguration))
            .constructor(JournalTableConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JournalTableConfiguration")
                    .unmarshallLocationName("JournalTableConfiguration").build(), RequiredTrait.create()).build();

    private static final SdkField<InventoryTableConfiguration> INVENTORY_TABLE_CONFIGURATION_FIELD = SdkField
            .<InventoryTableConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("InventoryTableConfiguration")
            .getter(getter(MetadataConfiguration::inventoryTableConfiguration))
            .setter(setter(Builder::inventoryTableConfiguration))
            .constructor(InventoryTableConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventoryTableConfiguration")
                    .unmarshallLocationName("InventoryTableConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            JOURNAL_TABLE_CONFIGURATION_FIELD, INVENTORY_TABLE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final JournalTableConfiguration journalTableConfiguration;

    private final InventoryTableConfiguration inventoryTableConfiguration;

    private MetadataConfiguration(BuilderImpl builder) {
        this.journalTableConfiguration = builder.journalTableConfiguration;
        this.inventoryTableConfiguration = builder.inventoryTableConfiguration;
    }

    /**
     * <p>
     * The journal table configuration for a metadata configuration.
     * </p>
     * 
     * @return The journal table configuration for a metadata configuration.
     */
    public final JournalTableConfiguration journalTableConfiguration() {
        return journalTableConfiguration;
    }

    /**
     * <p>
     * The inventory table configuration for a metadata configuration.
     * </p>
     * 
     * @return The inventory table configuration for a metadata configuration.
     */
    public final InventoryTableConfiguration inventoryTableConfiguration() {
        return inventoryTableConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(journalTableConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(inventoryTableConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataConfiguration)) {
            return false;
        }
        MetadataConfiguration other = (MetadataConfiguration) obj;
        return Objects.equals(journalTableConfiguration(), other.journalTableConfiguration())
                && Objects.equals(inventoryTableConfiguration(), other.inventoryTableConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataConfiguration").add("JournalTableConfiguration", journalTableConfiguration())
                .add("InventoryTableConfiguration", inventoryTableConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JournalTableConfiguration":
            return Optional.ofNullable(clazz.cast(journalTableConfiguration()));
        case "InventoryTableConfiguration":
            return Optional.ofNullable(clazz.cast(inventoryTableConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JournalTableConfiguration", JOURNAL_TABLE_CONFIGURATION_FIELD);
        map.put("InventoryTableConfiguration", INVENTORY_TABLE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataConfiguration, T> g) {
        return obj -> g.apply((MetadataConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataConfiguration> {
        /**
         * <p>
         * The journal table configuration for a metadata configuration.
         * </p>
         * 
         * @param journalTableConfiguration
         *        The journal table configuration for a metadata configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journalTableConfiguration(JournalTableConfiguration journalTableConfiguration);

        /**
         * <p>
         * The journal table configuration for a metadata configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link JournalTableConfiguration.Builder}
         * avoiding the need to create one manually via {@link JournalTableConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JournalTableConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #journalTableConfiguration(JournalTableConfiguration)}.
         * 
         * @param journalTableConfiguration
         *        a consumer that will call methods on {@link JournalTableConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #journalTableConfiguration(JournalTableConfiguration)
         */
        default Builder journalTableConfiguration(Consumer<JournalTableConfiguration.Builder> journalTableConfiguration) {
            return journalTableConfiguration(JournalTableConfiguration.builder().applyMutation(journalTableConfiguration).build());
        }

        /**
         * <p>
         * The inventory table configuration for a metadata configuration.
         * </p>
         * 
         * @param inventoryTableConfiguration
         *        The inventory table configuration for a metadata configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventoryTableConfiguration(InventoryTableConfiguration inventoryTableConfiguration);

        /**
         * <p>
         * The inventory table configuration for a metadata configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link InventoryTableConfiguration.Builder}
         * avoiding the need to create one manually via {@link InventoryTableConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InventoryTableConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inventoryTableConfiguration(InventoryTableConfiguration)}.
         * 
         * @param inventoryTableConfiguration
         *        a consumer that will call methods on {@link InventoryTableConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inventoryTableConfiguration(InventoryTableConfiguration)
         */
        default Builder inventoryTableConfiguration(Consumer<InventoryTableConfiguration.Builder> inventoryTableConfiguration) {
            return inventoryTableConfiguration(InventoryTableConfiguration.builder().applyMutation(inventoryTableConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JournalTableConfiguration journalTableConfiguration;

        private InventoryTableConfiguration inventoryTableConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataConfiguration model) {
            journalTableConfiguration(model.journalTableConfiguration);
            inventoryTableConfiguration(model.inventoryTableConfiguration);
        }

        public final JournalTableConfiguration.Builder getJournalTableConfiguration() {
            return journalTableConfiguration != null ? journalTableConfiguration.toBuilder() : null;
        }

        public final void setJournalTableConfiguration(JournalTableConfiguration.BuilderImpl journalTableConfiguration) {
            this.journalTableConfiguration = journalTableConfiguration != null ? journalTableConfiguration.build() : null;
        }

        @Override
        public final Builder journalTableConfiguration(JournalTableConfiguration journalTableConfiguration) {
            this.journalTableConfiguration = journalTableConfiguration;
            return this;
        }

        public final InventoryTableConfiguration.Builder getInventoryTableConfiguration() {
            return inventoryTableConfiguration != null ? inventoryTableConfiguration.toBuilder() : null;
        }

        public final void setInventoryTableConfiguration(InventoryTableConfiguration.BuilderImpl inventoryTableConfiguration) {
            this.inventoryTableConfiguration = inventoryTableConfiguration != null ? inventoryTableConfiguration.build() : null;
        }

        @Override
        public final Builder inventoryTableConfiguration(InventoryTableConfiguration inventoryTableConfiguration) {
            this.inventoryTableConfiguration = inventoryTableConfiguration;
            return this;
        }

        @Override
        public MetadataConfiguration build() {
            return new MetadataConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
