/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsS3ProtocolFactory;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3Utilities;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketEncryptionResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.DeletePublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.DeletePublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.GetBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.GetBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAclResponse;
import software.amazon.awssdk.services.s3.model.GetObjectLegalHoldRequest;
import software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse;
import software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRetentionRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentResponse;
import software.amazon.awssdk.services.s3.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;
import software.amazon.awssdk.services.s3.model.ListPartsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.NoSuchUploadException;
import software.amazon.awssdk.services.s3.model.ObjectAlreadyInActiveTierErrorException;
import software.amazon.awssdk.services.s3.model.ObjectNotInActiveTierErrorException;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAclRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAclResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.PutBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.PutBucketEncryptionResponse;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.PutObjectAclRequest;
import software.amazon.awssdk.services.s3.model.PutObjectAclResponse;
import software.amazon.awssdk.services.s3.model.PutObjectLegalHoldRequest;
import software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse;
import software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRetentionResponse;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.PutPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.RestoreObjectRequest;
import software.amazon.awssdk.services.s3.model.RestoreObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;
import software.amazon.awssdk.services.s3.model.UploadPartCopyResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsIterable;
import software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;
import software.amazon.awssdk.services.s3.paginators.ListPartsIterable;
import software.amazon.awssdk.services.s3.transform.AbortMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CompleteMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CopyObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CreateBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CreateMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketAnalyticsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketCorsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketEncryptionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketInventoryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketLifecycleRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketMetricsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketWebsiteRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeletePublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAccelerateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAnalyticsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketCorsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketEncryptionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketInventoryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLocationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLoggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketMetricsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketRequestPaymentRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketVersioningRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketWebsiteRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectLockConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectRetentionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectTorrentRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.HeadBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.HeadObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketAnalyticsConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketInventoryConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketMetricsConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListMultipartUploadsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectVersionsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectsV2RequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListPartsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAccelerateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAnalyticsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketCorsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketEncryptionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketInventoryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketLoggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketMetricsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketRequestPaymentRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketVersioningRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketWebsiteRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectLockConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectRetentionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.RestoreObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.UploadPartCopyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.UploadPartRequestMarshaller;

@SdkInternalApi
final class DefaultS3Client
implements S3Client {
    private final SyncClientHandler clientHandler;
    private final AwsS3ProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultS3Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "s3";
    }

    @Override
    public AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws NoSuchUploadException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(AbortMultipartUploadResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (AbortMultipartUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AbortMultipartUpload").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)abortMultipartUploadRequest).withMarshaller((Marshaller)new AbortMultipartUploadRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CompleteMultipartUploadResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (CompleteMultipartUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteMultipartUpload").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)completeMultipartUploadRequest).withMarshaller((Marshaller)new CompleteMultipartUploadRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CopyObjectResponse copyObject(CopyObjectRequest copyObjectRequest) throws ObjectNotInActiveTierErrorException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CopyObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (CopyObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyObject").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)copyObjectRequest).withMarshaller((Marshaller)new CopyObjectRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateBucketResponse createBucket(CreateBucketRequest createBucketRequest) throws BucketAlreadyExistsException, BucketAlreadyOwnedByYouException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (CreateBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucket").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createBucketRequest).withMarshaller((Marshaller)new CreateBucketRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateMultipartUploadResponse createMultipartUpload(CreateMultipartUploadRequest createMultipartUploadRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateMultipartUploadResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (CreateMultipartUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMultipartUpload").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createMultipartUploadRequest).withMarshaller((Marshaller)new CreateMultipartUploadRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBucketResponse deleteBucket(DeleteBucketRequest deleteBucketRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucket").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketRequest).withMarshaller((Marshaller)new DeleteBucketRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBucketAnalyticsConfigurationResponse deleteBucketAnalyticsConfiguration(DeleteBucketAnalyticsConfigurationRequest deleteBucketAnalyticsConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketAnalyticsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteBucketAnalyticsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketAnalyticsConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketAnalyticsConfigurationRequest).withMarshaller((Marshaller)new DeleteBucketAnalyticsConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBucketCorsResponse deleteBucketCors(DeleteBucketCorsRequest deleteBucketCorsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketCorsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteBucketCorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketCors").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketCorsRequest).withMarshaller((Marshaller)new DeleteBucketCorsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBucketEncryptionResponse deleteBucketEncryption(DeleteBucketEncryptionRequest deleteBucketEncryptionRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteBucketEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketEncryption").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketEncryptionRequest).withMarshaller((Marshaller)new DeleteBucketEncryptionRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBucketInventoryConfigurationResponse deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketInventoryConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteBucketInventoryConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketInventoryConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketInventoryConfigurationRequest).withMarshaller((Marshaller)new DeleteBucketInventoryConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBucketLifecycleResponse deleteBucketLifecycle(DeleteBucketLifecycleRequest deleteBucketLifecycleRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketLifecycleResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteBucketLifecycleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketLifecycle").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketLifecycleRequest).withMarshaller((Marshaller)new DeleteBucketLifecycleRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBucketMetricsConfigurationResponse deleteBucketMetricsConfiguration(DeleteBucketMetricsConfigurationRequest deleteBucketMetricsConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketMetricsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteBucketMetricsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketMetricsConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketMetricsConfigurationRequest).withMarshaller((Marshaller)new DeleteBucketMetricsConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBucketPolicyResponse deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketPolicy").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketPolicyRequest).withMarshaller((Marshaller)new DeleteBucketPolicyRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBucketReplicationResponse deleteBucketReplication(DeleteBucketReplicationRequest deleteBucketReplicationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketReplicationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteBucketReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketReplication").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketReplicationRequest).withMarshaller((Marshaller)new DeleteBucketReplicationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBucketTaggingResponse deleteBucketTagging(DeleteBucketTaggingRequest deleteBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketTagging").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketTaggingRequest).withMarshaller((Marshaller)new DeleteBucketTaggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteBucketWebsiteResponse deleteBucketWebsite(DeleteBucketWebsiteRequest deleteBucketWebsiteRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketWebsiteResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteBucketWebsiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketWebsite").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketWebsiteRequest).withMarshaller((Marshaller)new DeleteBucketWebsiteRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObject").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteObjectRequest).withMarshaller((Marshaller)new DeleteObjectRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteObjectTaggingResponse deleteObjectTagging(DeleteObjectTaggingRequest deleteObjectTaggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteObjectTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteObjectTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObjectTagging").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteObjectTaggingRequest).withMarshaller((Marshaller)new DeleteObjectTaggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteObjectsResponse deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteObjectsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeleteObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObjects").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteObjectsRequest).withMarshaller((Marshaller)new DeleteObjectsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeletePublicAccessBlockResponse deletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeletePublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (DeletePublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePublicAccessBlock").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deletePublicAccessBlockRequest).withMarshaller((Marshaller)new DeletePublicAccessBlockRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketAccelerateConfigurationResponse getBucketAccelerateConfiguration(GetBucketAccelerateConfigurationRequest getBucketAccelerateConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketAccelerateConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketAccelerateConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketAccelerateConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketAccelerateConfigurationRequest).withMarshaller((Marshaller)new GetBucketAccelerateConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketAclResponse getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketAclResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketAcl").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketAclRequest).withMarshaller((Marshaller)new GetBucketAclRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketAnalyticsConfigurationResponse getBucketAnalyticsConfiguration(GetBucketAnalyticsConfigurationRequest getBucketAnalyticsConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketAnalyticsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketAnalyticsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketAnalyticsConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketAnalyticsConfigurationRequest).withMarshaller((Marshaller)new GetBucketAnalyticsConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketCorsResponse getBucketCors(GetBucketCorsRequest getBucketCorsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketCorsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketCorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketCors").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketCorsRequest).withMarshaller((Marshaller)new GetBucketCorsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketEncryptionResponse getBucketEncryption(GetBucketEncryptionRequest getBucketEncryptionRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketEncryption").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketEncryptionRequest).withMarshaller((Marshaller)new GetBucketEncryptionRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketInventoryConfigurationResponse getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketInventoryConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketInventoryConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketInventoryConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketInventoryConfigurationRequest).withMarshaller((Marshaller)new GetBucketInventoryConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketLifecycleConfigurationResponse getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLifecycleConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketLifecycleConfigurationRequest).withMarshaller((Marshaller)new GetBucketLifecycleConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketLocationResponse getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLocationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketLocationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLocation").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketLocationRequest).withMarshaller((Marshaller)new GetBucketLocationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketLoggingResponse getBucketLogging(GetBucketLoggingRequest getBucketLoggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLoggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketLoggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLogging").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketLoggingRequest).withMarshaller((Marshaller)new GetBucketLoggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketMetricsConfigurationResponse getBucketMetricsConfiguration(GetBucketMetricsConfigurationRequest getBucketMetricsConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketMetricsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketMetricsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketMetricsConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketMetricsConfigurationRequest).withMarshaller((Marshaller)new GetBucketMetricsConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketNotificationConfigurationResponse getBucketNotificationConfiguration(GetBucketNotificationConfigurationRequest getBucketNotificationConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketNotificationConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketNotificationConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketNotificationConfigurationRequest).withMarshaller((Marshaller)new GetBucketNotificationConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketPolicyResponse getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketPolicy").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketPolicyRequest).withMarshaller((Marshaller)new GetBucketPolicyRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketPolicyStatusResponse getBucketPolicyStatus(GetBucketPolicyStatusRequest getBucketPolicyStatusRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketPolicyStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketPolicyStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketPolicyStatus").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketPolicyStatusRequest).withMarshaller((Marshaller)new GetBucketPolicyStatusRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketReplicationResponse getBucketReplication(GetBucketReplicationRequest getBucketReplicationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketReplicationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketReplication").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketReplicationRequest).withMarshaller((Marshaller)new GetBucketReplicationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketRequestPaymentResponse getBucketRequestPayment(GetBucketRequestPaymentRequest getBucketRequestPaymentRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketRequestPaymentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketRequestPaymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketRequestPayment").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketRequestPaymentRequest).withMarshaller((Marshaller)new GetBucketRequestPaymentRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketTaggingResponse getBucketTagging(GetBucketTaggingRequest getBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketTagging").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketTaggingRequest).withMarshaller((Marshaller)new GetBucketTaggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketVersioningResponse getBucketVersioning(GetBucketVersioningRequest getBucketVersioningRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketVersioningResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketVersioningResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketVersioning").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketVersioningRequest).withMarshaller((Marshaller)new GetBucketVersioningRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetBucketWebsiteResponse getBucketWebsite(GetBucketWebsiteRequest getBucketWebsiteRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketWebsiteResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetBucketWebsiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketWebsite").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketWebsiteRequest).withMarshaller((Marshaller)new GetBucketWebsiteRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public <ReturnT> ReturnT getObject(GetObjectRequest getObjectRequest, ResponseTransformer<GetObjectResponse, ReturnT> responseTransformer) throws NoSuchKeyException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(true));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ReturnT)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getObjectRequest).withMarshaller((Marshaller)new GetObjectRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)), responseTransformer);
    }

    @Override
    public GetObjectAclResponse getObjectAcl(GetObjectAclRequest getObjectAclRequest) throws NoSuchKeyException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectAclResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetObjectAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectAcl").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getObjectAclRequest).withMarshaller((Marshaller)new GetObjectAclRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetObjectLegalHoldResponse getObjectLegalHold(GetObjectLegalHoldRequest getObjectLegalHoldRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectLegalHoldResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetObjectLegalHoldResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectLegalHold").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getObjectLegalHoldRequest).withMarshaller((Marshaller)new GetObjectLegalHoldRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetObjectLockConfigurationResponse getObjectLockConfiguration(GetObjectLockConfigurationRequest getObjectLockConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectLockConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetObjectLockConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectLockConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getObjectLockConfigurationRequest).withMarshaller((Marshaller)new GetObjectLockConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetObjectRetentionResponse getObjectRetention(GetObjectRetentionRequest getObjectRetentionRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectRetentionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetObjectRetentionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectRetention").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getObjectRetentionRequest).withMarshaller((Marshaller)new GetObjectRetentionRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetObjectTaggingResponse getObjectTagging(GetObjectTaggingRequest getObjectTaggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetObjectTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectTagging").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getObjectTaggingRequest).withMarshaller((Marshaller)new GetObjectTaggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public <ReturnT> ReturnT getObjectTorrent(GetObjectTorrentRequest getObjectTorrentRequest, ResponseTransformer<GetObjectTorrentResponse, ReturnT> responseTransformer) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetObjectTorrentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(true));
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ReturnT)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectTorrent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getObjectTorrentRequest).withMarshaller((Marshaller)new GetObjectTorrentRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)), responseTransformer);
    }

    @Override
    public GetPublicAccessBlockResponse getPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (GetPublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicAccessBlock").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getPublicAccessBlockRequest).withMarshaller((Marshaller)new GetPublicAccessBlockRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public HeadBucketResponse headBucket(HeadBucketRequest headBucketRequest) throws NoSuchBucketException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(HeadBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (HeadBucketResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("HeadBucket").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)headBucketRequest).withMarshaller((Marshaller)new HeadBucketRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public HeadObjectResponse headObject(HeadObjectRequest headObjectRequest) throws NoSuchKeyException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(HeadObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (HeadObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("HeadObject").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)headObjectRequest).withMarshaller((Marshaller)new HeadObjectRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBucketAnalyticsConfigurationsResponse listBucketAnalyticsConfigurations(ListBucketAnalyticsConfigurationsRequest listBucketAnalyticsConfigurationsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketAnalyticsConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (ListBucketAnalyticsConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBucketAnalyticsConfigurations").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listBucketAnalyticsConfigurationsRequest).withMarshaller((Marshaller)new ListBucketAnalyticsConfigurationsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBucketInventoryConfigurationsResponse listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketInventoryConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (ListBucketInventoryConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBucketInventoryConfigurations").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listBucketInventoryConfigurationsRequest).withMarshaller((Marshaller)new ListBucketInventoryConfigurationsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBucketMetricsConfigurationsResponse listBucketMetricsConfigurations(ListBucketMetricsConfigurationsRequest listBucketMetricsConfigurationsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketMetricsConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (ListBucketMetricsConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBucketMetricsConfigurations").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listBucketMetricsConfigurationsRequest).withMarshaller((Marshaller)new ListBucketMetricsConfigurationsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListBucketsResponse listBuckets(ListBucketsRequest listBucketsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (ListBucketsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBuckets").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listBucketsRequest).withMarshaller((Marshaller)new ListBucketsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListMultipartUploadsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (ListMultipartUploadsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMultipartUploads").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listMultipartUploadsRequest).withMarshaller((Marshaller)new ListMultipartUploadsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListMultipartUploadsIterable listMultipartUploadsPaginator(ListMultipartUploadsRequest listMultipartUploadsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        return new ListMultipartUploadsIterable(this, this.applyPaginatorUserAgent(listMultipartUploadsRequest));
    }

    @Override
    public ListObjectVersionsResponse listObjectVersions(ListObjectVersionsRequest listObjectVersionsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListObjectVersionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (ListObjectVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectVersions").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listObjectVersionsRequest).withMarshaller((Marshaller)new ListObjectVersionsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListObjectVersionsIterable listObjectVersionsPaginator(ListObjectVersionsRequest listObjectVersionsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        return new ListObjectVersionsIterable(this, this.applyPaginatorUserAgent(listObjectVersionsRequest));
    }

    @Override
    public ListObjectsResponse listObjects(ListObjectsRequest listObjectsRequest) throws NoSuchBucketException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListObjectsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (ListObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjects").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listObjectsRequest).withMarshaller((Marshaller)new ListObjectsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListObjectsV2Response listObjectsV2(ListObjectsV2Request listObjectsV2Request) throws NoSuchBucketException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListObjectsV2Response::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (ListObjectsV2Response)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectsV2").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listObjectsV2Request).withMarshaller((Marshaller)new ListObjectsV2RequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListObjectsV2Iterable listObjectsV2Paginator(ListObjectsV2Request listObjectsV2Request) throws NoSuchBucketException, AwsServiceException, SdkClientException, S3Exception {
        return new ListObjectsV2Iterable(this, this.applyPaginatorUserAgent(listObjectsV2Request));
    }

    @Override
    public ListPartsResponse listParts(ListPartsRequest listPartsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListPartsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (ListPartsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListParts").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listPartsRequest).withMarshaller((Marshaller)new ListPartsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPartsIterable listPartsPaginator(ListPartsRequest listPartsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        return new ListPartsIterable(this, this.applyPaginatorUserAgent(listPartsRequest));
    }

    @Override
    public PutBucketAccelerateConfigurationResponse putBucketAccelerateConfiguration(PutBucketAccelerateConfigurationRequest putBucketAccelerateConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketAccelerateConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketAccelerateConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketAccelerateConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketAccelerateConfigurationRequest).withMarshaller((Marshaller)new PutBucketAccelerateConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketAclResponse putBucketAcl(PutBucketAclRequest putBucketAclRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketAclResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketAcl").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketAclRequest).withMarshaller((Marshaller)new PutBucketAclRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketAnalyticsConfigurationResponse putBucketAnalyticsConfiguration(PutBucketAnalyticsConfigurationRequest putBucketAnalyticsConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketAnalyticsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketAnalyticsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketAnalyticsConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketAnalyticsConfigurationRequest).withMarshaller((Marshaller)new PutBucketAnalyticsConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketCorsResponse putBucketCors(PutBucketCorsRequest putBucketCorsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketCorsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketCorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketCors").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketCorsRequest).withMarshaller((Marshaller)new PutBucketCorsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketEncryptionResponse putBucketEncryption(PutBucketEncryptionRequest putBucketEncryptionRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketEncryptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketEncryption").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketEncryptionRequest).withMarshaller((Marshaller)new PutBucketEncryptionRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketInventoryConfigurationResponse putBucketInventoryConfiguration(PutBucketInventoryConfigurationRequest putBucketInventoryConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketInventoryConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketInventoryConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketInventoryConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketInventoryConfigurationRequest).withMarshaller((Marshaller)new PutBucketInventoryConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketLifecycleConfigurationResponse putBucketLifecycleConfiguration(PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketLifecycleConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketLifecycleConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketLifecycleConfigurationRequest).withMarshaller((Marshaller)new PutBucketLifecycleConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketLoggingResponse putBucketLogging(PutBucketLoggingRequest putBucketLoggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketLoggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketLoggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketLogging").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketLoggingRequest).withMarshaller((Marshaller)new PutBucketLoggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketMetricsConfigurationResponse putBucketMetricsConfiguration(PutBucketMetricsConfigurationRequest putBucketMetricsConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketMetricsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketMetricsConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketMetricsConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketMetricsConfigurationRequest).withMarshaller((Marshaller)new PutBucketMetricsConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketNotificationConfigurationResponse putBucketNotificationConfiguration(PutBucketNotificationConfigurationRequest putBucketNotificationConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketNotificationConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketNotificationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketNotificationConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketNotificationConfigurationRequest).withMarshaller((Marshaller)new PutBucketNotificationConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketPolicyResponse putBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketPolicy").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketPolicyRequest).withMarshaller((Marshaller)new PutBucketPolicyRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketReplicationResponse putBucketReplication(PutBucketReplicationRequest putBucketReplicationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketReplicationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketReplication").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketReplicationRequest).withMarshaller((Marshaller)new PutBucketReplicationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketRequestPaymentResponse putBucketRequestPayment(PutBucketRequestPaymentRequest putBucketRequestPaymentRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketRequestPaymentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketRequestPaymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketRequestPayment").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketRequestPaymentRequest).withMarshaller((Marshaller)new PutBucketRequestPaymentRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketTaggingResponse putBucketTagging(PutBucketTaggingRequest putBucketTaggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketTagging").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketTaggingRequest).withMarshaller((Marshaller)new PutBucketTaggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketVersioningResponse putBucketVersioning(PutBucketVersioningRequest putBucketVersioningRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketVersioningResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketVersioningResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketVersioning").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketVersioningRequest).withMarshaller((Marshaller)new PutBucketVersioningRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutBucketWebsiteResponse putBucketWebsite(PutBucketWebsiteRequest putBucketWebsiteRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketWebsiteResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutBucketWebsiteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketWebsite").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketWebsiteRequest).withMarshaller((Marshaller)new PutBucketWebsiteRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObject").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putObjectRequest).withRequestBody(requestBody).withMarshaller((Marshaller)((StreamingRequestMarshaller.Builder)StreamingRequestMarshaller.builder().delegateMarshaller((Marshaller)new PutObjectRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory))).requestBody(requestBody).build()));
    }

    @Override
    public PutObjectAclResponse putObjectAcl(PutObjectAclRequest putObjectAclRequest) throws NoSuchKeyException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectAclResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutObjectAclResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectAcl").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putObjectAclRequest).withMarshaller((Marshaller)new PutObjectAclRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutObjectLegalHoldResponse putObjectLegalHold(PutObjectLegalHoldRequest putObjectLegalHoldRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectLegalHoldResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutObjectLegalHoldResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectLegalHold").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putObjectLegalHoldRequest).withMarshaller((Marshaller)new PutObjectLegalHoldRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutObjectLockConfigurationResponse putObjectLockConfiguration(PutObjectLockConfigurationRequest putObjectLockConfigurationRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectLockConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutObjectLockConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectLockConfiguration").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putObjectLockConfigurationRequest).withMarshaller((Marshaller)new PutObjectLockConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutObjectRetentionResponse putObjectRetention(PutObjectRetentionRequest putObjectRetentionRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectRetentionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutObjectRetentionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectRetention").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putObjectRetentionRequest).withMarshaller((Marshaller)new PutObjectRetentionRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutObjectTaggingResponse putObjectTagging(PutObjectTaggingRequest putObjectTaggingRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutObjectTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectTagging").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putObjectTaggingRequest).withMarshaller((Marshaller)new PutObjectTaggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutPublicAccessBlockResponse putPublicAccessBlock(PutPublicAccessBlockRequest putPublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (PutPublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPublicAccessBlock").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putPublicAccessBlockRequest).withMarshaller((Marshaller)new PutPublicAccessBlockRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RestoreObjectResponse restoreObject(RestoreObjectRequest restoreObjectRequest) throws ObjectAlreadyInActiveTierErrorException, AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(RestoreObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (RestoreObjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreObject").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)restoreObjectRequest).withMarshaller((Marshaller)new RestoreObjectRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UploadPartResponse uploadPart(UploadPartRequest uploadPartRequest, RequestBody requestBody) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UploadPartResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (UploadPartResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadPart").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)uploadPartRequest).withRequestBody(requestBody).withMarshaller((Marshaller)((StreamingRequestMarshaller.Builder)StreamingRequestMarshaller.builder().delegateMarshaller((Marshaller)new UploadPartRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory))).requestBody(requestBody).build()));
    }

    @Override
    public UploadPartCopyResponse uploadPartCopy(UploadPartCopyRequest uploadPartCopyRequest) throws AwsServiceException, SdkClientException, S3Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UploadPartCopyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        return (UploadPartCopyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadPartCopy").withCombinedResponseHandler(responseHandler).withInput((SdkRequest)uploadPartCopyRequest).withMarshaller((Marshaller)new UploadPartCopyRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)));
    }

    private AwsS3ProtocolFactory init() {
        return ((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)AwsS3ProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchUpload").exceptionBuilderSupplier(NoSuchUploadException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ObjectAlreadyInActiveTierError").exceptionBuilderSupplier(ObjectAlreadyInActiveTierErrorException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyExists").exceptionBuilderSupplier(BucketAlreadyExistsException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchBucket").exceptionBuilderSupplier(NoSuchBucketException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ObjectNotInActiveTierError").exceptionBuilderSupplier(ObjectNotInActiveTierErrorException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyOwnedByYou").exceptionBuilderSupplier(BucketAlreadyOwnedByYouException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchKey").exceptionBuilderSupplier(NoSuchKeyException::builder).build())).clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(S3Exception::builder)).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends S3Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.11.5").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((S3Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    @Override
    public S3Utilities utilities() {
        return S3Utilities.create(this.clientConfiguration);
    }
}

