/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.transfer.s3.internal.serialization.ResumableFileDownloadSerializer;
import software.amazon.awssdk.transfer.s3.model.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.model.ResumableTransfer;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class ResumableFileDownload
implements ResumableTransfer,
ToCopyableBuilder<Builder, ResumableFileDownload> {
    private final DownloadFileRequest downloadFileRequest;
    private final long bytesTransferred;
    private final Instant s3ObjectLastModified;
    private final Long totalSizeInBytes;
    private final Instant fileLastModified;

    private ResumableFileDownload(DefaultBuilder builder) {
        this.downloadFileRequest = (DownloadFileRequest)Validate.paramNotNull((Object)builder.downloadFileRequest, (String)"downloadFileRequest");
        this.bytesTransferred = builder.bytesTransferred == null ? 0L : Validate.isNotNegative((long)builder.bytesTransferred, (String)"bytesTransferred");
        this.s3ObjectLastModified = builder.s3ObjectLastModified;
        this.totalSizeInBytes = Validate.isPositiveOrNull((Long)builder.totalSizeInBytes, (String)"totalSizeInBytes");
        this.fileLastModified = builder.fileLastModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResumableFileDownload that = (ResumableFileDownload)o;
        if (this.bytesTransferred != that.bytesTransferred) {
            return false;
        }
        if (!this.downloadFileRequest.equals(that.downloadFileRequest)) {
            return false;
        }
        if (!Objects.equals(this.s3ObjectLastModified, that.s3ObjectLastModified)) {
            return false;
        }
        if (!Objects.equals(this.fileLastModified, that.fileLastModified)) {
            return false;
        }
        return Objects.equals(this.totalSizeInBytes, that.totalSizeInBytes);
    }

    public int hashCode() {
        int result = this.downloadFileRequest.hashCode();
        result = 31 * result + (int)(this.bytesTransferred ^ this.bytesTransferred >>> 32);
        result = 31 * result + (this.s3ObjectLastModified != null ? this.s3ObjectLastModified.hashCode() : 0);
        result = 31 * result + (this.fileLastModified != null ? this.fileLastModified.hashCode() : 0);
        result = 31 * result + (this.totalSizeInBytes != null ? this.totalSizeInBytes.hashCode() : 0);
        return result;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public DownloadFileRequest downloadFileRequest() {
        return this.downloadFileRequest;
    }

    public long bytesTransferred() {
        return this.bytesTransferred;
    }

    public Optional<Instant> s3ObjectLastModified() {
        return Optional.ofNullable(this.s3ObjectLastModified);
    }

    public Instant fileLastModified() {
        return this.fileLastModified;
    }

    public OptionalLong totalSizeInBytes() {
        return this.totalSizeInBytes == null ? OptionalLong.empty() : OptionalLong.of(this.totalSizeInBytes);
    }

    public String toString() {
        return ToString.builder((String)"ResumableFileDownload").add("bytesTransferred", (Object)this.bytesTransferred).add("fileLastModified", (Object)this.fileLastModified).add("s3ObjectLastModified", (Object)this.s3ObjectLastModified).add("totalSizeInBytes", (Object)this.totalSizeInBytes).add("downloadFileRequest", (Object)this.downloadFileRequest).build();
    }

    @Override
    public void serializeToFile(Path path) {
        try {
            Files.write(path, ResumableFileDownloadSerializer.toJson(this), new OpenOption[0]);
        }
        catch (IOException e) {
            throw SdkClientException.create((String)("Failed to write to " + path), (Throwable)e);
        }
    }

    @Override
    public void serializeToOutputStream(OutputStream outputStream) {
        byte[] bytes = ResumableFileDownloadSerializer.toJson(this);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            IoUtils.copy((InputStream)byteArrayInputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw SdkClientException.create((String)"Failed to write this download object to the given OutputStream", (Throwable)e);
        }
    }

    @Override
    public String serializeToString() {
        return new String(ResumableFileDownloadSerializer.toJson(this), StandardCharsets.UTF_8);
    }

    @Override
    public SdkBytes serializeToBytes() {
        return SdkBytes.fromByteArrayUnsafe((byte[])ResumableFileDownloadSerializer.toJson(this));
    }

    @Override
    public InputStream serializeToInputStream() {
        return new ByteArrayInputStream(ResumableFileDownloadSerializer.toJson(this));
    }

    public static ResumableFileDownload fromFile(Path path) {
        ResumableFileDownload resumableFileDownload;
        block8: {
            InputStream stream = Files.newInputStream(path, new OpenOption[0]);
            try {
                resumableFileDownload = ResumableFileDownloadSerializer.fromJson(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw SdkClientException.create((String)("Failed to create a ResumableFileDownload from " + path), (Throwable)e);
                }
            }
            stream.close();
        }
        return resumableFileDownload;
    }

    public static ResumableFileDownload fromBytes(SdkBytes bytes) {
        return ResumableFileDownloadSerializer.fromJson(bytes.asByteArrayUnsafe());
    }

    public static ResumableFileDownload fromString(String contents) {
        return ResumableFileDownloadSerializer.fromJson(contents);
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    private static final class DefaultBuilder
    implements Builder {
        private DownloadFileRequest downloadFileRequest;
        private Long bytesTransferred;
        private Instant s3ObjectLastModified;
        private Long totalSizeInBytes;
        private Instant fileLastModified;

        private DefaultBuilder() {
        }

        private DefaultBuilder(ResumableFileDownload persistableFileDownload) {
            this.downloadFileRequest = persistableFileDownload.downloadFileRequest;
            this.bytesTransferred = persistableFileDownload.bytesTransferred;
            this.totalSizeInBytes = persistableFileDownload.totalSizeInBytes;
            this.fileLastModified = persistableFileDownload.fileLastModified;
            this.s3ObjectLastModified = persistableFileDownload.s3ObjectLastModified;
        }

        @Override
        public Builder downloadFileRequest(DownloadFileRequest downloadFileRequest) {
            this.downloadFileRequest = downloadFileRequest;
            return this;
        }

        @Override
        public Builder bytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        @Override
        public Builder totalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        @Override
        public Builder s3ObjectLastModified(Instant s3ObjectLastModified) {
            this.s3ObjectLastModified = s3ObjectLastModified;
            return this;
        }

        @Override
        public Builder fileLastModified(Instant fileLastModified) {
            this.fileLastModified = fileLastModified;
            return this;
        }

        public ResumableFileDownload build() {
            return new ResumableFileDownload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResumableFileDownload> {
        public Builder downloadFileRequest(DownloadFileRequest var1);

        default public Builder downloadFileRequest(Consumer<DownloadFileRequest.Builder> downloadFileRequestBuilder) {
            DownloadFileRequest request = (DownloadFileRequest)((DownloadFileRequest.Builder)DownloadFileRequest.builder().applyMutation(downloadFileRequestBuilder)).build();
            this.downloadFileRequest(request);
            return this;
        }

        public Builder bytesTransferred(Long var1);

        public Builder totalSizeInBytes(Long var1);

        public Builder s3ObjectLastModified(Instant var1);

        public Builder fileLastModified(Instant var1);
    }
}

