/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that displays the definition of one extended metric that RUM sends to CloudWatch or CloudWatch Evidently.
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-vended-metrics.html"> Additional
 * metrics that you can send to CloudWatch and CloudWatch Evidently</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricDefinition.Builder, MetricDefinition> {
    private static final SdkField<Map<String, String>> DIMENSION_KEYS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DimensionKeys")
            .getter(getter(MetricDefinition::dimensionKeys))
            .setter(setter(Builder::dimensionKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionKeys").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> EVENT_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventPattern").getter(getter(MetricDefinition::eventPattern)).setter(setter(Builder::eventPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventPattern").build()).build();

    private static final SdkField<String> METRIC_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricDefinitionId").getter(getter(MetricDefinition::metricDefinitionId))
            .setter(setter(Builder::metricDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDefinitionId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MetricDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(MetricDefinition::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> UNIT_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnitLabel").getter(getter(MetricDefinition::unitLabel)).setter(setter(Builder::unitLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnitLabel").build()).build();

    private static final SdkField<String> VALUE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueKey").getter(getter(MetricDefinition::valueKey)).setter(setter(Builder::valueKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_KEYS_FIELD,
            EVENT_PATTERN_FIELD, METRIC_DEFINITION_ID_FIELD, NAME_FIELD, NAMESPACE_FIELD, UNIT_LABEL_FIELD, VALUE_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> dimensionKeys;

    private final String eventPattern;

    private final String metricDefinitionId;

    private final String name;

    private final String namespace;

    private final String unitLabel;

    private final String valueKey;

    private MetricDefinition(BuilderImpl builder) {
        this.dimensionKeys = builder.dimensionKeys;
        this.eventPattern = builder.eventPattern;
        this.metricDefinitionId = builder.metricDefinitionId;
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.unitLabel = builder.unitLabel;
        this.valueKey = builder.valueKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionKeys() {
        return dimensionKeys != null && !(dimensionKeys instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This field is a map of field paths to dimension names. It defines the dimensions to associate with this metric in
     * CloudWatch The value of this field is used only if the metric destination is <code>CloudWatch</code>. If the
     * metric destination is <code>Evidently</code>, the value of <code>DimensionKeys</code> is ignored.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionKeys} method.
     * </p>
     * 
     * @return This field is a map of field paths to dimension names. It defines the dimensions to associate with this
     *         metric in CloudWatch The value of this field is used only if the metric destination is
     *         <code>CloudWatch</code>. If the metric destination is <code>Evidently</code>, the value of
     *         <code>DimensionKeys</code> is ignored.
     */
    public final Map<String, String> dimensionKeys() {
        return dimensionKeys;
    }

    /**
     * <p>
     * The pattern that defines the metric. RUM checks events that happen in a user's session against the pattern, and
     * events that match the pattern are sent to the metric destination.
     * </p>
     * <p>
     * If the metrics destination is <code>CloudWatch</code> and the event also matches a value in
     * <code>DimensionKeys</code>, then the metric is published with the specified dimensions.
     * </p>
     * 
     * @return The pattern that defines the metric. RUM checks events that happen in a user's session against the
     *         pattern, and events that match the pattern are sent to the metric destination.</p>
     *         <p>
     *         If the metrics destination is <code>CloudWatch</code> and the event also matches a value in
     *         <code>DimensionKeys</code>, then the metric is published with the specified dimensions.
     */
    public final String eventPattern() {
        return eventPattern;
    }

    /**
     * <p>
     * The ID of this metric definition.
     * </p>
     * 
     * @return The ID of this metric definition.
     */
    public final String metricDefinitionId() {
        return metricDefinitionId;
    }

    /**
     * <p>
     * The name of the metric that is defined in this structure.
     * </p>
     * 
     * @return The name of the metric that is defined in this structure.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * If this metric definition is for a custom metric instead of an extended metric, this field displays the metric
     * namespace that the custom metric is published to.
     * </p>
     * 
     * @return If this metric definition is for a custom metric instead of an extended metric, this field displays the
     *         metric namespace that the custom metric is published to.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * Use this field only if you are sending this metric to CloudWatch. It defines the CloudWatch metric unit that this
     * metric is measured in.
     * </p>
     * 
     * @return Use this field only if you are sending this metric to CloudWatch. It defines the CloudWatch metric unit
     *         that this metric is measured in.
     */
    public final String unitLabel() {
        return unitLabel;
    }

    /**
     * <p>
     * The field within the event object that the metric value is sourced from.
     * </p>
     * 
     * @return The field within the event object that the metric value is sourced from.
     */
    public final String valueKey() {
        return valueKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionKeys() ? dimensionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(metricDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(unitLabel());
        hashCode = 31 * hashCode + Objects.hashCode(valueKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDefinition)) {
            return false;
        }
        MetricDefinition other = (MetricDefinition) obj;
        return hasDimensionKeys() == other.hasDimensionKeys() && Objects.equals(dimensionKeys(), other.dimensionKeys())
                && Objects.equals(eventPattern(), other.eventPattern())
                && Objects.equals(metricDefinitionId(), other.metricDefinitionId()) && Objects.equals(name(), other.name())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(unitLabel(), other.unitLabel())
                && Objects.equals(valueKey(), other.valueKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricDefinition").add("DimensionKeys", hasDimensionKeys() ? dimensionKeys() : null)
                .add("EventPattern", eventPattern()).add("MetricDefinitionId", metricDefinitionId()).add("Name", name())
                .add("Namespace", namespace()).add("UnitLabel", unitLabel()).add("ValueKey", valueKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionKeys":
            return Optional.ofNullable(clazz.cast(dimensionKeys()));
        case "EventPattern":
            return Optional.ofNullable(clazz.cast(eventPattern()));
        case "MetricDefinitionId":
            return Optional.ofNullable(clazz.cast(metricDefinitionId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "UnitLabel":
            return Optional.ofNullable(clazz.cast(unitLabel()));
        case "ValueKey":
            return Optional.ofNullable(clazz.cast(valueKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDefinition, T> g) {
        return obj -> g.apply((MetricDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDefinition> {
        /**
         * <p>
         * This field is a map of field paths to dimension names. It defines the dimensions to associate with this
         * metric in CloudWatch The value of this field is used only if the metric destination is
         * <code>CloudWatch</code>. If the metric destination is <code>Evidently</code>, the value of
         * <code>DimensionKeys</code> is ignored.
         * </p>
         * 
         * @param dimensionKeys
         *        This field is a map of field paths to dimension names. It defines the dimensions to associate with
         *        this metric in CloudWatch The value of this field is used only if the metric destination is
         *        <code>CloudWatch</code>. If the metric destination is <code>Evidently</code>, the value of
         *        <code>DimensionKeys</code> is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionKeys(Map<String, String> dimensionKeys);

        /**
         * <p>
         * The pattern that defines the metric. RUM checks events that happen in a user's session against the pattern,
         * and events that match the pattern are sent to the metric destination.
         * </p>
         * <p>
         * If the metrics destination is <code>CloudWatch</code> and the event also matches a value in
         * <code>DimensionKeys</code>, then the metric is published with the specified dimensions.
         * </p>
         * 
         * @param eventPattern
         *        The pattern that defines the metric. RUM checks events that happen in a user's session against the
         *        pattern, and events that match the pattern are sent to the metric destination.</p>
         *        <p>
         *        If the metrics destination is <code>CloudWatch</code> and the event also matches a value in
         *        <code>DimensionKeys</code>, then the metric is published with the specified dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPattern(String eventPattern);

        /**
         * <p>
         * The ID of this metric definition.
         * </p>
         * 
         * @param metricDefinitionId
         *        The ID of this metric definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDefinitionId(String metricDefinitionId);

        /**
         * <p>
         * The name of the metric that is defined in this structure.
         * </p>
         * 
         * @param name
         *        The name of the metric that is defined in this structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * If this metric definition is for a custom metric instead of an extended metric, this field displays the
         * metric namespace that the custom metric is published to.
         * </p>
         * 
         * @param namespace
         *        If this metric definition is for a custom metric instead of an extended metric, this field displays
         *        the metric namespace that the custom metric is published to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * Use this field only if you are sending this metric to CloudWatch. It defines the CloudWatch metric unit that
         * this metric is measured in.
         * </p>
         * 
         * @param unitLabel
         *        Use this field only if you are sending this metric to CloudWatch. It defines the CloudWatch metric
         *        unit that this metric is measured in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unitLabel(String unitLabel);

        /**
         * <p>
         * The field within the event object that the metric value is sourced from.
         * </p>
         * 
         * @param valueKey
         *        The field within the event object that the metric value is sourced from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueKey(String valueKey);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> dimensionKeys = DefaultSdkAutoConstructMap.getInstance();

        private String eventPattern;

        private String metricDefinitionId;

        private String name;

        private String namespace;

        private String unitLabel;

        private String valueKey;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDefinition model) {
            dimensionKeys(model.dimensionKeys);
            eventPattern(model.eventPattern);
            metricDefinitionId(model.metricDefinitionId);
            name(model.name);
            namespace(model.namespace);
            unitLabel(model.unitLabel);
            valueKey(model.valueKey);
        }

        public final Map<String, String> getDimensionKeys() {
            if (dimensionKeys instanceof SdkAutoConstructMap) {
                return null;
            }
            return dimensionKeys;
        }

        public final void setDimensionKeys(Map<String, String> dimensionKeys) {
            this.dimensionKeys = DimensionKeysMapCopier.copy(dimensionKeys);
        }

        @Override
        public final Builder dimensionKeys(Map<String, String> dimensionKeys) {
            this.dimensionKeys = DimensionKeysMapCopier.copy(dimensionKeys);
            return this;
        }

        public final String getEventPattern() {
            return eventPattern;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final String getMetricDefinitionId() {
            return metricDefinitionId;
        }

        public final void setMetricDefinitionId(String metricDefinitionId) {
            this.metricDefinitionId = metricDefinitionId;
        }

        @Override
        public final Builder metricDefinitionId(String metricDefinitionId) {
            this.metricDefinitionId = metricDefinitionId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getUnitLabel() {
            return unitLabel;
        }

        public final void setUnitLabel(String unitLabel) {
            this.unitLabel = unitLabel;
        }

        @Override
        public final Builder unitLabel(String unitLabel) {
            this.unitLabel = unitLabel;
            return this;
        }

        public final String getValueKey() {
            return valueKey;
        }

        public final void setValueKey(String valueKey) {
            this.valueKey = valueKey;
        }

        @Override
        public final Builder valueKey(String valueKey) {
            this.valueKey = valueKey;
            return this;
        }

        @Override
        public MetricDefinition build() {
            return new MetricDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
