/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.route53resolver.model.AccessDeniedException;
import software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupRequest;
import software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupResponse;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverEndpointIpAddressRequest;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverEndpointIpAddressResponse;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.ConflictException;
import software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleGroupRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleGroupResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateFirewallRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverEndpointRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverEndpointResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.DisassociateFirewallRuleGroupRequest;
import software.amazon.awssdk.services.route53resolver.model.DisassociateFirewallRuleGroupResponse;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverEndpointIpAddressRequest;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverEndpointIpAddressResponse;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.DisassociateResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListRequest;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallDomainListResponse;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupAssociationRequest;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupAssociationResponse;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupRequest;
import software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupResponse;
import software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverDnssecConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverDnssecConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigPolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRuleAssociationRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRuleAssociationResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.GetResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsRequest;
import software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsResponse;
import software.amazon.awssdk.services.route53resolver.model.InternalServiceErrorException;
import software.amazon.awssdk.services.route53resolver.model.InvalidNextTokenException;
import software.amazon.awssdk.services.route53resolver.model.InvalidParameterException;
import software.amazon.awssdk.services.route53resolver.model.InvalidPolicyDocumentException;
import software.amazon.awssdk.services.route53resolver.model.InvalidRequestException;
import software.amazon.awssdk.services.route53resolver.model.InvalidTagException;
import software.amazon.awssdk.services.route53resolver.model.LimitExceededException;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesResponse;
import software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest;
import software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse;
import software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyRequest;
import software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyResponse;
import software.amazon.awssdk.services.route53resolver.model.ResourceExistsException;
import software.amazon.awssdk.services.route53resolver.model.ResourceInUseException;
import software.amazon.awssdk.services.route53resolver.model.ResourceNotFoundException;
import software.amazon.awssdk.services.route53resolver.model.ResourceUnavailableException;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverException;
import software.amazon.awssdk.services.route53resolver.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.route53resolver.model.TagResourceRequest;
import software.amazon.awssdk.services.route53resolver.model.TagResourceResponse;
import software.amazon.awssdk.services.route53resolver.model.ThrottlingException;
import software.amazon.awssdk.services.route53resolver.model.UnknownResourceException;
import software.amazon.awssdk.services.route53resolver.model.UntagResourceRequest;
import software.amazon.awssdk.services.route53resolver.model.UntagResourceResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleGroupAssociationResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateOutpostResolverResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointResponse;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleResponse;
import software.amazon.awssdk.services.route53resolver.model.ValidationException;
import software.amazon.awssdk.services.route53resolver.paginators.ListFirewallConfigsIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainListsIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainsIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupAssociationsIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupsIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRulesIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListOutpostResolversIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverConfigsIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverDnssecConfigsIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointIpAddressesIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigAssociationsIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigsIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesIterable;
import software.amazon.awssdk.services.route53resolver.paginators.ListTagsForResourceIterable;

/**
 * Service client for accessing Route53Resolver. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * When you create a VPC using Amazon VPC, you automatically get DNS resolution within the VPC from Route 53 Resolver.
 * By default, Resolver answers DNS queries for VPC domain names such as domain names for EC2 instances or Elastic Load
 * Balancing load balancers. Resolver performs recursive lookups against public name servers for all other domain names.
 * </p>
 * <p>
 * You can also configure DNS resolution between your VPC and your network over a Direct Connect or VPN connection:
 * </p>
 * <p>
 * <b>Forward DNS queries from resolvers on your network to Route 53 Resolver</b>
 * </p>
 * <p>
 * DNS resolvers on your network can forward DNS queries to Resolver in a specified VPC. This allows your DNS resolvers
 * to easily resolve domain names for Amazon Web Services resources such as EC2 instances or records in a Route 53
 * private hosted zone. For more information, see <a href=
 * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resolver.html#resolver-overview-forward-network-to-vpc"
 * >How DNS Resolvers on Your Network Forward DNS Queries to Route 53 Resolver</a> in the <i>Amazon Route 53 Developer
 * Guide</i>.
 * </p>
 * <p>
 * <b>Conditionally forward queries from a VPC to resolvers on your network</b>
 * </p>
 * <p>
 * You can configure Resolver to forward queries that it receives from EC2 instances in your VPCs to DNS resolvers on
 * your network. To forward selected queries, you create Resolver rules that specify the domain names for the DNS
 * queries that you want to forward (such as example.com), and the IP addresses of the DNS resolvers on your network
 * that you want to forward the queries to. If a query matches multiple rules (example.com, acme.example.com), Resolver
 * chooses the rule with the most specific match (acme.example.com) and forwards the query to the IP addresses that you
 * specified in that rule. For more information, see <a href=
 * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resolver.html#resolver-overview-forward-vpc-to-network"
 * >How Route 53 Resolver Forwards DNS Queries from Your VPCs to Your Network</a> in the <i>Amazon Route 53 Developer
 * Guide</i>.
 * </p>
 * <p>
 * Like Amazon VPC, Resolver is Regional. In each Region where you have VPCs, you can choose whether to forward queries
 * from your VPCs to your network (outbound queries), from your network to your VPCs (inbound queries), or both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Route53ResolverClient extends AwsClient {
    String SERVICE_NAME = "route53resolver";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "route53resolver";

    /**
     * <p>
     * Associates a <a>FirewallRuleGroup</a> with a VPC, to provide DNS filtering for the VPC.
     * </p>
     *
     * @param associateFirewallRuleGroupRequest
     * @return Result of the AssociateFirewallRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.AssociateFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateFirewallRuleGroupResponse associateFirewallRuleGroup(
            AssociateFirewallRuleGroupRequest associateFirewallRuleGroupRequest) throws ResourceNotFoundException,
            ValidationException, LimitExceededException, ConflictException, AccessDeniedException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a <a>FirewallRuleGroup</a> with a VPC, to provide DNS filtering for the VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateFirewallRuleGroupRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateFirewallRuleGroupRequest#builder()}
     * </p>
     *
     * @param associateFirewallRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link AssociateFirewallRuleGroupRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateFirewallRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.AssociateFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateFirewallRuleGroupResponse associateFirewallRuleGroup(
            Consumer<AssociateFirewallRuleGroupRequest.Builder> associateFirewallRuleGroupRequest)
            throws ResourceNotFoundException, ValidationException, LimitExceededException, ConflictException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return associateFirewallRuleGroup(AssociateFirewallRuleGroupRequest.builder()
                .applyMutation(associateFirewallRuleGroupRequest).build());
    }

    /**
     * <p>
     * Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address,
     * submit one <code>AssociateResolverEndpointIpAddress</code> request for each IP address.
     * </p>
     * <p>
     * To remove an IP address from an endpoint, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html"
     * >DisassociateResolverEndpointIpAddress</a>.
     * </p>
     *
     * @param associateResolverEndpointIpAddressRequest
     * @return Result of the AssociateResolverEndpointIpAddress operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.AssociateResolverEndpointIpAddress
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverEndpointIpAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateResolverEndpointIpAddressResponse associateResolverEndpointIpAddress(
            AssociateResolverEndpointIpAddressRequest associateResolverEndpointIpAddressRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, ResourceExistsException,
            InternalServiceErrorException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address,
     * submit one <code>AssociateResolverEndpointIpAddress</code> request for each IP address.
     * </p>
     * <p>
     * To remove an IP address from an endpoint, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html"
     * >DisassociateResolverEndpointIpAddress</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResolverEndpointIpAddressRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateResolverEndpointIpAddressRequest#builder()}
     * </p>
     *
     * @param associateResolverEndpointIpAddressRequest
     *        A {@link Consumer} that will call methods on {@link AssociateResolverEndpointIpAddressRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateResolverEndpointIpAddress operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.AssociateResolverEndpointIpAddress
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverEndpointIpAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateResolverEndpointIpAddressResponse associateResolverEndpointIpAddress(
            Consumer<AssociateResolverEndpointIpAddressRequest.Builder> associateResolverEndpointIpAddressRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, ResourceExistsException,
            InternalServiceErrorException, LimitExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return associateResolverEndpointIpAddress(AssociateResolverEndpointIpAddressRequest.builder()
                .applyMutation(associateResolverEndpointIpAddressRequest).build());
    }

    /**
     * <p>
     * Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that
     * originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To
     * associate more than one VPC with a configuration, submit one <code>AssociateResolverQueryLogConfig</code> request
     * for each VPC.
     * </p>
     * <note>
     * <p>
     * The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.
     * </p>
     * </note>
     * <p>
     * To remove a VPC from a query logging configuration, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html"
     * >DisassociateResolverQueryLogConfig</a>.
     * </p>
     *
     * @param associateResolverQueryLogConfigRequest
     * @return Result of the AssociateResolverQueryLogConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.AssociateResolverQueryLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateResolverQueryLogConfigResponse associateResolverQueryLogConfig(
            AssociateResolverQueryLogConfigRequest associateResolverQueryLogConfigRequest) throws InvalidParameterException,
            ResourceNotFoundException, InvalidRequestException, ResourceExistsException, LimitExceededException,
            InternalServiceErrorException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Amazon VPC with a specified query logging configuration. Route 53 Resolver logs DNS queries that
     * originate in all of the Amazon VPCs that are associated with a specified query logging configuration. To
     * associate more than one VPC with a configuration, submit one <code>AssociateResolverQueryLogConfig</code> request
     * for each VPC.
     * </p>
     * <note>
     * <p>
     * The VPCs that you associate with a query logging configuration must be in the same Region as the configuration.
     * </p>
     * </note>
     * <p>
     * To remove a VPC from a query logging configuration, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html"
     * >DisassociateResolverQueryLogConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResolverQueryLogConfigRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateResolverQueryLogConfigRequest#builder()}
     * </p>
     *
     * @param associateResolverQueryLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link AssociateResolverQueryLogConfigRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateResolverQueryLogConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.AssociateResolverQueryLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateResolverQueryLogConfigResponse associateResolverQueryLogConfig(
            Consumer<AssociateResolverQueryLogConfigRequest.Builder> associateResolverQueryLogConfigRequest)
            throws InvalidParameterException, ResourceNotFoundException, InvalidRequestException, ResourceExistsException,
            LimitExceededException, InternalServiceErrorException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return associateResolverQueryLogConfig(AssociateResolverQueryLogConfigRequest.builder()
                .applyMutation(associateResolverQueryLogConfigRequest).build());
    }

    /**
     * <p>
     * Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries
     * for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the
     * IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html"
     * >CreateResolverRule</a>.
     * </p>
     *
     * @param associateResolverRuleRequest
     * @return Result of the AssociateResolverRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource isn't available.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.AssociateResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateResolverRuleResponse associateResolverRule(AssociateResolverRuleRequest associateResolverRuleRequest)
            throws ResourceNotFoundException, InvalidRequestException, LimitExceededException, InvalidParameterException,
            ResourceUnavailableException, ResourceExistsException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries
     * for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the
     * IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html"
     * >CreateResolverRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResolverRuleRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateResolverRuleRequest#builder()}
     * </p>
     *
     * @param associateResolverRuleRequest
     *        A {@link Consumer} that will call methods on {@link AssociateResolverRuleRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateResolverRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource isn't available.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.AssociateResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateResolverRuleResponse associateResolverRule(
            Consumer<AssociateResolverRuleRequest.Builder> associateResolverRuleRequest) throws ResourceNotFoundException,
            InvalidRequestException, LimitExceededException, InvalidParameterException, ResourceUnavailableException,
            ResourceExistsException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return associateResolverRule(AssociateResolverRuleRequest.builder().applyMutation(associateResolverRuleRequest).build());
    }

    /**
     * <p>
     * Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the domains for the new
     * list with a file, using <a>ImportFirewallDomains</a>, or with domain strings, using <a>UpdateFirewallDomains</a>.
     * </p>
     *
     * @param createFirewallDomainListRequest
     * @return Result of the CreateFirewallDomainList operation returned by the service.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallDomainListResponse createFirewallDomainList(
            CreateFirewallDomainListRequest createFirewallDomainListRequest) throws LimitExceededException, ValidationException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an empty firewall domain list for use in DNS Firewall rules. You can populate the domains for the new
     * list with a file, using <a>ImportFirewallDomains</a>, or with domain strings, using <a>UpdateFirewallDomains</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallDomainListRequest.Builder} avoiding
     * the need to create one manually via {@link CreateFirewallDomainListRequest#builder()}
     * </p>
     *
     * @param createFirewallDomainListRequest
     *        A {@link Consumer} that will call methods on {@link CreateFirewallDomainListRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFirewallDomainList operation returned by the service.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallDomainListResponse createFirewallDomainList(
            Consumer<CreateFirewallDomainListRequest.Builder> createFirewallDomainListRequest) throws LimitExceededException,
            ValidationException, AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return createFirewallDomainList(CreateFirewallDomainListRequest.builder().applyMutation(createFirewallDomainListRequest)
                .build());
    }

    /**
     * <p>
     * Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.
     * </p>
     *
     * @param createFirewallRuleRequest
     * @return Result of the CreateFirewallRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallRuleResponse createFirewallRule(CreateFirewallRuleRequest createFirewallRuleRequest)
            throws ResourceNotFoundException, ValidationException, LimitExceededException, AccessDeniedException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallRuleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFirewallRuleRequest#builder()}
     * </p>
     *
     * @param createFirewallRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateFirewallRuleRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFirewallRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallRuleResponse createFirewallRule(Consumer<CreateFirewallRuleRequest.Builder> createFirewallRuleRequest)
            throws ResourceNotFoundException, ValidationException, LimitExceededException, AccessDeniedException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return createFirewallRule(CreateFirewallRuleRequest.builder().applyMutation(createFirewallRuleRequest).build());
    }

    /**
     * <p>
     * Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new
     * rule group by calling <a>CreateFirewallRule</a>.
     * </p>
     *
     * @param createFirewallRuleGroupRequest
     * @return Result of the CreateFirewallRuleGroup operation returned by the service.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallRuleGroupResponse createFirewallRuleGroup(CreateFirewallRuleGroupRequest createFirewallRuleGroupRequest)
            throws LimitExceededException, ValidationException, AccessDeniedException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new
     * rule group by calling <a>CreateFirewallRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallRuleGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateFirewallRuleGroupRequest#builder()}
     * </p>
     *
     * @param createFirewallRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateFirewallRuleGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFirewallRuleGroup operation returned by the service.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallRuleGroupResponse createFirewallRuleGroup(
            Consumer<CreateFirewallRuleGroupRequest.Builder> createFirewallRuleGroupRequest) throws LimitExceededException,
            ValidationException, AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return createFirewallRuleGroup(CreateFirewallRuleGroupRequest.builder().applyMutation(createFirewallRuleGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Route 53 Resolver on an Outpost.
     * </p>
     *
     * @param createOutpostResolverRequest
     * @return Result of the CreateOutpostResolver operation returned by the service.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         Fulfilling the request would cause one or more quotas to be exceeded.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateOutpostResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateOutpostResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOutpostResolverResponse createOutpostResolver(CreateOutpostResolverRequest createOutpostResolverRequest)
            throws AccessDeniedException, InternalServiceErrorException, ResourceNotFoundException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Route 53 Resolver on an Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOutpostResolverRequest.Builder} avoiding the
     * need to create one manually via {@link CreateOutpostResolverRequest#builder()}
     * </p>
     *
     * @param createOutpostResolverRequest
     *        A {@link Consumer} that will call methods on {@link CreateOutpostResolverRequest.Builder} to create a
     *        request.
     * @return Result of the CreateOutpostResolver operation returned by the service.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         Fulfilling the request would cause one or more quotas to be exceeded.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateOutpostResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateOutpostResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOutpostResolverResponse createOutpostResolver(
            Consumer<CreateOutpostResolverRequest.Builder> createOutpostResolverRequest) throws AccessDeniedException,
            InternalServiceErrorException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        return createOutpostResolver(CreateOutpostResolverRequest.builder().applyMutation(createOutpostResolverRequest).build());
    }

    /**
     * <p>
     * Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An <i>inbound Resolver endpoint</i> forwards DNS queries to the DNS service for a VPC from your network.
     * </p>
     * </li>
     * <li>
     * <p>
     * An <i>outbound Resolver endpoint</i> forwards DNS queries from the DNS service for a VPC to your network.
     * </p>
     * </li>
     * </ul>
     *
     * @param createResolverEndpointRequest
     * @return Result of the CreateResolverEndpoint operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateResolverEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResolverEndpointResponse createResolverEndpoint(CreateResolverEndpointRequest createResolverEndpointRequest)
            throws InvalidParameterException, ResourceNotFoundException, InvalidRequestException, ResourceExistsException,
            LimitExceededException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An <i>inbound Resolver endpoint</i> forwards DNS queries to the DNS service for a VPC from your network.
     * </p>
     * </li>
     * <li>
     * <p>
     * An <i>outbound Resolver endpoint</i> forwards DNS queries from the DNS service for a VPC to your network.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResolverEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResolverEndpointRequest#builder()}
     * </p>
     *
     * @param createResolverEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateResolverEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the CreateResolverEndpoint operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateResolverEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResolverEndpointResponse createResolverEndpoint(
            Consumer<CreateResolverEndpointRequest.Builder> createResolverEndpointRequest) throws InvalidParameterException,
            ResourceNotFoundException, InvalidRequestException, ResourceExistsException, LimitExceededException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return createResolverEndpoint(CreateResolverEndpointRequest.builder().applyMutation(createResolverEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that
     * originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging
     * configuration.
     * </p>
     * <p>
     * To specify which VPCs you want to log queries for, you use <code>AssociateResolverQueryLogConfig</code>. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html"
     * >AssociateResolverQueryLogConfig</a>.
     * </p>
     * <p>
     * You can optionally use Resource Access Manager (RAM) to share a query logging configuration with other Amazon Web
     * Services accounts. The other accounts can then associate VPCs with the configuration. The query logs that
     * Resolver creates for a configuration include all DNS queries that originate in all VPCs that are associated with
     * the configuration.
     * </p>
     *
     * @param createResolverQueryLogConfigRequest
     * @return Result of the CreateResolverQueryLogConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateResolverQueryLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResolverQueryLogConfigResponse createResolverQueryLogConfig(
            CreateResolverQueryLogConfigRequest createResolverQueryLogConfigRequest) throws InvalidParameterException,
            ResourceNotFoundException, InvalidRequestException, ResourceExistsException, LimitExceededException,
            InternalServiceErrorException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Resolver query logging configuration, which defines where you want Resolver to save DNS query logs that
     * originate in your VPCs. Resolver can log queries only for VPCs that are in the same Region as the query logging
     * configuration.
     * </p>
     * <p>
     * To specify which VPCs you want to log queries for, you use <code>AssociateResolverQueryLogConfig</code>. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html"
     * >AssociateResolverQueryLogConfig</a>.
     * </p>
     * <p>
     * You can optionally use Resource Access Manager (RAM) to share a query logging configuration with other Amazon Web
     * Services accounts. The other accounts can then associate VPCs with the configuration. The query logs that
     * Resolver creates for a configuration include all DNS queries that originate in all VPCs that are associated with
     * the configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResolverQueryLogConfigRequest.Builder}
     * avoiding the need to create one manually via {@link CreateResolverQueryLogConfigRequest#builder()}
     * </p>
     *
     * @param createResolverQueryLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateResolverQueryLogConfigRequest.Builder} to create
     *        a request.
     * @return Result of the CreateResolverQueryLogConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateResolverQueryLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResolverQueryLogConfigResponse createResolverQueryLogConfig(
            Consumer<CreateResolverQueryLogConfigRequest.Builder> createResolverQueryLogConfigRequest)
            throws InvalidParameterException, ResourceNotFoundException, InvalidRequestException, ResourceExistsException,
            LimitExceededException, InternalServiceErrorException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return createResolverQueryLogConfig(CreateResolverQueryLogConfigRequest.builder()
                .applyMutation(createResolverQueryLogConfigRequest).build());
    }

    /**
     * <p>
     * For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one
     * domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.
     * </p>
     *
     * @param createResolverRuleRequest
     * @return Result of the CreateResolverRule operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws ResourceUnavailableException
     *         The specified resource isn't available.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResolverRuleResponse createResolverRule(CreateResolverRuleRequest createResolverRuleRequest)
            throws InvalidParameterException, InvalidRequestException, LimitExceededException, ResourceNotFoundException,
            ResourceExistsException, ResourceUnavailableException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For DNS queries that originate in your VPCs, specifies which Resolver endpoint the queries pass through, one
     * domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResolverRuleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResolverRuleRequest#builder()}
     * </p>
     *
     * @param createResolverRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateResolverRuleRequest.Builder} to create a
     *        request.
     * @return Result of the CreateResolverRule operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws ResourceUnavailableException
     *         The specified resource isn't available.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.CreateResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResolverRuleResponse createResolverRule(Consumer<CreateResolverRuleRequest.Builder> createResolverRuleRequest)
            throws InvalidParameterException, InvalidRequestException, LimitExceededException, ResourceNotFoundException,
            ResourceExistsException, ResourceUnavailableException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return createResolverRule(CreateResolverRuleRequest.builder().applyMutation(createResolverRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified domain list.
     * </p>
     *
     * @param deleteFirewallDomainListRequest
     * @return Result of the DeleteFirewallDomainList operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallDomainListResponse deleteFirewallDomainList(
            DeleteFirewallDomainListRequest deleteFirewallDomainListRequest) throws ResourceNotFoundException, ConflictException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified domain list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallDomainListRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFirewallDomainListRequest#builder()}
     * </p>
     *
     * @param deleteFirewallDomainListRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFirewallDomainListRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFirewallDomainList operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallDomainListResponse deleteFirewallDomainList(
            Consumer<DeleteFirewallDomainListRequest.Builder> deleteFirewallDomainListRequest) throws ResourceNotFoundException,
            ConflictException, AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return deleteFirewallDomainList(DeleteFirewallDomainListRequest.builder().applyMutation(deleteFirewallDomainListRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified firewall rule.
     * </p>
     *
     * @param deleteFirewallRuleRequest
     * @return Result of the DeleteFirewallRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallRuleResponse deleteFirewallRule(DeleteFirewallRuleRequest deleteFirewallRuleRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified firewall rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallRuleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFirewallRuleRequest#builder()}
     * </p>
     *
     * @param deleteFirewallRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFirewallRuleRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFirewallRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallRuleResponse deleteFirewallRule(Consumer<DeleteFirewallRuleRequest.Builder> deleteFirewallRuleRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return deleteFirewallRule(DeleteFirewallRuleRequest.builder().applyMutation(deleteFirewallRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified firewall rule group.
     * </p>
     *
     * @param deleteFirewallRuleGroupRequest
     * @return Result of the DeleteFirewallRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallRuleGroupResponse deleteFirewallRuleGroup(DeleteFirewallRuleGroupRequest deleteFirewallRuleGroupRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, AccessDeniedException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified firewall rule group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallRuleGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFirewallRuleGroupRequest#builder()}
     * </p>
     *
     * @param deleteFirewallRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFirewallRuleGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFirewallRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallRuleGroupResponse deleteFirewallRuleGroup(
            Consumer<DeleteFirewallRuleGroupRequest.Builder> deleteFirewallRuleGroupRequest) throws ResourceNotFoundException,
            ConflictException, ValidationException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return deleteFirewallRuleGroup(DeleteFirewallRuleGroupRequest.builder().applyMutation(deleteFirewallRuleGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Resolver on the Outpost.
     * </p>
     *
     * @param deleteOutpostResolverRequest
     * @return Result of the DeleteOutpostResolver operation returned by the service.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteOutpostResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteOutpostResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOutpostResolverResponse deleteOutpostResolver(DeleteOutpostResolverRequest deleteOutpostResolverRequest)
            throws AccessDeniedException, ConflictException, InternalServiceErrorException, ResourceNotFoundException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Resolver on the Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOutpostResolverRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteOutpostResolverRequest#builder()}
     * </p>
     *
     * @param deleteOutpostResolverRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOutpostResolverRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteOutpostResolver operation returned by the service.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteOutpostResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteOutpostResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOutpostResolverResponse deleteOutpostResolver(
            Consumer<DeleteOutpostResolverRequest.Builder> deleteOutpostResolverRequest) throws AccessDeniedException,
            ConflictException, InternalServiceErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        return deleteOutpostResolver(DeleteOutpostResolverRequest.builder().applyMutation(deleteOutpostResolverRequest).build());
    }

    /**
     * <p>
     * Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an
     * outbound Resolver endpoint:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Inbound</b>: DNS queries from your network are no longer routed to the DNS service for the specified VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Outbound</b>: DNS queries from a VPC are no longer routed to your network.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteResolverEndpointRequest
     * @return Result of the DeleteResolverEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteResolverEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResolverEndpointResponse deleteResolverEndpoint(DeleteResolverEndpointRequest deleteResolverEndpointRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends on whether it's an inbound or an
     * outbound Resolver endpoint:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Inbound</b>: DNS queries from your network are no longer routed to the DNS service for the specified VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Outbound</b>: DNS queries from a VPC are no longer routed to your network.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResolverEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResolverEndpointRequest#builder()}
     * </p>
     *
     * @param deleteResolverEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResolverEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResolverEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteResolverEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResolverEndpointResponse deleteResolverEndpoint(
            Consumer<DeleteResolverEndpointRequest.Builder> deleteResolverEndpointRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return deleteResolverEndpoint(DeleteResolverEndpointRequest.builder().applyMutation(deleteResolverEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for
     * all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging
     * configuration is shared with other Amazon Web Services accounts, and the other accounts have associated VPCs with
     * the shared configuration.
     * </p>
     * <p>
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration.
     * See <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html"
     * >DisassociateResolverQueryLogConfig</a>.
     * </p>
     * <p>
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must
     * stop sharing the configuration before you can delete a configuration. The accounts that you shared the
     * configuration with can first disassociate VPCs that they associated with the configuration, but that's not
     * necessary. If you stop sharing the configuration, those VPCs are automatically disassociated from the
     * configuration.
     * </p>
     *
     * @param deleteResolverQueryLogConfigRequest
     * @return Result of the DeleteResolverQueryLogConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteResolverQueryLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResolverQueryLogConfigResponse deleteResolverQueryLogConfig(
            DeleteResolverQueryLogConfigRequest deleteResolverQueryLogConfigRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, InternalServiceErrorException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a query logging configuration. When you delete a configuration, Resolver stops logging DNS queries for
     * all of the Amazon VPCs that are associated with the configuration. This also applies if the query logging
     * configuration is shared with other Amazon Web Services accounts, and the other accounts have associated VPCs with
     * the shared configuration.
     * </p>
     * <p>
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration.
     * See <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html"
     * >DisassociateResolverQueryLogConfig</a>.
     * </p>
     * <p>
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, you must
     * stop sharing the configuration before you can delete a configuration. The accounts that you shared the
     * configuration with can first disassociate VPCs that they associated with the configuration, but that's not
     * necessary. If you stop sharing the configuration, those VPCs are automatically disassociated from the
     * configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResolverQueryLogConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteResolverQueryLogConfigRequest#builder()}
     * </p>
     *
     * @param deleteResolverQueryLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResolverQueryLogConfigRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteResolverQueryLogConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteResolverQueryLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResolverQueryLogConfigResponse deleteResolverQueryLogConfig(
            Consumer<DeleteResolverQueryLogConfigRequest.Builder> deleteResolverQueryLogConfigRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return deleteResolverQueryLogConfig(DeleteResolverQueryLogConfigRequest.builder()
                .applyMutation(deleteResolverQueryLogConfigRequest).build());
    }

    /**
     * <p>
     * Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that
     * you associated the Resolver rule with. For more information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html"
     * >DisassociateResolverRule</a>.
     * </p>
     *
     * @param deleteResolverRuleRequest
     * @return Result of the DeleteResolverRule operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourceInUseException
     *         The resource that you tried to update or delete is currently in use.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResolverRuleResponse deleteResolverRule(DeleteResolverRuleRequest deleteResolverRuleRequest)
            throws InvalidParameterException, ResourceNotFoundException, ResourceInUseException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Resolver rule. Before you can delete a Resolver rule, you must disassociate it from all the VPCs that
     * you associated the Resolver rule with. For more information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html"
     * >DisassociateResolverRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResolverRuleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResolverRuleRequest#builder()}
     * </p>
     *
     * @param deleteResolverRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResolverRuleRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResolverRule operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourceInUseException
     *         The resource that you tried to update or delete is currently in use.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DeleteResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResolverRuleResponse deleteResolverRule(Consumer<DeleteResolverRuleRequest.Builder> deleteResolverRuleRequest)
            throws InvalidParameterException, ResourceNotFoundException, ResourceInUseException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return deleteResolverRule(DeleteResolverRuleRequest.builder().applyMutation(deleteResolverRuleRequest).build());
    }

    /**
     * <p>
     * Disassociates a <a>FirewallRuleGroup</a> from a VPC, to remove DNS filtering from the VPC.
     * </p>
     *
     * @param disassociateFirewallRuleGroupRequest
     * @return Result of the DisassociateFirewallRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DisassociateFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateFirewallRuleGroupResponse disassociateFirewallRuleGroup(
            DisassociateFirewallRuleGroupRequest disassociateFirewallRuleGroupRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, ConflictException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a <a>FirewallRuleGroup</a> from a VPC, to remove DNS filtering from the VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFirewallRuleGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateFirewallRuleGroupRequest#builder()}
     * </p>
     *
     * @param disassociateFirewallRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFirewallRuleGroupRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateFirewallRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DisassociateFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateFirewallRuleGroupResponse disassociateFirewallRuleGroup(
            Consumer<DisassociateFirewallRuleGroupRequest.Builder> disassociateFirewallRuleGroupRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, ConflictException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return disassociateFirewallRuleGroup(DisassociateFirewallRuleGroupRequest.builder()
                .applyMutation(disassociateFirewallRuleGroupRequest).build());
    }

    /**
     * <p>
     * Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP
     * address, submit one <code>DisassociateResolverEndpointIpAddress</code> request for each IP address.
     * </p>
     * <p>
     * To add an IP address to an endpoint, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html"
     * >AssociateResolverEndpointIpAddress</a>.
     * </p>
     *
     * @param disassociateResolverEndpointIpAddressRequest
     * @return Result of the DisassociateResolverEndpointIpAddress operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DisassociateResolverEndpointIpAddress
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverEndpointIpAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateResolverEndpointIpAddressResponse disassociateResolverEndpointIpAddress(
            DisassociateResolverEndpointIpAddressRequest disassociateResolverEndpointIpAddressRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, ResourceExistsException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP
     * address, submit one <code>DisassociateResolverEndpointIpAddress</code> request for each IP address.
     * </p>
     * <p>
     * To add an IP address to an endpoint, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html"
     * >AssociateResolverEndpointIpAddress</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateResolverEndpointIpAddressRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateResolverEndpointIpAddressRequest#builder()}
     * </p>
     *
     * @param disassociateResolverEndpointIpAddressRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateResolverEndpointIpAddressRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateResolverEndpointIpAddress operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws ResourceExistsException
     *         The resource that you tried to create already exists.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DisassociateResolverEndpointIpAddress
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverEndpointIpAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateResolverEndpointIpAddressResponse disassociateResolverEndpointIpAddress(
            Consumer<DisassociateResolverEndpointIpAddressRequest.Builder> disassociateResolverEndpointIpAddressRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, ResourceExistsException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return disassociateResolverEndpointIpAddress(DisassociateResolverEndpointIpAddressRequest.builder()
                .applyMutation(disassociateResolverEndpointIpAddressRequest).build());
    }

    /**
     * <p>
     * Disassociates a VPC from a query logging configuration.
     * </p>
     * <note>
     * <p>
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration.
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, VPCs can be
     * disassociated from the configuration in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The accounts that you shared the configuration with can disassociate VPCs from the configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can stop sharing the configuration.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param disassociateResolverQueryLogConfigRequest
     * @return Result of the DisassociateResolverQueryLogConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DisassociateResolverQueryLogConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateResolverQueryLogConfigResponse disassociateResolverQueryLogConfig(
            DisassociateResolverQueryLogConfigRequest disassociateResolverQueryLogConfigRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a VPC from a query logging configuration.
     * </p>
     * <note>
     * <p>
     * Before you can delete a query logging configuration, you must first disassociate all VPCs from the configuration.
     * If you used Resource Access Manager (RAM) to share a query logging configuration with other accounts, VPCs can be
     * disassociated from the configuration in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The accounts that you shared the configuration with can disassociate VPCs from the configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can stop sharing the configuration.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateResolverQueryLogConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateResolverQueryLogConfigRequest#builder()}
     * </p>
     *
     * @param disassociateResolverQueryLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateResolverQueryLogConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateResolverQueryLogConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DisassociateResolverQueryLogConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateResolverQueryLogConfigResponse disassociateResolverQueryLogConfig(
            Consumer<DisassociateResolverQueryLogConfigRequest.Builder> disassociateResolverQueryLogConfigRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return disassociateResolverQueryLogConfig(DisassociateResolverQueryLogConfigRequest.builder()
                .applyMutation(disassociateResolverQueryLogConfigRequest).build());
    }

    /**
     * <p>
     * Removes the association between a specified Resolver rule and a specified VPC.
     * </p>
     * <important>
     * <p>
     * If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the domain name that
     * you specified in the Resolver rule.
     * </p>
     * </important>
     *
     * @param disassociateResolverRuleRequest
     * @return Result of the DisassociateResolverRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DisassociateResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateResolverRuleResponse disassociateResolverRule(
            DisassociateResolverRuleRequest disassociateResolverRuleRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between a specified Resolver rule and a specified VPC.
     * </p>
     * <important>
     * <p>
     * If you disassociate a Resolver rule from a VPC, Resolver stops forwarding DNS queries for the domain name that
     * you specified in the Resolver rule.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateResolverRuleRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateResolverRuleRequest#builder()}
     * </p>
     *
     * @param disassociateResolverRuleRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateResolverRuleRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateResolverRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.DisassociateResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateResolverRuleResponse disassociateResolverRule(
            Consumer<DisassociateResolverRuleRequest.Builder> disassociateResolverRuleRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return disassociateResolverRule(DisassociateResolverRuleRequest.builder().applyMutation(disassociateResolverRuleRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon
     * Virtual Private Cloud (Amazon VPC).
     * </p>
     *
     * @param getFirewallConfigRequest
     * @return Result of the GetFirewallConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetFirewallConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallConfigResponse getFirewallConfig(GetFirewallConfigRequest getFirewallConfigRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon
     * Virtual Private Cloud (Amazon VPC).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFirewallConfigRequest.Builder} avoiding the need
     * to create one manually via {@link GetFirewallConfigRequest#builder()}
     * </p>
     *
     * @param getFirewallConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetFirewallConfigRequest.Builder} to create a request.
     * @return Result of the GetFirewallConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetFirewallConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallConfigResponse getFirewallConfig(Consumer<GetFirewallConfigRequest.Builder> getFirewallConfigRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        return getFirewallConfig(GetFirewallConfigRequest.builder().applyMutation(getFirewallConfigRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified firewall domain list.
     * </p>
     *
     * @param getFirewallDomainListRequest
     * @return Result of the GetFirewallDomainList operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallDomainListResponse getFirewallDomainList(GetFirewallDomainListRequest getFirewallDomainListRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified firewall domain list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFirewallDomainListRequest.Builder} avoiding the
     * need to create one manually via {@link GetFirewallDomainListRequest#builder()}
     * </p>
     *
     * @param getFirewallDomainListRequest
     *        A {@link Consumer} that will call methods on {@link GetFirewallDomainListRequest.Builder} to create a
     *        request.
     * @return Result of the GetFirewallDomainList operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallDomainListResponse getFirewallDomainList(
            Consumer<GetFirewallDomainListRequest.Builder> getFirewallDomainListRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return getFirewallDomainList(GetFirewallDomainListRequest.builder().applyMutation(getFirewallDomainListRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified firewall rule group.
     * </p>
     *
     * @param getFirewallRuleGroupRequest
     * @return Result of the GetFirewallRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallRuleGroupResponse getFirewallRuleGroup(GetFirewallRuleGroupRequest getFirewallRuleGroupRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified firewall rule group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFirewallRuleGroupRequest.Builder} avoiding the
     * need to create one manually via {@link GetFirewallRuleGroupRequest#builder()}
     * </p>
     *
     * @param getFirewallRuleGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetFirewallRuleGroupRequest.Builder} to create a
     *        request.
     * @return Result of the GetFirewallRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetFirewallRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallRuleGroupResponse getFirewallRuleGroup(
            Consumer<GetFirewallRuleGroupRequest.Builder> getFirewallRuleGroupRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return getFirewallRuleGroup(GetFirewallRuleGroupRequest.builder().applyMutation(getFirewallRuleGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can
     * have more than one firewall rule group association, and a rule group can be associated with more than one VPC.
     * </p>
     *
     * @param getFirewallRuleGroupAssociationRequest
     * @return Result of the GetFirewallRuleGroupAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetFirewallRuleGroupAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallRuleGroupAssociationResponse getFirewallRuleGroupAssociation(
            GetFirewallRuleGroupAssociationRequest getFirewallRuleGroupAssociationRequest) throws ResourceNotFoundException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can
     * have more than one firewall rule group association, and a rule group can be associated with more than one VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFirewallRuleGroupAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link GetFirewallRuleGroupAssociationRequest#builder()}
     * </p>
     *
     * @param getFirewallRuleGroupAssociationRequest
     *        A {@link Consumer} that will call methods on {@link GetFirewallRuleGroupAssociationRequest.Builder} to
     *        create a request.
     * @return Result of the GetFirewallRuleGroupAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetFirewallRuleGroupAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallRuleGroupAssociationResponse getFirewallRuleGroupAssociation(
            Consumer<GetFirewallRuleGroupAssociationRequest.Builder> getFirewallRuleGroupAssociationRequest)
            throws ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return getFirewallRuleGroupAssociation(GetFirewallRuleGroupAssociationRequest.builder()
                .applyMutation(getFirewallRuleGroupAssociationRequest).build());
    }

    /**
     * <p>
     * Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group.
     * You can use the policy to share the rule group using Resource Access Manager (RAM).
     * </p>
     *
     * @param getFirewallRuleGroupPolicyRequest
     * @return Result of the GetFirewallRuleGroupPolicy operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetFirewallRuleGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallRuleGroupPolicyResponse getFirewallRuleGroupPolicy(
            GetFirewallRuleGroupPolicyRequest getFirewallRuleGroupPolicyRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the Identity and Access Management (Amazon Web Services IAM) policy for sharing the specified rule group.
     * You can use the policy to share the rule group using Resource Access Manager (RAM).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFirewallRuleGroupPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetFirewallRuleGroupPolicyRequest#builder()}
     * </p>
     *
     * @param getFirewallRuleGroupPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetFirewallRuleGroupPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetFirewallRuleGroupPolicy operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetFirewallRuleGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallRuleGroupPolicyResponse getFirewallRuleGroupPolicy(
            Consumer<GetFirewallRuleGroupPolicyRequest.Builder> getFirewallRuleGroupPolicyRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return getFirewallRuleGroupPolicy(GetFirewallRuleGroupPolicyRequest.builder()
                .applyMutation(getFirewallRuleGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified Resolver on the Outpost, such as its instance count and type, name, and the
     * current status of the Resolver.
     * </p>
     *
     * @param getOutpostResolverRequest
     * @return Result of the GetOutpostResolver operation returned by the service.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetOutpostResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetOutpostResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutpostResolverResponse getOutpostResolver(GetOutpostResolverRequest getOutpostResolverRequest)
            throws AccessDeniedException, InternalServiceErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified Resolver on the Outpost, such as its instance count and type, name, and the
     * current status of the Resolver.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutpostResolverRequest.Builder} avoiding the
     * need to create one manually via {@link GetOutpostResolverRequest#builder()}
     * </p>
     *
     * @param getOutpostResolverRequest
     *        A {@link Consumer} that will call methods on {@link GetOutpostResolverRequest.Builder} to create a
     *        request.
     * @return Result of the GetOutpostResolver operation returned by the service.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetOutpostResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetOutpostResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutpostResolverResponse getOutpostResolver(Consumer<GetOutpostResolverRequest.Builder> getOutpostResolverRequest)
            throws AccessDeniedException, InternalServiceErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        return getOutpostResolver(GetOutpostResolverRequest.builder().applyMutation(getOutpostResolverRequest).build());
    }

    /**
     * <p>
     * Retrieves the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private
     * Cloud.
     * </p>
     *
     * @param getResolverConfigRequest
     * @return Result of the GetResolverConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverConfigResponse getResolverConfig(GetResolverConfigRequest getResolverConfigRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private
     * Cloud.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverConfigRequest.Builder} avoiding the need
     * to create one manually via {@link GetResolverConfigRequest#builder()}
     * </p>
     *
     * @param getResolverConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverConfigRequest.Builder} to create a request.
     * @return Result of the GetResolverConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverConfigResponse getResolverConfig(Consumer<GetResolverConfigRequest.Builder> getResolverConfigRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        return getResolverConfig(GetResolverConfigRequest.builder().applyMutation(getResolverConfigRequest).build());
    }

    /**
     * <p>
     * Gets DNSSEC validation information for a specified resource.
     * </p>
     *
     * @param getResolverDnssecConfigRequest
     * @return Result of the GetResolverDnssecConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverDnssecConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverDnssecConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverDnssecConfigResponse getResolverDnssecConfig(GetResolverDnssecConfigRequest getResolverDnssecConfigRequest)
            throws InvalidParameterException, ResourceNotFoundException, InvalidRequestException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets DNSSEC validation information for a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverDnssecConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetResolverDnssecConfigRequest#builder()}
     * </p>
     *
     * @param getResolverDnssecConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverDnssecConfigRequest.Builder} to create a
     *        request.
     * @return Result of the GetResolverDnssecConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverDnssecConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverDnssecConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverDnssecConfigResponse getResolverDnssecConfig(
            Consumer<GetResolverDnssecConfigRequest.Builder> getResolverDnssecConfigRequest) throws InvalidParameterException,
            ResourceNotFoundException, InvalidRequestException, InternalServiceErrorException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return getResolverDnssecConfig(GetResolverDnssecConfigRequest.builder().applyMutation(getResolverDnssecConfigRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver
     * endpoint, and the current status of the endpoint.
     * </p>
     *
     * @param getResolverEndpointRequest
     * @return Result of the GetResolverEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverEndpointResponse getResolverEndpoint(GetResolverEndpointRequest getResolverEndpointRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified Resolver endpoint, such as whether it's an inbound or an outbound Resolver
     * endpoint, and the current status of the endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link GetResolverEndpointRequest#builder()}
     * </p>
     *
     * @param getResolverEndpointRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the GetResolverEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverEndpointResponse getResolverEndpoint(
            Consumer<GetResolverEndpointRequest.Builder> getResolverEndpointRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return getResolverEndpoint(GetResolverEndpointRequest.builder().applyMutation(getResolverEndpointRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the
     * configuration is logging queries for and the location that logs are sent to.
     * </p>
     *
     * @param getResolverQueryLogConfigRequest
     * @return Result of the GetResolverQueryLogConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverQueryLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverQueryLogConfigResponse getResolverQueryLogConfig(
            GetResolverQueryLogConfigRequest getResolverQueryLogConfigRequest) throws ResourceNotFoundException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified Resolver query logging configuration, such as the number of VPCs that the
     * configuration is logging queries for and the location that logs are sent to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverQueryLogConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetResolverQueryLogConfigRequest#builder()}
     * </p>
     *
     * @param getResolverQueryLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverQueryLogConfigRequest.Builder} to create a
     *        request.
     * @return Result of the GetResolverQueryLogConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverQueryLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverQueryLogConfigResponse getResolverQueryLogConfig(
            Consumer<GetResolverQueryLogConfigRequest.Builder> getResolverQueryLogConfigRequest)
            throws ResourceNotFoundException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return getResolverQueryLogConfig(GetResolverQueryLogConfigRequest.builder()
                .applyMutation(getResolverQueryLogConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC.
     * When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that
     * VPC.
     * </p>
     *
     * @param getResolverQueryLogConfigAssociationRequest
     * @return Result of the GetResolverQueryLogConfigAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverQueryLogConfigAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverQueryLogConfigAssociationResponse getResolverQueryLogConfigAssociation(
            GetResolverQueryLogConfigAssociationRequest getResolverQueryLogConfigAssociationRequest)
            throws ResourceNotFoundException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified association between a Resolver query logging configuration and an Amazon VPC.
     * When you associate a VPC with a query logging configuration, Resolver logs DNS queries that originate in that
     * VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetResolverQueryLogConfigAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link GetResolverQueryLogConfigAssociationRequest#builder()}
     * </p>
     *
     * @param getResolverQueryLogConfigAssociationRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverQueryLogConfigAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the GetResolverQueryLogConfigAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverQueryLogConfigAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverQueryLogConfigAssociationResponse getResolverQueryLogConfigAssociation(
            Consumer<GetResolverQueryLogConfigAssociationRequest.Builder> getResolverQueryLogConfigAssociationRequest)
            throws ResourceNotFoundException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return getResolverQueryLogConfigAssociation(GetResolverQueryLogConfigAssociationRequest.builder()
                .applyMutation(getResolverQueryLogConfigAssociationRequest).build());
    }

    /**
     * <p>
     * Gets information about a query logging policy. A query logging policy specifies the Resolver query logging
     * operations and resources that you want to allow another Amazon Web Services account to be able to use.
     * </p>
     *
     * @param getResolverQueryLogConfigPolicyRequest
     * @return Result of the GetResolverQueryLogConfigPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws UnknownResourceException
     *         The specified resource doesn't exist.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverQueryLogConfigPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverQueryLogConfigPolicyResponse getResolverQueryLogConfigPolicy(
            GetResolverQueryLogConfigPolicyRequest getResolverQueryLogConfigPolicyRequest) throws InvalidParameterException,
            InvalidRequestException, UnknownResourceException, InternalServiceErrorException, AccessDeniedException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a query logging policy. A query logging policy specifies the Resolver query logging
     * operations and resources that you want to allow another Amazon Web Services account to be able to use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverQueryLogConfigPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetResolverQueryLogConfigPolicyRequest#builder()}
     * </p>
     *
     * @param getResolverQueryLogConfigPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverQueryLogConfigPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the GetResolverQueryLogConfigPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws UnknownResourceException
     *         The specified resource doesn't exist.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverQueryLogConfigPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverQueryLogConfigPolicyResponse getResolverQueryLogConfigPolicy(
            Consumer<GetResolverQueryLogConfigPolicyRequest.Builder> getResolverQueryLogConfigPolicyRequest)
            throws InvalidParameterException, InvalidRequestException, UnknownResourceException, InternalServiceErrorException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return getResolverQueryLogConfigPolicy(GetResolverQueryLogConfigPolicyRequest.builder()
                .applyMutation(getResolverQueryLogConfigPolicyRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for
     * and the ID of the outbound Resolver endpoint that the rule is associated with.
     * </p>
     *
     * @param getResolverRuleRequest
     * @return Result of the GetResolverRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverRuleResponse getResolverRule(GetResolverRuleRequest getResolverRuleRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified Resolver rule, such as the domain name that the rule forwards DNS queries for
     * and the ID of the outbound Resolver endpoint that the rule is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverRuleRequest.Builder} avoiding the need
     * to create one manually via {@link GetResolverRuleRequest#builder()}
     * </p>
     *
     * @param getResolverRuleRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverRuleRequest.Builder} to create a request.
     * @return Result of the GetResolverRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverRuleResponse getResolverRule(Consumer<GetResolverRuleRequest.Builder> getResolverRuleRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return getResolverRule(GetResolverRuleRequest.builder().applyMutation(getResolverRuleRequest).build());
    }

    /**
     * <p>
     * Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule
     * and a VPC using <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html"
     * >AssociateResolverRule</a>.
     * </p>
     *
     * @param getResolverRuleAssociationRequest
     * @return Result of the GetResolverRuleAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverRuleAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverRuleAssociationResponse getResolverRuleAssociation(
            GetResolverRuleAssociationRequest getResolverRuleAssociationRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule
     * and a VPC using <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html"
     * >AssociateResolverRule</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverRuleAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link GetResolverRuleAssociationRequest#builder()}
     * </p>
     *
     * @param getResolverRuleAssociationRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverRuleAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the GetResolverRuleAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverRuleAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverRuleAssociationResponse getResolverRuleAssociation(
            Consumer<GetResolverRuleAssociationRequest.Builder> getResolverRuleAssociationRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return getResolverRuleAssociation(GetResolverRuleAssociationRequest.builder()
                .applyMutation(getResolverRuleAssociationRequest).build());
    }

    /**
     * <p>
     * Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule
     * that you want to share with another account, the account that you want to share the rule with, and the Resolver
     * operations that you want to allow the account to use.
     * </p>
     *
     * @param getResolverRulePolicyRequest
     * @return Result of the GetResolverRulePolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws UnknownResourceException
     *         The specified resource doesn't exist.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverRulePolicyResponse getResolverRulePolicy(GetResolverRulePolicyRequest getResolverRulePolicyRequest)
            throws InvalidParameterException, UnknownResourceException, InternalServiceErrorException, AccessDeniedException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule
     * that you want to share with another account, the account that you want to share the rule with, and the Resolver
     * operations that you want to allow the account to use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverRulePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetResolverRulePolicyRequest#builder()}
     * </p>
     *
     * @param getResolverRulePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetResolverRulePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetResolverRulePolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws UnknownResourceException
     *         The specified resource doesn't exist.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.GetResolverRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResolverRulePolicyResponse getResolverRulePolicy(
            Consumer<GetResolverRulePolicyRequest.Builder> getResolverRulePolicyRequest) throws InvalidParameterException,
            UnknownResourceException, InternalServiceErrorException, AccessDeniedException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return getResolverRulePolicy(GetResolverRulePolicyRequest.builder().applyMutation(getResolverRulePolicyRequest).build());
    }

    /**
     * <p>
     * Imports domain names from a file into a domain list, for use in a DNS firewall rule group.
     * </p>
     * <p>
     * Each domain specification in your domain list must satisfy the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It can optionally start with <code>*</code> (asterisk).
     * </p>
     * </li>
     * <li>
     * <p>
     * With the exception of the optional starting asterisk, it must only contain the following characters:
     * <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).
     * </p>
     * </li>
     * <li>
     * <p>
     * It must be from 1-255 characters in length.
     * </p>
     * </li>
     * </ul>
     *
     * @param importFirewallDomainsRequest
     * @return Result of the ImportFirewallDomains operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ImportFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ImportFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportFirewallDomainsResponse importFirewallDomains(ImportFirewallDomainsRequest importFirewallDomainsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, LimitExceededException,
            ConflictException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports domain names from a file into a domain list, for use in a DNS firewall rule group.
     * </p>
     * <p>
     * Each domain specification in your domain list must satisfy the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It can optionally start with <code>*</code> (asterisk).
     * </p>
     * </li>
     * <li>
     * <p>
     * With the exception of the optional starting asterisk, it must only contain the following characters:
     * <code>A-Z</code>, <code>a-z</code>, <code>0-9</code>, <code>-</code> (hyphen).
     * </p>
     * </li>
     * <li>
     * <p>
     * It must be from 1-255 characters in length.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportFirewallDomainsRequest.Builder} avoiding the
     * need to create one manually via {@link ImportFirewallDomainsRequest#builder()}
     * </p>
     *
     * @param importFirewallDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ImportFirewallDomainsRequest.Builder} to create a
     *        request.
     * @return Result of the ImportFirewallDomains operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ImportFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ImportFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportFirewallDomainsResponse importFirewallDomains(
            Consumer<ImportFirewallDomainsRequest.Builder> importFirewallDomainsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, LimitExceededException, ConflictException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return importFirewallDomains(ImportFirewallDomainsRequest.builder().applyMutation(importFirewallDomainsRequest).build());
    }

    /**
     * <p>
     * Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage
     * firewall behavior for your VPCs.
     * </p>
     * <p>
     * A single call might return only a partial list of the configurations. For information, see
     * <code>MaxResults</code>.
     * </p>
     *
     * @param listFirewallConfigsRequest
     * @return Result of the ListFirewallConfigs operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallConfigsResponse listFirewallConfigs(ListFirewallConfigsRequest listFirewallConfigsRequest)
            throws ValidationException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage
     * firewall behavior for your VPCs.
     * </p>
     * <p>
     * A single call might return only a partial list of the configurations. For information, see
     * <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallConfigsRequest#builder()}
     * </p>
     *
     * @param listFirewallConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallConfigsRequest.Builder} to create a
     *        request.
     * @return Result of the ListFirewallConfigs operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallConfigsResponse listFirewallConfigs(
            Consumer<ListFirewallConfigsRequest.Builder> listFirewallConfigsRequest) throws ValidationException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return listFirewallConfigs(ListFirewallConfigsRequest.builder().applyMutation(listFirewallConfigsRequest).build());
    }

    /**
     * <p>
     * Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage
     * firewall behavior for your VPCs.
     * </p>
     * <p>
     * A single call might return only a partial list of the configurations. For information, see
     * <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallConfigs(software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallConfigsIterable responses = client.listFirewallConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListFirewallConfigsIterable responses = client
     *             .listFirewallConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallConfigsIterable responses = client.listFirewallConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallConfigs(software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallConfigsIterable listFirewallConfigsPaginator(ListFirewallConfigsRequest listFirewallConfigsRequest)
            throws ValidationException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListFirewallConfigsIterable(this, listFirewallConfigsRequest);
    }

    /**
     * <p>
     * Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage
     * firewall behavior for your VPCs.
     * </p>
     * <p>
     * A single call might return only a partial list of the configurations. For information, see
     * <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallConfigs(software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallConfigsIterable responses = client.listFirewallConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListFirewallConfigsIterable responses = client
     *             .listFirewallConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallConfigsIterable responses = client.listFirewallConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallConfigs(software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallConfigsRequest#builder()}
     * </p>
     *
     * @param listFirewallConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallConfigsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallConfigsIterable listFirewallConfigsPaginator(
            Consumer<ListFirewallConfigsRequest.Builder> listFirewallConfigsRequest) throws ValidationException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return listFirewallConfigsPaginator(ListFirewallConfigsRequest.builder().applyMutation(listFirewallConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the
     * domains that are defined for a list by calling <a>ListFirewallDomains</a>.
     * </p>
     * <p>
     * A single call to this list operation might return only a partial list of the domain lists. For information, see
     * <code>MaxResults</code>.
     * </p>
     *
     * @param listFirewallDomainListsRequest
     * @return Result of the ListFirewallDomainLists operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainListsResponse listFirewallDomainLists(ListFirewallDomainListsRequest listFirewallDomainListsRequest)
            throws ValidationException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the
     * domains that are defined for a list by calling <a>ListFirewallDomains</a>.
     * </p>
     * <p>
     * A single call to this list operation might return only a partial list of the domain lists. For information, see
     * <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallDomainListsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFirewallDomainListsRequest#builder()}
     * </p>
     *
     * @param listFirewallDomainListsRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallDomainListsRequest.Builder} to create a
     *        request.
     * @return Result of the ListFirewallDomainLists operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainListsResponse listFirewallDomainLists(
            Consumer<ListFirewallDomainListsRequest.Builder> listFirewallDomainListsRequest) throws ValidationException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return listFirewallDomainLists(ListFirewallDomainListsRequest.builder().applyMutation(listFirewallDomainListsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the
     * domains that are defined for a list by calling <a>ListFirewallDomains</a>.
     * </p>
     * <p>
     * A single call to this list operation might return only a partial list of the domain lists. For information, see
     * <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallDomainLists(software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainListsIterable responses = client.listFirewallDomainListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainListsIterable responses = client
     *             .listFirewallDomainListsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainListsIterable responses = client.listFirewallDomainListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallDomainLists(software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallDomainListsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainListsIterable listFirewallDomainListsPaginator(
            ListFirewallDomainListsRequest listFirewallDomainListsRequest) throws ValidationException, AccessDeniedException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListFirewallDomainListsIterable(this, listFirewallDomainListsRequest);
    }

    /**
     * <p>
     * Retrieves the firewall domain lists that you have defined. For each firewall domain list, you can retrieve the
     * domains that are defined for a list by calling <a>ListFirewallDomains</a>.
     * </p>
     * <p>
     * A single call to this list operation might return only a partial list of the domain lists. For information, see
     * <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallDomainLists(software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainListsIterable responses = client.listFirewallDomainListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainListsIterable responses = client
     *             .listFirewallDomainListsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainListsIterable responses = client.listFirewallDomainListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallDomainLists(software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallDomainListsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFirewallDomainListsRequest#builder()}
     * </p>
     *
     * @param listFirewallDomainListsRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallDomainListsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainListsIterable listFirewallDomainListsPaginator(
            Consumer<ListFirewallDomainListsRequest.Builder> listFirewallDomainListsRequest) throws ValidationException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return listFirewallDomainListsPaginator(ListFirewallDomainListsRequest.builder()
                .applyMutation(listFirewallDomainListsRequest).build());
    }

    /**
     * <p>
     * Retrieves the domains that you have defined for the specified firewall domain list.
     * </p>
     * <p>
     * A single call might return only a partial list of the domains. For information, see <code>MaxResults</code>.
     * </p>
     *
     * @param listFirewallDomainsRequest
     * @return Result of the ListFirewallDomains operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainsResponse listFirewallDomains(ListFirewallDomainsRequest listFirewallDomainsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the domains that you have defined for the specified firewall domain list.
     * </p>
     * <p>
     * A single call might return only a partial list of the domains. For information, see <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallDomainsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallDomainsRequest#builder()}
     * </p>
     *
     * @param listFirewallDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallDomainsRequest.Builder} to create a
     *        request.
     * @return Result of the ListFirewallDomains operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainsResponse listFirewallDomains(
            Consumer<ListFirewallDomainsRequest.Builder> listFirewallDomainsRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return listFirewallDomains(ListFirewallDomainsRequest.builder().applyMutation(listFirewallDomainsRequest).build());
    }

    /**
     * <p>
     * Retrieves the domains that you have defined for the specified firewall domain list.
     * </p>
     * <p>
     * A single call might return only a partial list of the domains. For information, see <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallDomains(software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainsIterable responses = client.listFirewallDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainsIterable responses = client
     *             .listFirewallDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainsIterable responses = client.listFirewallDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallDomains(software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallDomainsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainsIterable listFirewallDomainsPaginator(ListFirewallDomainsRequest listFirewallDomainsRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListFirewallDomainsIterable(this, listFirewallDomainsRequest);
    }

    /**
     * <p>
     * Retrieves the domains that you have defined for the specified firewall domain list.
     * </p>
     * <p>
     * A single call might return only a partial list of the domains. For information, see <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallDomains(software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainsIterable responses = client.listFirewallDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainsIterable responses = client
     *             .listFirewallDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallDomainsIterable responses = client.listFirewallDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallDomains(software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallDomainsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallDomainsRequest#builder()}
     * </p>
     *
     * @param listFirewallDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallDomainsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainsIterable listFirewallDomainsPaginator(
            Consumer<ListFirewallDomainsRequest.Builder> listFirewallDomainsRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return listFirewallDomainsPaginator(ListFirewallDomainsRequest.builder().applyMutation(listFirewallDomainsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for
     * a VPC with one rule group.
     * </p>
     * <p>
     * A single call might return only a partial list of the associations. For information, see <code>MaxResults</code>.
     * </p>
     *
     * @param listFirewallRuleGroupAssociationsRequest
     * @return Result of the ListFirewallRuleGroupAssociations operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallRuleGroupAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroupAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRuleGroupAssociationsResponse listFirewallRuleGroupAssociations(
            ListFirewallRuleGroupAssociationsRequest listFirewallRuleGroupAssociationsRequest) throws ValidationException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for
     * a VPC with one rule group.
     * </p>
     * <p>
     * A single call might return only a partial list of the associations. For information, see <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallRuleGroupAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFirewallRuleGroupAssociationsRequest#builder()}
     * </p>
     *
     * @param listFirewallRuleGroupAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallRuleGroupAssociationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListFirewallRuleGroupAssociations operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallRuleGroupAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroupAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRuleGroupAssociationsResponse listFirewallRuleGroupAssociations(
            Consumer<ListFirewallRuleGroupAssociationsRequest.Builder> listFirewallRuleGroupAssociationsRequest)
            throws ValidationException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return listFirewallRuleGroupAssociations(ListFirewallRuleGroupAssociationsRequest.builder()
                .applyMutation(listFirewallRuleGroupAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for
     * a VPC with one rule group.
     * </p>
     * <p>
     * A single call might return only a partial list of the associations. For information, see <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallRuleGroupAssociations(software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupAssociationsIterable responses = client.listFirewallRuleGroupAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupAssociationsIterable responses = client
     *             .listFirewallRuleGroupAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupAssociationsIterable responses = client.listFirewallRuleGroupAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallRuleGroupAssociations(software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallRuleGroupAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallRuleGroupAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroupAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRuleGroupAssociationsIterable listFirewallRuleGroupAssociationsPaginator(
            ListFirewallRuleGroupAssociationsRequest listFirewallRuleGroupAssociationsRequest) throws ValidationException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return new ListFirewallRuleGroupAssociationsIterable(this, listFirewallRuleGroupAssociationsRequest);
    }

    /**
     * <p>
     * Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for
     * a VPC with one rule group.
     * </p>
     * <p>
     * A single call might return only a partial list of the associations. For information, see <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallRuleGroupAssociations(software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupAssociationsIterable responses = client.listFirewallRuleGroupAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupAssociationsIterable responses = client
     *             .listFirewallRuleGroupAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupAssociationsIterable responses = client.listFirewallRuleGroupAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallRuleGroupAssociations(software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallRuleGroupAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFirewallRuleGroupAssociationsRequest#builder()}
     * </p>
     *
     * @param listFirewallRuleGroupAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallRuleGroupAssociationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallRuleGroupAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroupAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRuleGroupAssociationsIterable listFirewallRuleGroupAssociationsPaginator(
            Consumer<ListFirewallRuleGroupAssociationsRequest.Builder> listFirewallRuleGroupAssociationsRequest)
            throws ValidationException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return listFirewallRuleGroupAssociationsPaginator(ListFirewallRuleGroupAssociationsRequest.builder()
                .applyMutation(listFirewallRuleGroupAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the minimal high-level information for the rule groups that you have defined.
     * </p>
     * <p>
     * A single call might return only a partial list of the rule groups. For information, see <code>MaxResults</code>.
     * </p>
     *
     * @param listFirewallRuleGroupsRequest
     * @return Result of the ListFirewallRuleGroups operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRuleGroupsResponse listFirewallRuleGroups(ListFirewallRuleGroupsRequest listFirewallRuleGroupsRequest)
            throws ValidationException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the minimal high-level information for the rule groups that you have defined.
     * </p>
     * <p>
     * A single call might return only a partial list of the rule groups. For information, see <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallRuleGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listFirewallRuleGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallRuleGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListFirewallRuleGroups operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRuleGroupsResponse listFirewallRuleGroups(
            Consumer<ListFirewallRuleGroupsRequest.Builder> listFirewallRuleGroupsRequest) throws ValidationException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return listFirewallRuleGroups(ListFirewallRuleGroupsRequest.builder().applyMutation(listFirewallRuleGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the minimal high-level information for the rule groups that you have defined.
     * </p>
     * <p>
     * A single call might return only a partial list of the rule groups. For information, see <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallRuleGroups(software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupsIterable responses = client.listFirewallRuleGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupsIterable responses = client
     *             .listFirewallRuleGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupsIterable responses = client.listFirewallRuleGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallRuleGroups(software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallRuleGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRuleGroupsIterable listFirewallRuleGroupsPaginator(
            ListFirewallRuleGroupsRequest listFirewallRuleGroupsRequest) throws ValidationException, AccessDeniedException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListFirewallRuleGroupsIterable(this, listFirewallRuleGroupsRequest);
    }

    /**
     * <p>
     * Retrieves the minimal high-level information for the rule groups that you have defined.
     * </p>
     * <p>
     * A single call might return only a partial list of the rule groups. For information, see <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallRuleGroups(software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupsIterable responses = client.listFirewallRuleGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupsIterable responses = client
     *             .listFirewallRuleGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRuleGroupsIterable responses = client.listFirewallRuleGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallRuleGroups(software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallRuleGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallRuleGroupsRequest#builder()}
     * </p>
     *
     * @param listFirewallRuleGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallRuleGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRuleGroupsIterable listFirewallRuleGroupsPaginator(
            Consumer<ListFirewallRuleGroupsRequest.Builder> listFirewallRuleGroupsRequest) throws ValidationException,
            AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return listFirewallRuleGroupsPaginator(ListFirewallRuleGroupsRequest.builder()
                .applyMutation(listFirewallRuleGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the
     * rules in a rule group to filter DNS network traffic for a VPC.
     * </p>
     * <p>
     * A single call might return only a partial list of the rules. For information, see <code>MaxResults</code>.
     * </p>
     *
     * @param listFirewallRulesRequest
     * @return Result of the ListFirewallRules operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRulesResponse listFirewallRules(ListFirewallRulesRequest listFirewallRulesRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the
     * rules in a rule group to filter DNS network traffic for a VPC.
     * </p>
     * <p>
     * A single call might return only a partial list of the rules. For information, see <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListFirewallRulesRequest#builder()}
     * </p>
     *
     * @param listFirewallRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallRulesRequest.Builder} to create a request.
     * @return Result of the ListFirewallRules operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRulesResponse listFirewallRules(Consumer<ListFirewallRulesRequest.Builder> listFirewallRulesRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listFirewallRules(ListFirewallRulesRequest.builder().applyMutation(listFirewallRulesRequest).build());
    }

    /**
     * <p>
     * Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the
     * rules in a rule group to filter DNS network traffic for a VPC.
     * </p>
     * <p>
     * A single call might return only a partial list of the rules. For information, see <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallRules(software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRulesIterable responses = client.listFirewallRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRulesIterable responses = client
     *             .listFirewallRulesPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRulesIterable responses = client.listFirewallRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallRules(software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRulesIterable listFirewallRulesPaginator(ListFirewallRulesRequest listFirewallRulesRequest)
            throws ResourceNotFoundException, ValidationException, AccessDeniedException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListFirewallRulesIterable(this, listFirewallRulesRequest);
    }

    /**
     * <p>
     * Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the
     * rules in a rule group to filter DNS network traffic for a VPC.
     * </p>
     * <p>
     * A single call might return only a partial list of the rules. For information, see <code>MaxResults</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFirewallRules(software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRulesIterable responses = client.listFirewallRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRulesIterable responses = client
     *             .listFirewallRulesPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListFirewallRulesIterable responses = client.listFirewallRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallRules(software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListFirewallRulesRequest#builder()}
     * </p>
     *
     * @param listFirewallRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListFirewallRulesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRulesIterable listFirewallRulesPaginator(
            Consumer<ListFirewallRulesRequest.Builder> listFirewallRulesRequest) throws ResourceNotFoundException,
            ValidationException, AccessDeniedException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return listFirewallRulesPaginator(ListFirewallRulesRequest.builder().applyMutation(listFirewallRulesRequest).build());
    }

    /**
     * <p>
     * Lists all the Resolvers on Outposts that were created using the current Amazon Web Services account.
     * </p>
     *
     * @param listOutpostResolversRequest
     * @return Result of the ListOutpostResolvers operation returned by the service.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListOutpostResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListOutpostResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOutpostResolversResponse listOutpostResolvers(ListOutpostResolversRequest listOutpostResolversRequest)
            throws AccessDeniedException, InternalServiceErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the Resolvers on Outposts that were created using the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOutpostResolversRequest.Builder} avoiding the
     * need to create one manually via {@link ListOutpostResolversRequest#builder()}
     * </p>
     *
     * @param listOutpostResolversRequest
     *        A {@link Consumer} that will call methods on {@link ListOutpostResolversRequest.Builder} to create a
     *        request.
     * @return Result of the ListOutpostResolvers operation returned by the service.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListOutpostResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListOutpostResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOutpostResolversResponse listOutpostResolvers(
            Consumer<ListOutpostResolversRequest.Builder> listOutpostResolversRequest) throws AccessDeniedException,
            InternalServiceErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return listOutpostResolvers(ListOutpostResolversRequest.builder().applyMutation(listOutpostResolversRequest).build());
    }

    /**
     * <p>
     * Lists all the Resolvers on Outposts that were created using the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOutpostResolvers(software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListOutpostResolversIterable responses = client.listOutpostResolversPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListOutpostResolversIterable responses = client
     *             .listOutpostResolversPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListOutpostResolversIterable responses = client.listOutpostResolversPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOutpostResolvers(software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOutpostResolversRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListOutpostResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListOutpostResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOutpostResolversIterable listOutpostResolversPaginator(ListOutpostResolversRequest listOutpostResolversRequest)
            throws AccessDeniedException, InternalServiceErrorException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListOutpostResolversIterable(this, listOutpostResolversRequest);
    }

    /**
     * <p>
     * Lists all the Resolvers on Outposts that were created using the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOutpostResolvers(software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListOutpostResolversIterable responses = client.listOutpostResolversPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListOutpostResolversIterable responses = client
     *             .listOutpostResolversPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListOutpostResolversIterable responses = client.listOutpostResolversPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOutpostResolvers(software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOutpostResolversRequest.Builder} avoiding the
     * need to create one manually via {@link ListOutpostResolversRequest#builder()}
     * </p>
     *
     * @param listOutpostResolversRequest
     *        A {@link Consumer} that will call methods on {@link ListOutpostResolversRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListOutpostResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListOutpostResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOutpostResolversIterable listOutpostResolversPaginator(
            Consumer<ListOutpostResolversRequest.Builder> listOutpostResolversRequest) throws AccessDeniedException,
            InternalServiceErrorException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return listOutpostResolversPaginator(ListOutpostResolversRequest.builder().applyMutation(listOutpostResolversRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage
     * DNS resolution behavior for your VPCs.
     * </p>
     *
     * @param listResolverConfigsRequest
     * @return Result of the ListResolverConfigs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverConfigsResponse listResolverConfigs(ListResolverConfigsRequest listResolverConfigsRequest)
            throws InvalidNextTokenException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage
     * DNS resolution behavior for your VPCs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListResolverConfigsRequest#builder()}
     * </p>
     *
     * @param listResolverConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverConfigsRequest.Builder} to create a
     *        request.
     * @return Result of the ListResolverConfigs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverConfigsResponse listResolverConfigs(
            Consumer<ListResolverConfigsRequest.Builder> listResolverConfigsRequest) throws InvalidNextTokenException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverConfigs(ListResolverConfigsRequest.builder().applyMutation(listResolverConfigsRequest).build());
    }

    /**
     * <p>
     * Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage
     * DNS resolution behavior for your VPCs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverConfigsIterable responses = client.listResolverConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverConfigsIterable responses = client
     *             .listResolverConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverConfigsIterable responses = client.listResolverConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverConfigsIterable listResolverConfigsPaginator(ListResolverConfigsRequest listResolverConfigsRequest)
            throws InvalidNextTokenException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return new ListResolverConfigsIterable(this, listResolverConfigsRequest);
    }

    /**
     * <p>
     * Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage
     * DNS resolution behavior for your VPCs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverConfigsIterable responses = client.listResolverConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverConfigsIterable responses = client
     *             .listResolverConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverConfigsIterable responses = client.listResolverConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListResolverConfigsRequest#builder()}
     * </p>
     *
     * @param listResolverConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverConfigsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverConfigsIterable listResolverConfigsPaginator(
            Consumer<ListResolverConfigsRequest.Builder> listResolverConfigsRequest) throws InvalidNextTokenException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverConfigsPaginator(ListResolverConfigsRequest.builder().applyMutation(listResolverConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.
     * </p>
     *
     * @param listResolverDnssecConfigsRequest
     * @return Result of the ListResolverDnssecConfigs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverDnssecConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverDnssecConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverDnssecConfigsResponse listResolverDnssecConfigs(
            ListResolverDnssecConfigsRequest listResolverDnssecConfigsRequest) throws InvalidNextTokenException,
            InvalidParameterException, InvalidRequestException, InternalServiceErrorException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverDnssecConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResolverDnssecConfigsRequest#builder()}
     * </p>
     *
     * @param listResolverDnssecConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverDnssecConfigsRequest.Builder} to create a
     *        request.
     * @return Result of the ListResolverDnssecConfigs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverDnssecConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverDnssecConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverDnssecConfigsResponse listResolverDnssecConfigs(
            Consumer<ListResolverDnssecConfigsRequest.Builder> listResolverDnssecConfigsRequest)
            throws InvalidNextTokenException, InvalidParameterException, InvalidRequestException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverDnssecConfigs(ListResolverDnssecConfigsRequest.builder()
                .applyMutation(listResolverDnssecConfigsRequest).build());
    }

    /**
     * <p>
     * Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverDnssecConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverDnssecConfigsIterable responses = client.listResolverDnssecConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverDnssecConfigsIterable responses = client
     *             .listResolverDnssecConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverDnssecConfigsIterable responses = client.listResolverDnssecConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverDnssecConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverDnssecConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverDnssecConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverDnssecConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverDnssecConfigsIterable listResolverDnssecConfigsPaginator(
            ListResolverDnssecConfigsRequest listResolverDnssecConfigsRequest) throws InvalidNextTokenException,
            InvalidParameterException, InvalidRequestException, InternalServiceErrorException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListResolverDnssecConfigsIterable(this, listResolverDnssecConfigsRequest);
    }

    /**
     * <p>
     * Lists the configurations for DNSSEC validation that are associated with the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverDnssecConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverDnssecConfigsIterable responses = client.listResolverDnssecConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverDnssecConfigsIterable responses = client
     *             .listResolverDnssecConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverDnssecConfigsIterable responses = client.listResolverDnssecConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverDnssecConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverDnssecConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverDnssecConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResolverDnssecConfigsRequest#builder()}
     * </p>
     *
     * @param listResolverDnssecConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverDnssecConfigsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverDnssecConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverDnssecConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverDnssecConfigsIterable listResolverDnssecConfigsPaginator(
            Consumer<ListResolverDnssecConfigsRequest.Builder> listResolverDnssecConfigsRequest)
            throws InvalidNextTokenException, InvalidParameterException, InvalidRequestException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverDnssecConfigsPaginator(ListResolverDnssecConfigsRequest.builder()
                .applyMutation(listResolverDnssecConfigsRequest).build());
    }

    /**
     * <p>
     * Gets the IP addresses for a specified Resolver endpoint.
     * </p>
     *
     * @param listResolverEndpointIpAddressesRequest
     * @return Result of the ListResolverEndpointIpAddresses operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverEndpointIpAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointIpAddressesResponse listResolverEndpointIpAddresses(
            ListResolverEndpointIpAddressesRequest listResolverEndpointIpAddressesRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServiceErrorException, InvalidNextTokenException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the IP addresses for a specified Resolver endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverEndpointIpAddressesRequest.Builder}
     * avoiding the need to create one manually via {@link ListResolverEndpointIpAddressesRequest#builder()}
     * </p>
     *
     * @param listResolverEndpointIpAddressesRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverEndpointIpAddressesRequest.Builder} to
     *        create a request.
     * @return Result of the ListResolverEndpointIpAddresses operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverEndpointIpAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointIpAddressesResponse listResolverEndpointIpAddresses(
            Consumer<ListResolverEndpointIpAddressesRequest.Builder> listResolverEndpointIpAddressesRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServiceErrorException,
            InvalidNextTokenException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverEndpointIpAddresses(ListResolverEndpointIpAddressesRequest.builder()
                .applyMutation(listResolverEndpointIpAddressesRequest).build());
    }

    /**
     * <p>
     * Gets the IP addresses for a specified Resolver endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverEndpointIpAddresses(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointIpAddressesIterable responses = client.listResolverEndpointIpAddressesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointIpAddressesIterable responses = client
     *             .listResolverEndpointIpAddressesPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointIpAddressesIterable responses = client.listResolverEndpointIpAddressesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverEndpointIpAddresses(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverEndpointIpAddressesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverEndpointIpAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointIpAddressesIterable listResolverEndpointIpAddressesPaginator(
            ListResolverEndpointIpAddressesRequest listResolverEndpointIpAddressesRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServiceErrorException, InvalidNextTokenException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListResolverEndpointIpAddressesIterable(this, listResolverEndpointIpAddressesRequest);
    }

    /**
     * <p>
     * Gets the IP addresses for a specified Resolver endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverEndpointIpAddresses(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointIpAddressesIterable responses = client.listResolverEndpointIpAddressesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointIpAddressesIterable responses = client
     *             .listResolverEndpointIpAddressesPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointIpAddressesIterable responses = client.listResolverEndpointIpAddressesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverEndpointIpAddresses(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverEndpointIpAddressesRequest.Builder}
     * avoiding the need to create one manually via {@link ListResolverEndpointIpAddressesRequest#builder()}
     * </p>
     *
     * @param listResolverEndpointIpAddressesRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverEndpointIpAddressesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverEndpointIpAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointIpAddressesIterable listResolverEndpointIpAddressesPaginator(
            Consumer<ListResolverEndpointIpAddressesRequest.Builder> listResolverEndpointIpAddressesRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServiceErrorException,
            InvalidNextTokenException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverEndpointIpAddressesPaginator(ListResolverEndpointIpAddressesRequest.builder()
                .applyMutation(listResolverEndpointIpAddressesRequest).build());
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
     * </p>
     *
     * @param listResolverEndpointsRequest
     * @return Result of the ListResolverEndpoints operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointsResponse listResolverEndpoints(ListResolverEndpointsRequest listResolverEndpointsRequest)
            throws InvalidNextTokenException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListResolverEndpointsRequest#builder()}
     * </p>
     *
     * @param listResolverEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverEndpointsRequest.Builder} to create a
     *        request.
     * @return Result of the ListResolverEndpoints operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointsResponse listResolverEndpoints(
            Consumer<ListResolverEndpointsRequest.Builder> listResolverEndpointsRequest) throws InvalidNextTokenException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverEndpoints(ListResolverEndpointsRequest.builder().applyMutation(listResolverEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
     * </p>
     *
     * @return Result of the ListResolverEndpoints operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverEndpoints
     * @see #listResolverEndpoints(ListResolverEndpointsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointsResponse listResolverEndpoints() throws InvalidNextTokenException, InvalidRequestException,
            InvalidParameterException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return listResolverEndpoints(ListResolverEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverEndpoints(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsIterable responses = client.listResolverEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsIterable responses = client
     *             .listResolverEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsIterable responses = client.listResolverEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverEndpoints(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverEndpoints
     * @see #listResolverEndpointsPaginator(ListResolverEndpointsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointsIterable listResolverEndpointsPaginator() throws InvalidNextTokenException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverEndpointsPaginator(ListResolverEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverEndpoints(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsIterable responses = client.listResolverEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsIterable responses = client
     *             .listResolverEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsIterable responses = client.listResolverEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverEndpoints(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointsIterable listResolverEndpointsPaginator(ListResolverEndpointsRequest listResolverEndpointsRequest)
            throws InvalidNextTokenException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListResolverEndpointsIterable(this, listResolverEndpointsRequest);
    }

    /**
     * <p>
     * Lists all the Resolver endpoints that were created using the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverEndpoints(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsIterable responses = client.listResolverEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsIterable responses = client
     *             .listResolverEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverEndpointsIterable responses = client.listResolverEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverEndpoints(software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link ListResolverEndpointsRequest#builder()}
     * </p>
     *
     * @param listResolverEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverEndpointsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverEndpointsIterable listResolverEndpointsPaginator(
            Consumer<ListResolverEndpointsRequest.Builder> listResolverEndpointsRequest) throws InvalidNextTokenException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverEndpointsPaginator(ListResolverEndpointsRequest.builder().applyMutation(listResolverEndpointsRequest)
                .build());
    }

    /**
     * <p>
     * Lists information about associations between Amazon VPCs and query logging configurations.
     * </p>
     *
     * @param listResolverQueryLogConfigAssociationsRequest
     * @return Result of the ListResolverQueryLogConfigAssociations operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverQueryLogConfigAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverQueryLogConfigAssociationsResponse listResolverQueryLogConfigAssociations(
            ListResolverQueryLogConfigAssociationsRequest listResolverQueryLogConfigAssociationsRequest)
            throws InvalidParameterException, InvalidRequestException, LimitExceededException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about associations between Amazon VPCs and query logging configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListResolverQueryLogConfigAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListResolverQueryLogConfigAssociationsRequest#builder()}
     * </p>
     *
     * @param listResolverQueryLogConfigAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverQueryLogConfigAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListResolverQueryLogConfigAssociations operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverQueryLogConfigAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverQueryLogConfigAssociationsResponse listResolverQueryLogConfigAssociations(
            Consumer<ListResolverQueryLogConfigAssociationsRequest.Builder> listResolverQueryLogConfigAssociationsRequest)
            throws InvalidParameterException, InvalidRequestException, LimitExceededException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverQueryLogConfigAssociations(ListResolverQueryLogConfigAssociationsRequest.builder()
                .applyMutation(listResolverQueryLogConfigAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists information about associations between Amazon VPCs and query logging configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverQueryLogConfigAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigAssociationsIterable responses = client.listResolverQueryLogConfigAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigAssociationsIterable responses = client
     *             .listResolverQueryLogConfigAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigAssociationsIterable responses = client.listResolverQueryLogConfigAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverQueryLogConfigAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverQueryLogConfigAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverQueryLogConfigAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverQueryLogConfigAssociationsIterable listResolverQueryLogConfigAssociationsPaginator(
            ListResolverQueryLogConfigAssociationsRequest listResolverQueryLogConfigAssociationsRequest)
            throws InvalidParameterException, InvalidRequestException, LimitExceededException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListResolverQueryLogConfigAssociationsIterable(this, listResolverQueryLogConfigAssociationsRequest);
    }

    /**
     * <p>
     * Lists information about associations between Amazon VPCs and query logging configurations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverQueryLogConfigAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigAssociationsIterable responses = client.listResolverQueryLogConfigAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigAssociationsIterable responses = client
     *             .listResolverQueryLogConfigAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigAssociationsIterable responses = client.listResolverQueryLogConfigAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverQueryLogConfigAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListResolverQueryLogConfigAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListResolverQueryLogConfigAssociationsRequest#builder()}
     * </p>
     *
     * @param listResolverQueryLogConfigAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverQueryLogConfigAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverQueryLogConfigAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverQueryLogConfigAssociationsIterable listResolverQueryLogConfigAssociationsPaginator(
            Consumer<ListResolverQueryLogConfigAssociationsRequest.Builder> listResolverQueryLogConfigAssociationsRequest)
            throws InvalidParameterException, InvalidRequestException, LimitExceededException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverQueryLogConfigAssociationsPaginator(ListResolverQueryLogConfigAssociationsRequest.builder()
                .applyMutation(listResolverQueryLogConfigAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists information about the specified query logging configurations. Each configuration defines where you want
     * Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     * </p>
     *
     * @param listResolverQueryLogConfigsRequest
     * @return Result of the ListResolverQueryLogConfigs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverQueryLogConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverQueryLogConfigsResponse listResolverQueryLogConfigs(
            ListResolverQueryLogConfigsRequest listResolverQueryLogConfigsRequest) throws InvalidNextTokenException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the specified query logging configurations. Each configuration defines where you want
     * Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverQueryLogConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResolverQueryLogConfigsRequest#builder()}
     * </p>
     *
     * @param listResolverQueryLogConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverQueryLogConfigsRequest.Builder} to create
     *        a request.
     * @return Result of the ListResolverQueryLogConfigs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverQueryLogConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverQueryLogConfigsResponse listResolverQueryLogConfigs(
            Consumer<ListResolverQueryLogConfigsRequest.Builder> listResolverQueryLogConfigsRequest)
            throws InvalidNextTokenException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverQueryLogConfigs(ListResolverQueryLogConfigsRequest.builder()
                .applyMutation(listResolverQueryLogConfigsRequest).build());
    }

    /**
     * <p>
     * Lists information about the specified query logging configurations. Each configuration defines where you want
     * Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverQueryLogConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigsIterable responses = client.listResolverQueryLogConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigsIterable responses = client
     *             .listResolverQueryLogConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigsIterable responses = client.listResolverQueryLogConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverQueryLogConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverQueryLogConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverQueryLogConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverQueryLogConfigsIterable listResolverQueryLogConfigsPaginator(
            ListResolverQueryLogConfigsRequest listResolverQueryLogConfigsRequest) throws InvalidNextTokenException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListResolverQueryLogConfigsIterable(this, listResolverQueryLogConfigsRequest);
    }

    /**
     * <p>
     * Lists information about the specified query logging configurations. Each configuration defines where you want
     * Resolver to save DNS query logs and specifies the VPCs that you want to log queries for.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverQueryLogConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigsIterable responses = client.listResolverQueryLogConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigsIterable responses = client
     *             .listResolverQueryLogConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverQueryLogConfigsIterable responses = client.listResolverQueryLogConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverQueryLogConfigs(software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverQueryLogConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResolverQueryLogConfigsRequest#builder()}
     * </p>
     *
     * @param listResolverQueryLogConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverQueryLogConfigsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverQueryLogConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverQueryLogConfigsIterable listResolverQueryLogConfigsPaginator(
            Consumer<ListResolverQueryLogConfigsRequest.Builder> listResolverQueryLogConfigsRequest)
            throws InvalidNextTokenException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverQueryLogConfigsPaginator(ListResolverQueryLogConfigsRequest.builder()
                .applyMutation(listResolverQueryLogConfigsRequest).build());
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services
     * account.
     * </p>
     *
     * @param listResolverRuleAssociationsRequest
     * @return Result of the ListResolverRuleAssociations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverRuleAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRuleAssociationsResponse listResolverRuleAssociations(
            ListResolverRuleAssociationsRequest listResolverRuleAssociationsRequest) throws InvalidNextTokenException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverRuleAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResolverRuleAssociationsRequest#builder()}
     * </p>
     *
     * @param listResolverRuleAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverRuleAssociationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListResolverRuleAssociations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverRuleAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRuleAssociationsResponse listResolverRuleAssociations(
            Consumer<ListResolverRuleAssociationsRequest.Builder> listResolverRuleAssociationsRequest)
            throws InvalidNextTokenException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverRuleAssociations(ListResolverRuleAssociationsRequest.builder()
                .applyMutation(listResolverRuleAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services
     * account.
     * </p>
     *
     * @return Result of the ListResolverRuleAssociations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverRuleAssociations
     * @see #listResolverRuleAssociations(ListResolverRuleAssociationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRuleAssociationsResponse listResolverRuleAssociations() throws InvalidNextTokenException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverRuleAssociations(ListResolverRuleAssociationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverRuleAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsIterable responses = client.listResolverRuleAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsIterable responses = client
     *             .listResolverRuleAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsIterable responses = client.listResolverRuleAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverRuleAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverRuleAssociations
     * @see #listResolverRuleAssociationsPaginator(ListResolverRuleAssociationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRuleAssociationsIterable listResolverRuleAssociationsPaginator() throws InvalidNextTokenException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverRuleAssociationsPaginator(ListResolverRuleAssociationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverRuleAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsIterable responses = client.listResolverRuleAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsIterable responses = client
     *             .listResolverRuleAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsIterable responses = client.listResolverRuleAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverRuleAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverRuleAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverRuleAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRuleAssociationsIterable listResolverRuleAssociationsPaginator(
            ListResolverRuleAssociationsRequest listResolverRuleAssociationsRequest) throws InvalidNextTokenException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListResolverRuleAssociationsIterable(this, listResolverRuleAssociationsRequest);
    }

    /**
     * <p>
     * Lists the associations that were created between Resolver rules and VPCs using the current Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverRuleAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsIterable responses = client.listResolverRuleAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsIterable responses = client
     *             .listResolverRuleAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRuleAssociationsIterable responses = client.listResolverRuleAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverRuleAssociations(software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverRuleAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResolverRuleAssociationsRequest#builder()}
     * </p>
     *
     * @param listResolverRuleAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverRuleAssociationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverRuleAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRuleAssociationsIterable listResolverRuleAssociationsPaginator(
            Consumer<ListResolverRuleAssociationsRequest.Builder> listResolverRuleAssociationsRequest)
            throws InvalidNextTokenException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverRuleAssociationsPaginator(ListResolverRuleAssociationsRequest.builder()
                .applyMutation(listResolverRuleAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current Amazon Web Services account.
     * </p>
     *
     * @param listResolverRulesRequest
     * @return Result of the ListResolverRules operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRulesResponse listResolverRules(ListResolverRulesRequest listResolverRulesRequest)
            throws InvalidNextTokenException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListResolverRulesRequest#builder()}
     * </p>
     *
     * @param listResolverRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverRulesRequest.Builder} to create a request.
     * @return Result of the ListResolverRules operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRulesResponse listResolverRules(Consumer<ListResolverRulesRequest.Builder> listResolverRulesRequest)
            throws InvalidNextTokenException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverRules(ListResolverRulesRequest.builder().applyMutation(listResolverRulesRequest).build());
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current Amazon Web Services account.
     * </p>
     *
     * @return Result of the ListResolverRules operation returned by the service.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverRules
     * @see #listResolverRules(ListResolverRulesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRulesResponse listResolverRules() throws InvalidNextTokenException, InvalidRequestException,
            InvalidParameterException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return listResolverRules(ListResolverRulesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverRules(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesIterable responses = client.listResolverRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesIterable responses = client
     *             .listResolverRulesPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesIterable responses = client.listResolverRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverRules(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverRules
     * @see #listResolverRulesPaginator(ListResolverRulesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRulesIterable listResolverRulesPaginator() throws InvalidNextTokenException, InvalidRequestException,
            InvalidParameterException, InternalServiceErrorException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return listResolverRulesPaginator(ListResolverRulesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverRules(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesIterable responses = client.listResolverRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesIterable responses = client
     *             .listResolverRulesPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesIterable responses = client.listResolverRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverRules(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolverRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRulesIterable listResolverRulesPaginator(ListResolverRulesRequest listResolverRulesRequest)
            throws InvalidNextTokenException, InvalidRequestException, InvalidParameterException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListResolverRulesIterable(this, listResolverRulesRequest);
    }

    /**
     * <p>
     * Lists the Resolver rules that were created using the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResolverRules(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesIterable responses = client.listResolverRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesIterable responses = client
     *             .listResolverRulesPaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListResolverRulesIterable responses = client.listResolverRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolverRules(software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolverRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListResolverRulesRequest#builder()}
     * </p>
     *
     * @param listResolverRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListResolverRulesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListResolverRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolverRulesIterable listResolverRulesPaginator(
            Consumer<ListResolverRulesRequest.Builder> listResolverRulesRequest) throws InvalidNextTokenException,
            InvalidRequestException, InvalidParameterException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return listResolverRulesPaginator(ListResolverRulesRequest.builder().applyMutation(listResolverRulesRequest).build());
    }

    /**
     * <p>
     * Lists the tags that you associated with the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidNextTokenException, InvalidRequestException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that you associated with the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidNextTokenException, InvalidRequestException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the tags that you associated with the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidNextTokenException, InvalidRequestException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return new ListTagsForResourceIterable(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * Lists the tags that you associated with the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53resolver.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53resolver.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.route53resolver.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidNextTokenException
     *         The value that you specified for <code>NextToken</code> in a <code>List</code> request isn't valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidNextTokenException, InvalidRequestException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the rule group. You can
     * use the policy to share the rule group using Resource Access Manager (RAM).
     * </p>
     *
     * @param putFirewallRuleGroupPolicyRequest
     * @return Result of the PutFirewallRuleGroupPolicy operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.PutFirewallRuleGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutFirewallRuleGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutFirewallRuleGroupPolicyResponse putFirewallRuleGroupPolicy(
            PutFirewallRuleGroupPolicyRequest putFirewallRuleGroupPolicyRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches an Identity and Access Management (Amazon Web Services IAM) policy for sharing the rule group. You can
     * use the policy to share the rule group using Resource Access Manager (RAM).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFirewallRuleGroupPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutFirewallRuleGroupPolicyRequest#builder()}
     * </p>
     *
     * @param putFirewallRuleGroupPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutFirewallRuleGroupPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutFirewallRuleGroupPolicy operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.PutFirewallRuleGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutFirewallRuleGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutFirewallRuleGroupPolicyResponse putFirewallRuleGroupPolicy(
            Consumer<PutFirewallRuleGroupPolicyRequest.Builder> putFirewallRuleGroupPolicyRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return putFirewallRuleGroupPolicy(PutFirewallRuleGroupPolicyRequest.builder()
                .applyMutation(putFirewallRuleGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Specifies an Amazon Web Services account that you want to share a query logging configuration with, the query
     * logging configuration that you want to share, and the operations that you want the account to be able to perform
     * on the configuration.
     * </p>
     *
     * @param putResolverQueryLogConfigPolicyRequest
     * @return Result of the PutResolverQueryLogConfigPolicy operation returned by the service.
     * @throws InvalidPolicyDocumentException
     *         The specified Resolver rule policy is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws UnknownResourceException
     *         The specified resource doesn't exist.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.PutResolverQueryLogConfigPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverQueryLogConfigPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResolverQueryLogConfigPolicyResponse putResolverQueryLogConfigPolicy(
            PutResolverQueryLogConfigPolicyRequest putResolverQueryLogConfigPolicyRequest) throws InvalidPolicyDocumentException,
            InvalidParameterException, InvalidRequestException, UnknownResourceException, InternalServiceErrorException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies an Amazon Web Services account that you want to share a query logging configuration with, the query
     * logging configuration that you want to share, and the operations that you want the account to be able to perform
     * on the configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResolverQueryLogConfigPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link PutResolverQueryLogConfigPolicyRequest#builder()}
     * </p>
     *
     * @param putResolverQueryLogConfigPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResolverQueryLogConfigPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the PutResolverQueryLogConfigPolicy operation returned by the service.
     * @throws InvalidPolicyDocumentException
     *         The specified Resolver rule policy is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws UnknownResourceException
     *         The specified resource doesn't exist.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.PutResolverQueryLogConfigPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverQueryLogConfigPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResolverQueryLogConfigPolicyResponse putResolverQueryLogConfigPolicy(
            Consumer<PutResolverQueryLogConfigPolicyRequest.Builder> putResolverQueryLogConfigPolicyRequest)
            throws InvalidPolicyDocumentException, InvalidParameterException, InvalidRequestException, UnknownResourceException,
            InternalServiceErrorException, AccessDeniedException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return putResolverQueryLogConfigPolicy(PutResolverQueryLogConfigPolicyRequest.builder()
                .applyMutation(putResolverQueryLogConfigPolicyRequest).build());
    }

    /**
     * <p>
     * Specifies an Amazon Web Services rule that you want to share with another account, the account that you want to
     * share the rule with, and the operations that you want the account to be able to perform on the rule.
     * </p>
     *
     * @param putResolverRulePolicyRequest
     * @return Result of the PutResolverRulePolicy operation returned by the service.
     * @throws InvalidPolicyDocumentException
     *         The specified Resolver rule policy is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws UnknownResourceException
     *         The specified resource doesn't exist.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.PutResolverRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResolverRulePolicyResponse putResolverRulePolicy(PutResolverRulePolicyRequest putResolverRulePolicyRequest)
            throws InvalidPolicyDocumentException, InvalidParameterException, UnknownResourceException,
            InternalServiceErrorException, AccessDeniedException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies an Amazon Web Services rule that you want to share with another account, the account that you want to
     * share the rule with, and the operations that you want the account to be able to perform on the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResolverRulePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutResolverRulePolicyRequest#builder()}
     * </p>
     *
     * @param putResolverRulePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResolverRulePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutResolverRulePolicy operation returned by the service.
     * @throws InvalidPolicyDocumentException
     *         The specified Resolver rule policy is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws UnknownResourceException
     *         The specified resource doesn't exist.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.PutResolverRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResolverRulePolicyResponse putResolverRulePolicy(
            Consumer<PutResolverRulePolicyRequest.Builder> putResolverRulePolicyRequest) throws InvalidPolicyDocumentException,
            InvalidParameterException, UnknownResourceException, InternalServiceErrorException, AccessDeniedException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return putResolverRulePolicy(PutResolverRulePolicyRequest.builder().applyMutation(putResolverRulePolicyRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidTagException
     *         The specified tag is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws LimitExceededException,
            ResourceNotFoundException, InvalidParameterException, InvalidRequestException, InvalidTagException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidTagException
     *         The specified tag is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws LimitExceededException, ResourceNotFoundException, InvalidParameterException, InvalidRequestException,
            InvalidTagException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual
     * Private Cloud (Amazon VPC).
     * </p>
     *
     * @param updateFirewallConfigRequest
     * @return Result of the UpdateFirewallConfig operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateFirewallConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallConfigResponse updateFirewallConfig(UpdateFirewallConfigRequest updateFirewallConfigRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of the firewall behavior provided by DNS Firewall for a single VPC from Amazon Virtual
     * Private Cloud (Amazon VPC).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFirewallConfigRequest#builder()}
     * </p>
     *
     * @param updateFirewallConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFirewallConfigRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFirewallConfig operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateFirewallConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallConfigResponse updateFirewallConfig(
            Consumer<UpdateFirewallConfigRequest.Builder> updateFirewallConfigRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return updateFirewallConfig(UpdateFirewallConfigRequest.builder().applyMutation(updateFirewallConfigRequest).build());
    }

    /**
     * <p>
     * Updates the firewall domain list from an array of domain specifications.
     * </p>
     *
     * @param updateFirewallDomainsRequest
     * @return Result of the UpdateFirewallDomains operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallDomainsResponse updateFirewallDomains(UpdateFirewallDomainsRequest updateFirewallDomainsRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, LimitExceededException,
            ConflictException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the firewall domain list from an array of domain specifications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallDomainsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFirewallDomainsRequest#builder()}
     * </p>
     *
     * @param updateFirewallDomainsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFirewallDomainsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFirewallDomains operation returned by the service.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallDomainsResponse updateFirewallDomains(
            Consumer<UpdateFirewallDomainsRequest.Builder> updateFirewallDomainsRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, LimitExceededException, ConflictException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return updateFirewallDomains(UpdateFirewallDomainsRequest.builder().applyMutation(updateFirewallDomainsRequest).build());
    }

    /**
     * <p>
     * Updates the specified firewall rule.
     * </p>
     *
     * @param updateFirewallRuleRequest
     * @return Result of the UpdateFirewallRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallRuleResponse updateFirewallRule(UpdateFirewallRuleRequest updateFirewallRuleRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified firewall rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallRuleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFirewallRuleRequest#builder()}
     * </p>
     *
     * @param updateFirewallRuleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFirewallRuleRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFirewallRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallRuleResponse updateFirewallRule(Consumer<UpdateFirewallRuleRequest.Builder> updateFirewallRuleRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return updateFirewallRule(UpdateFirewallRuleRequest.builder().applyMutation(updateFirewallRuleRequest).build());
    }

    /**
     * <p>
     * Changes the association of a <a>FirewallRuleGroup</a> with a VPC. The association enables DNS filtering for the
     * VPC.
     * </p>
     *
     * @param updateFirewallRuleGroupAssociationRequest
     * @return Result of the UpdateFirewallRuleGroupAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateFirewallRuleGroupAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallRuleGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallRuleGroupAssociationResponse updateFirewallRuleGroupAssociation(
            UpdateFirewallRuleGroupAssociationRequest updateFirewallRuleGroupAssociationRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the association of a <a>FirewallRuleGroup</a> with a VPC. The association enables DNS filtering for the
     * VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallRuleGroupAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFirewallRuleGroupAssociationRequest#builder()}
     * </p>
     *
     * @param updateFirewallRuleGroupAssociationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFirewallRuleGroupAssociationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateFirewallRuleGroupAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateFirewallRuleGroupAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallRuleGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallRuleGroupAssociationResponse updateFirewallRuleGroupAssociation(
            Consumer<UpdateFirewallRuleGroupAssociationRequest.Builder> updateFirewallRuleGroupAssociationRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException,
            InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        return updateFirewallRuleGroupAssociation(UpdateFirewallRuleGroupAssociationRequest.builder()
                .applyMutation(updateFirewallRuleGroupAssociationRequest).build());
    }

    /**
     * <p>
     * You can use <code>UpdateOutpostResolver</code> to update the instance count, type, or name of a Resolver on an
     * Outpost.
     * </p>
     *
     * @param updateOutpostResolverRequest
     * @return Result of the UpdateOutpostResolver operation returned by the service.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         Fulfilling the request would cause one or more quotas to be exceeded.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateOutpostResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateOutpostResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOutpostResolverResponse updateOutpostResolver(UpdateOutpostResolverRequest updateOutpostResolverRequest)
            throws AccessDeniedException, ConflictException, InternalServiceErrorException, ResourceNotFoundException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can use <code>UpdateOutpostResolver</code> to update the instance count, type, or name of a Resolver on an
     * Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOutpostResolverRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateOutpostResolverRequest#builder()}
     * </p>
     *
     * @param updateOutpostResolverRequest
     *        A {@link Consumer} that will call methods on {@link UpdateOutpostResolverRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateOutpostResolver operation returned by the service.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ConflictException
     *         The requested state transition isn't valid. For example, you can't delete a firewall domain list if it is
     *         in the process of being deleted, or you can't import domains into a domain list that is in the process of
     *         being deleted.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ServiceQuotaExceededException
     *         Fulfilling the request would cause one or more quotas to be exceeded.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateOutpostResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateOutpostResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOutpostResolverResponse updateOutpostResolver(
            Consumer<UpdateOutpostResolverRequest.Builder> updateOutpostResolverRequest) throws AccessDeniedException,
            ConflictException, InternalServiceErrorException, ResourceNotFoundException, ServiceQuotaExceededException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        return updateOutpostResolver(UpdateOutpostResolverRequest.builder().applyMutation(updateOutpostResolverRequest).build());
    }

    /**
     * <p>
     * Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private
     * Cloud.
     * </p>
     *
     * @param updateResolverConfigRequest
     * @return Result of the UpdateResolverConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourceUnavailableException
     *         The specified resource isn't available.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateResolverConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResolverConfigResponse updateResolverConfig(UpdateResolverConfigRequest updateResolverConfigRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ResourceUnavailableException,
            LimitExceededException, InternalServiceErrorException, ThrottlingException, AccessDeniedException,
            ValidationException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private
     * Cloud.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResolverConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResolverConfigRequest#builder()}
     * </p>
     *
     * @param updateResolverConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResolverConfigRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResolverConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourceUnavailableException
     *         The specified resource isn't available.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws ValidationException
     *         You have provided an invalid command. Supported values are <code>ADD</code>, <code>REMOVE</code>, or
     *         <code>REPLACE</code> a domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateResolverConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResolverConfigResponse updateResolverConfig(
            Consumer<UpdateResolverConfigRequest.Builder> updateResolverConfigRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ResourceUnavailableException, LimitExceededException,
            InternalServiceErrorException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, Route53ResolverException {
        return updateResolverConfig(UpdateResolverConfigRequest.builder().applyMutation(updateResolverConfigRequest).build());
    }

    /**
     * <p>
     * Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one
     * is created.
     * </p>
     *
     * @param updateResolverDnssecConfigRequest
     * @return Result of the UpdateResolverDnssecConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateResolverDnssecConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverDnssecConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResolverDnssecConfigResponse updateResolverDnssecConfig(
            UpdateResolverDnssecConfigRequest updateResolverDnssecConfigRequest) throws InvalidParameterException,
            ResourceNotFoundException, InvalidRequestException, InternalServiceErrorException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one
     * is created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResolverDnssecConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateResolverDnssecConfigRequest#builder()}
     * </p>
     *
     * @param updateResolverDnssecConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResolverDnssecConfigRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResolverDnssecConfig operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws AccessDeniedException
     *         The current account doesn't have the IAM permissions required to perform the specified Resolver
     *         operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateResolverDnssecConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverDnssecConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResolverDnssecConfigResponse updateResolverDnssecConfig(
            Consumer<UpdateResolverDnssecConfigRequest.Builder> updateResolverDnssecConfigRequest)
            throws InvalidParameterException, ResourceNotFoundException, InvalidRequestException, InternalServiceErrorException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, Route53ResolverException {
        return updateResolverDnssecConfig(UpdateResolverDnssecConfigRequest.builder()
                .applyMutation(updateResolverDnssecConfigRequest).build());
    }

    /**
     * <p>
     * Updates the name, or enpoint type for an inbound or an outbound Resolver endpoint. You can only update between
     * IPV4 and DUALSTACK, IPV6 endpoint type can't be updated to other type.
     * </p>
     *
     * @param updateResolverEndpointRequest
     * @return Result of the UpdateResolverEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateResolverEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResolverEndpointResponse updateResolverEndpoint(UpdateResolverEndpointRequest updateResolverEndpointRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException, InternalServiceErrorException,
            ThrottlingException, AwsServiceException, SdkClientException, Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name, or enpoint type for an inbound or an outbound Resolver endpoint. You can only update between
     * IPV4 and DUALSTACK, IPV6 endpoint type can't be updated to other type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResolverEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResolverEndpointRequest#builder()}
     * </p>
     *
     * @param updateResolverEndpointRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResolverEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResolverEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateResolverEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResolverEndpointResponse updateResolverEndpoint(
            Consumer<UpdateResolverEndpointRequest.Builder> updateResolverEndpointRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, InternalServiceErrorException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53ResolverException {
        return updateResolverEndpoint(UpdateResolverEndpointRequest.builder().applyMutation(updateResolverEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Updates settings for a specified Resolver rule. <code>ResolverRuleId</code> is required, and all other parameters
     * are optional. If you don't specify a parameter, it retains its current value.
     * </p>
     *
     * @param updateResolverRuleRequest
     * @return Result of the UpdateResolverRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourceUnavailableException
     *         The specified resource isn't available.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResolverRuleResponse updateResolverRule(UpdateResolverRuleRequest updateResolverRuleRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ResourceUnavailableException,
            LimitExceededException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates settings for a specified Resolver rule. <code>ResolverRuleId</code> is required, and all other parameters
     * are optional. If you don't specify a parameter, it retains its current value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResolverRuleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResolverRuleRequest#builder()}
     * </p>
     *
     * @param updateResolverRuleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResolverRuleRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResolverRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is invalid.
     * @throws InvalidParameterException
     *         One or more parameters in this request are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource doesn't exist.
     * @throws ResourceUnavailableException
     *         The specified resource isn't available.
     * @throws LimitExceededException
     *         The request caused one or more limits to be exceeded.
     * @throws InternalServiceErrorException
     *         We encountered an unknown error. Try again in a few minutes.
     * @throws ThrottlingException
     *         The request was throttled. Try again in a few minutes.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53ResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53ResolverClient.UpdateResolverRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResolverRuleResponse updateResolverRule(Consumer<UpdateResolverRuleRequest.Builder> updateResolverRuleRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ResourceUnavailableException,
            LimitExceededException, InternalServiceErrorException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53ResolverException {
        return updateResolverRule(UpdateResolverRuleRequest.builder().applyMutation(updateResolverRuleRequest).build());
    }

    /**
     * Create a {@link Route53ResolverClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Route53ResolverClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Route53ResolverClient}.
     */
    static Route53ResolverClientBuilder builder() {
        return new DefaultRoute53ResolverClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default Route53ResolverServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
