/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Validation {
    ENABLE("ENABLE"),
    DISABLE("DISABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Validation> VALUE_MAP;
    private final String value;

    private Validation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Validation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Validation> knownValues() {
        EnumSet<Validation> knownValues = EnumSet.allOf(Validation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Validation.class, Validation::toString);
    }
}

