/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecoveryGroupReadinessSummaryResponse extends Route53RecoveryReadinessResponse implements
        ToCopyableBuilder<GetRecoveryGroupReadinessSummaryResponse.Builder, GetRecoveryGroupReadinessSummaryResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetRecoveryGroupReadinessSummaryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> READINESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Readiness").getter(getter(GetRecoveryGroupReadinessSummaryResponse::readinessAsString))
            .setter(setter(Builder::readiness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readiness").build()).build();

    private static final SdkField<List<ReadinessCheckSummary>> READINESS_CHECKS_FIELD = SdkField
            .<List<ReadinessCheckSummary>> builder(MarshallingType.LIST)
            .memberName("ReadinessChecks")
            .getter(getter(GetRecoveryGroupReadinessSummaryResponse::readinessChecks))
            .setter(setter(Builder::readinessChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readinessChecks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReadinessCheckSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReadinessCheckSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            READINESS_FIELD, READINESS_CHECKS_FIELD));

    private final String nextToken;

    private final String readiness;

    private final List<ReadinessCheckSummary> readinessChecks;

    private GetRecoveryGroupReadinessSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.readiness = builder.readiness;
        this.readinessChecks = builder.readinessChecks;
    }

    /**
     * <p>
     * The token that identifies which batch of results you want to see.
     * </p>
     * 
     * @return The token that identifies which batch of results you want to see.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The readiness status at a recovery group level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #readiness} will
     * return {@link Readiness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #readinessAsString}.
     * </p>
     * 
     * @return The readiness status at a recovery group level.
     * @see Readiness
     */
    public final Readiness readiness() {
        return Readiness.fromValue(readiness);
    }

    /**
     * <p>
     * The readiness status at a recovery group level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #readiness} will
     * return {@link Readiness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #readinessAsString}.
     * </p>
     * 
     * @return The readiness status at a recovery group level.
     * @see Readiness
     */
    public final String readinessAsString() {
        return readiness;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReadinessChecks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReadinessChecks() {
        return readinessChecks != null && !(readinessChecks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summaries of the readiness checks for the recovery group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReadinessChecks} method.
     * </p>
     * 
     * @return Summaries of the readiness checks for the recovery group.
     */
    public final List<ReadinessCheckSummary> readinessChecks() {
        return readinessChecks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(readinessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasReadinessChecks() ? readinessChecks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecoveryGroupReadinessSummaryResponse)) {
            return false;
        }
        GetRecoveryGroupReadinessSummaryResponse other = (GetRecoveryGroupReadinessSummaryResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(readinessAsString(), other.readinessAsString())
                && hasReadinessChecks() == other.hasReadinessChecks()
                && Objects.equals(readinessChecks(), other.readinessChecks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecoveryGroupReadinessSummaryResponse").add("NextToken", nextToken())
                .add("Readiness", readinessAsString()).add("ReadinessChecks", hasReadinessChecks() ? readinessChecks() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Readiness":
            return Optional.ofNullable(clazz.cast(readinessAsString()));
        case "ReadinessChecks":
            return Optional.ofNullable(clazz.cast(readinessChecks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecoveryGroupReadinessSummaryResponse, T> g) {
        return obj -> g.apply((GetRecoveryGroupReadinessSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryReadinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecoveryGroupReadinessSummaryResponse> {
        /**
         * <p>
         * The token that identifies which batch of results you want to see.
         * </p>
         * 
         * @param nextToken
         *        The token that identifies which batch of results you want to see.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The readiness status at a recovery group level.
         * </p>
         * 
         * @param readiness
         *        The readiness status at a recovery group level.
         * @see Readiness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Readiness
         */
        Builder readiness(String readiness);

        /**
         * <p>
         * The readiness status at a recovery group level.
         * </p>
         * 
         * @param readiness
         *        The readiness status at a recovery group level.
         * @see Readiness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Readiness
         */
        Builder readiness(Readiness readiness);

        /**
         * <p>
         * Summaries of the readiness checks for the recovery group.
         * </p>
         * 
         * @param readinessChecks
         *        Summaries of the readiness checks for the recovery group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readinessChecks(Collection<ReadinessCheckSummary> readinessChecks);

        /**
         * <p>
         * Summaries of the readiness checks for the recovery group.
         * </p>
         * 
         * @param readinessChecks
         *        Summaries of the readiness checks for the recovery group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readinessChecks(ReadinessCheckSummary... readinessChecks);

        /**
         * <p>
         * Summaries of the readiness checks for the recovery group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53recoveryreadiness.model.ReadinessCheckSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.route53recoveryreadiness.model.ReadinessCheckSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53recoveryreadiness.model.ReadinessCheckSummary.Builder#build()}
         * is called immediately and its result is passed to {@link #readinessChecks(List<ReadinessCheckSummary>)}.
         * 
         * @param readinessChecks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53recoveryreadiness.model.ReadinessCheckSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readinessChecks(java.util.Collection<ReadinessCheckSummary>)
         */
        Builder readinessChecks(Consumer<ReadinessCheckSummary.Builder>... readinessChecks);
    }

    static final class BuilderImpl extends Route53RecoveryReadinessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private String readiness;

        private List<ReadinessCheckSummary> readinessChecks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecoveryGroupReadinessSummaryResponse model) {
            super(model);
            nextToken(model.nextToken);
            readiness(model.readiness);
            readinessChecks(model.readinessChecks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getReadiness() {
            return readiness;
        }

        public final void setReadiness(String readiness) {
            this.readiness = readiness;
        }

        @Override
        public final Builder readiness(String readiness) {
            this.readiness = readiness;
            return this;
        }

        @Override
        public final Builder readiness(Readiness readiness) {
            this.readiness(readiness == null ? null : readiness.toString());
            return this;
        }

        public final List<ReadinessCheckSummary.Builder> getReadinessChecks() {
            List<ReadinessCheckSummary.Builder> result = ___listOfReadinessCheckSummaryCopier.copyToBuilder(this.readinessChecks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReadinessChecks(Collection<ReadinessCheckSummary.BuilderImpl> readinessChecks) {
            this.readinessChecks = ___listOfReadinessCheckSummaryCopier.copyFromBuilder(readinessChecks);
        }

        @Override
        public final Builder readinessChecks(Collection<ReadinessCheckSummary> readinessChecks) {
            this.readinessChecks = ___listOfReadinessCheckSummaryCopier.copy(readinessChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readinessChecks(ReadinessCheckSummary... readinessChecks) {
            readinessChecks(Arrays.asList(readinessChecks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readinessChecks(Consumer<ReadinessCheckSummary.Builder>... readinessChecks) {
            readinessChecks(Stream.of(readinessChecks).map(c -> ReadinessCheckSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRecoveryGroupReadinessSummaryResponse build() {
            return new GetRecoveryGroupReadinessSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
