/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateCellRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateCellResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateCrossAccountAuthorizationRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateCrossAccountAuthorizationResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateReadinessCheckRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateReadinessCheckResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateRecoveryGroupRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateRecoveryGroupResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateResourceSetRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateResourceSetResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteCellRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteCellResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteCrossAccountAuthorizationRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteCrossAccountAuthorizationResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteReadinessCheckRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteReadinessCheckResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteRecoveryGroupRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteRecoveryGroupResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteResourceSetRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteResourceSetResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetArchitectureRecommendationsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetArchitectureRecommendationsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetResourceSetRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetResourceSetResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListRulesRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListRulesResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListTagsForResourcesRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListTagsForResourcesResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.TagResourceRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.TagResourceResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UntagResourceRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UntagResourceResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateCellRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateCellResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateReadinessCheckRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateReadinessCheckResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateRecoveryGroupRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateRecoveryGroupResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateResourceSetRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateResourceSetResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetCellReadinessSummaryPublisher;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetReadinessCheckResourceStatusPublisher;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetReadinessCheckStatusPublisher;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetRecoveryGroupReadinessSummaryPublisher;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListCellsPublisher;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListCrossAccountAuthorizationsPublisher;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListReadinessChecksPublisher;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListRecoveryGroupsPublisher;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListResourceSetsPublisher;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListRulesPublisher;

/**
 * Service client for accessing AWS Route53 Recovery Readiness asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Recovery readiness
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Route53RecoveryReadinessAsyncClient extends AwsClient {
    String SERVICE_NAME = "route53-recovery-readiness";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "route53-recovery-readiness";

    /**
     * <p>
     * Creates a cell in an account.
     * </p>
     *
     * @param createCellRequest
     * @return A Java Future containing the result of the CreateCell operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>ConflictException 409 response - Conflict exception. You might be using a predefined variable.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.CreateCell
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateCell"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCellResponse> createCell(CreateCellRequest createCellRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a cell in an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCellRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCellRequest#builder()}
     * </p>
     *
     * @param createCellRequest
     *        A {@link Consumer} that will call methods on {@link CreateCellRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCell operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>ConflictException 409 response - Conflict exception. You might be using a predefined variable.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.CreateCell
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateCell"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCellResponse> createCell(Consumer<CreateCellRequest.Builder> createCellRequest) {
        return createCell(CreateCellRequest.builder().applyMutation(createCellRequest).build());
    }

    /**
     * <p>
     * Creates a cross-account readiness authorization. This lets you authorize another account to work with Route 53
     * Application Recovery Controller, for example, to check the readiness status of resources in a separate account.
     * </p>
     *
     * @param createCrossAccountAuthorizationRequest
     * @return A Java Future containing the result of the CreateCrossAccountAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>ConflictException 409 response - Conflict exception. You might be using a predefined variable.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.CreateCrossAccountAuthorization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateCrossAccountAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCrossAccountAuthorizationResponse> createCrossAccountAuthorization(
            CreateCrossAccountAuthorizationRequest createCrossAccountAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a cross-account readiness authorization. This lets you authorize another account to work with Route 53
     * Application Recovery Controller, for example, to check the readiness status of resources in a separate account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCrossAccountAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCrossAccountAuthorizationRequest#builder()}
     * </p>
     *
     * @param createCrossAccountAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link CreateCrossAccountAuthorizationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateCrossAccountAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>ConflictException 409 response - Conflict exception. You might be using a predefined variable.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.CreateCrossAccountAuthorization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateCrossAccountAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCrossAccountAuthorizationResponse> createCrossAccountAuthorization(
            Consumer<CreateCrossAccountAuthorizationRequest.Builder> createCrossAccountAuthorizationRequest) {
        return createCrossAccountAuthorization(CreateCrossAccountAuthorizationRequest.builder()
                .applyMutation(createCrossAccountAuthorizationRequest).build());
    }

    /**
     * <p>
     * Creates a readiness check in an account. A readiness check monitors a resource set in your application, such as a
     * set of Amazon Aurora instances, that Application Recovery Controller is auditing recovery readiness for. The
     * audits run once every minute on every resource that's associated with a readiness check.
     * </p>
     *
     * @param createReadinessCheckRequest
     * @return A Java Future containing the result of the CreateReadinessCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>ConflictException 409 response - Conflict exception. You might be using a predefined variable.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.CreateReadinessCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateReadinessCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReadinessCheckResponse> createReadinessCheck(
            CreateReadinessCheckRequest createReadinessCheckRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a readiness check in an account. A readiness check monitors a resource set in your application, such as a
     * set of Amazon Aurora instances, that Application Recovery Controller is auditing recovery readiness for. The
     * audits run once every minute on every resource that's associated with a readiness check.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReadinessCheckRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReadinessCheckRequest#builder()}
     * </p>
     *
     * @param createReadinessCheckRequest
     *        A {@link Consumer} that will call methods on {@link CreateReadinessCheckRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateReadinessCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>ConflictException 409 response - Conflict exception. You might be using a predefined variable.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.CreateReadinessCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateReadinessCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReadinessCheckResponse> createReadinessCheck(
            Consumer<CreateReadinessCheckRequest.Builder> createReadinessCheckRequest) {
        return createReadinessCheck(CreateReadinessCheckRequest.builder().applyMutation(createReadinessCheckRequest).build());
    }

    /**
     * <p>
     * Creates a recovery group in an account. A recovery group corresponds to an application and includes a list of the
     * cells that make up the application.
     * </p>
     *
     * @param createRecoveryGroupRequest
     * @return A Java Future containing the result of the CreateRecoveryGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>ConflictException 409 response - Conflict exception. You might be using a predefined variable.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.CreateRecoveryGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateRecoveryGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRecoveryGroupResponse> createRecoveryGroup(
            CreateRecoveryGroupRequest createRecoveryGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a recovery group in an account. A recovery group corresponds to an application and includes a list of the
     * cells that make up the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRecoveryGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRecoveryGroupRequest#builder()}
     * </p>
     *
     * @param createRecoveryGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateRecoveryGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRecoveryGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>ConflictException 409 response - Conflict exception. You might be using a predefined variable.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.CreateRecoveryGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateRecoveryGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRecoveryGroupResponse> createRecoveryGroup(
            Consumer<CreateRecoveryGroupRequest.Builder> createRecoveryGroupRequest) {
        return createRecoveryGroup(CreateRecoveryGroupRequest.builder().applyMutation(createRecoveryGroupRequest).build());
    }

    /**
     * <p>
     * Creates a resource set. A resource set is a set of resources of one type that span multiple cells. You can
     * associate a resource set with a readiness check to monitor the resources for failover readiness.
     * </p>
     *
     * @param createResourceSetRequest
     * @return A Java Future containing the result of the CreateResourceSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>ConflictException 409 response - Conflict exception. You might be using a predefined variable.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.CreateResourceSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateResourceSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceSetResponse> createResourceSet(CreateResourceSetRequest createResourceSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource set. A resource set is a set of resources of one type that span multiple cells. You can
     * associate a resource set with a readiness check to monitor the resources for failover readiness.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceSetRequest.Builder} avoiding the need
     * to create one manually via {@link CreateResourceSetRequest#builder()}
     * </p>
     *
     * @param createResourceSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateResourceSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>ConflictException 409 response - Conflict exception. You might be using a predefined variable.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.CreateResourceSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/CreateResourceSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceSetResponse> createResourceSet(
            Consumer<CreateResourceSetRequest.Builder> createResourceSetRequest) {
        return createResourceSet(CreateResourceSetRequest.builder().applyMutation(createResourceSetRequest).build());
    }

    /**
     * <p>
     * Delete a cell. When successful, the response code is 204, with no response body.
     * </p>
     *
     * @param deleteCellRequest
     * @return A Java Future containing the result of the DeleteCell operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.DeleteCell
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteCell"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCellResponse> deleteCell(DeleteCellRequest deleteCellRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a cell. When successful, the response code is 204, with no response body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCellRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCellRequest#builder()}
     * </p>
     *
     * @param deleteCellRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCellRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCell operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.DeleteCell
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteCell"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCellResponse> deleteCell(Consumer<DeleteCellRequest.Builder> deleteCellRequest) {
        return deleteCell(DeleteCellRequest.builder().applyMutation(deleteCellRequest).build());
    }

    /**
     * <p>
     * Deletes cross account readiness authorization.
     * </p>
     *
     * @param deleteCrossAccountAuthorizationRequest
     * @return A Java Future containing the result of the DeleteCrossAccountAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.DeleteCrossAccountAuthorization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteCrossAccountAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCrossAccountAuthorizationResponse> deleteCrossAccountAuthorization(
            DeleteCrossAccountAuthorizationRequest deleteCrossAccountAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes cross account readiness authorization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCrossAccountAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCrossAccountAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteCrossAccountAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCrossAccountAuthorizationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteCrossAccountAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.DeleteCrossAccountAuthorization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteCrossAccountAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCrossAccountAuthorizationResponse> deleteCrossAccountAuthorization(
            Consumer<DeleteCrossAccountAuthorizationRequest.Builder> deleteCrossAccountAuthorizationRequest) {
        return deleteCrossAccountAuthorization(DeleteCrossAccountAuthorizationRequest.builder()
                .applyMutation(deleteCrossAccountAuthorizationRequest).build());
    }

    /**
     * <p>
     * Deletes a readiness check.
     * </p>
     *
     * @param deleteReadinessCheckRequest
     * @return A Java Future containing the result of the DeleteReadinessCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.DeleteReadinessCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteReadinessCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReadinessCheckResponse> deleteReadinessCheck(
            DeleteReadinessCheckRequest deleteReadinessCheckRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a readiness check.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReadinessCheckRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReadinessCheckRequest#builder()}
     * </p>
     *
     * @param deleteReadinessCheckRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReadinessCheckRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteReadinessCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.DeleteReadinessCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteReadinessCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReadinessCheckResponse> deleteReadinessCheck(
            Consumer<DeleteReadinessCheckRequest.Builder> deleteReadinessCheckRequest) {
        return deleteReadinessCheck(DeleteReadinessCheckRequest.builder().applyMutation(deleteReadinessCheckRequest).build());
    }

    /**
     * <p>
     * Deletes a recovery group.
     * </p>
     *
     * @param deleteRecoveryGroupRequest
     * @return A Java Future containing the result of the DeleteRecoveryGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.DeleteRecoveryGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteRecoveryGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRecoveryGroupResponse> deleteRecoveryGroup(
            DeleteRecoveryGroupRequest deleteRecoveryGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a recovery group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecoveryGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRecoveryGroupRequest#builder()}
     * </p>
     *
     * @param deleteRecoveryGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRecoveryGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRecoveryGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.DeleteRecoveryGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteRecoveryGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRecoveryGroupResponse> deleteRecoveryGroup(
            Consumer<DeleteRecoveryGroupRequest.Builder> deleteRecoveryGroupRequest) {
        return deleteRecoveryGroup(DeleteRecoveryGroupRequest.builder().applyMutation(deleteRecoveryGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a resource set.
     * </p>
     *
     * @param deleteResourceSetRequest
     * @return A Java Future containing the result of the DeleteResourceSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.DeleteResourceSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteResourceSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceSetResponse> deleteResourceSet(DeleteResourceSetRequest deleteResourceSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceSetRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteResourceSetRequest#builder()}
     * </p>
     *
     * @param deleteResourceSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteResourceSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.DeleteResourceSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/DeleteResourceSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceSetResponse> deleteResourceSet(
            Consumer<DeleteResourceSetRequest.Builder> deleteResourceSetRequest) {
        return deleteResourceSet(DeleteResourceSetRequest.builder().applyMutation(deleteResourceSetRequest).build());
    }

    /**
     * <p>
     * Gets recommendations about architecture designs for improving resiliency for an application, based on a recovery
     * group.
     * </p>
     *
     * @param getArchitectureRecommendationsRequest
     * @return A Java Future containing the result of the GetArchitectureRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetArchitectureRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetArchitectureRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetArchitectureRecommendationsResponse> getArchitectureRecommendations(
            GetArchitectureRecommendationsRequest getArchitectureRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets recommendations about architecture designs for improving resiliency for an application, based on a recovery
     * group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetArchitectureRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetArchitectureRecommendationsRequest#builder()}
     * </p>
     *
     * @param getArchitectureRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link GetArchitectureRecommendationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetArchitectureRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetArchitectureRecommendations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetArchitectureRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetArchitectureRecommendationsResponse> getArchitectureRecommendations(
            Consumer<GetArchitectureRecommendationsRequest.Builder> getArchitectureRecommendationsRequest) {
        return getArchitectureRecommendations(GetArchitectureRecommendationsRequest.builder()
                .applyMutation(getArchitectureRecommendationsRequest).build());
    }

    /**
     * <p>
     * Gets information about a cell including cell name, cell Amazon Resource Name (ARN), ARNs of nested cells for this
     * cell, and a list of those cell ARNs with their associated recovery group ARNs.
     * </p>
     *
     * @param getCellRequest
     * @return A Java Future containing the result of the GetCell operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetCell
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetCell"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCellResponse> getCell(GetCellRequest getCellRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a cell including cell name, cell Amazon Resource Name (ARN), ARNs of nested cells for this
     * cell, and a list of those cell ARNs with their associated recovery group ARNs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCellRequest.Builder} avoiding the need to create
     * one manually via {@link GetCellRequest#builder()}
     * </p>
     *
     * @param getCellRequest
     *        A {@link Consumer} that will call methods on {@link GetCellRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCell operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetCell
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetCell"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCellResponse> getCell(Consumer<GetCellRequest.Builder> getCellRequest) {
        return getCell(GetCellRequest.builder().applyMutation(getCellRequest).build());
    }

    /**
     * <p>
     * Gets readiness for a cell. Aggregates the readiness of all the resources that are associated with the cell into a
     * single value.
     * </p>
     *
     * @param getCellReadinessSummaryRequest
     * @return A Java Future containing the result of the GetCellReadinessSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetCellReadinessSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetCellReadinessSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCellReadinessSummaryResponse> getCellReadinessSummary(
            GetCellReadinessSummaryRequest getCellReadinessSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets readiness for a cell. Aggregates the readiness of all the resources that are associated with the cell into a
     * single value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCellReadinessSummaryRequest.Builder} avoiding
     * the need to create one manually via {@link GetCellReadinessSummaryRequest#builder()}
     * </p>
     *
     * @param getCellReadinessSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetCellReadinessSummaryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCellReadinessSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetCellReadinessSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetCellReadinessSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCellReadinessSummaryResponse> getCellReadinessSummary(
            Consumer<GetCellReadinessSummaryRequest.Builder> getCellReadinessSummaryRequest) {
        return getCellReadinessSummary(GetCellReadinessSummaryRequest.builder().applyMutation(getCellReadinessSummaryRequest)
                .build());
    }

    /**
     * <p>
     * Gets readiness for a cell. Aggregates the readiness of all the resources that are associated with the cell into a
     * single value.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCellReadinessSummary(software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetCellReadinessSummaryPublisher publisher = client.getCellReadinessSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetCellReadinessSummaryPublisher publisher = client.getCellReadinessSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCellReadinessSummary(software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCellReadinessSummaryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetCellReadinessSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetCellReadinessSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCellReadinessSummaryPublisher getCellReadinessSummaryPaginator(
            GetCellReadinessSummaryRequest getCellReadinessSummaryRequest) {
        return new GetCellReadinessSummaryPublisher(this, getCellReadinessSummaryRequest);
    }

    /**
     * <p>
     * Gets readiness for a cell. Aggregates the readiness of all the resources that are associated with the cell into a
     * single value.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCellReadinessSummary(software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetCellReadinessSummaryPublisher publisher = client.getCellReadinessSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetCellReadinessSummaryPublisher publisher = client.getCellReadinessSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCellReadinessSummary(software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCellReadinessSummaryRequest.Builder} avoiding
     * the need to create one manually via {@link GetCellReadinessSummaryRequest#builder()}
     * </p>
     *
     * @param getCellReadinessSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetCellReadinessSummaryRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetCellReadinessSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetCellReadinessSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCellReadinessSummaryPublisher getCellReadinessSummaryPaginator(
            Consumer<GetCellReadinessSummaryRequest.Builder> getCellReadinessSummaryRequest) {
        return getCellReadinessSummaryPaginator(GetCellReadinessSummaryRequest.builder()
                .applyMutation(getCellReadinessSummaryRequest).build());
    }

    /**
     * <p>
     * Gets details about a readiness check.
     * </p>
     *
     * @param getReadinessCheckRequest
     * @return A Java Future containing the result of the GetReadinessCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetReadinessCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReadinessCheckResponse> getReadinessCheck(GetReadinessCheckRequest getReadinessCheckRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a readiness check.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadinessCheckRequest.Builder} avoiding the need
     * to create one manually via {@link GetReadinessCheckRequest#builder()}
     * </p>
     *
     * @param getReadinessCheckRequest
     *        A {@link Consumer} that will call methods on {@link GetReadinessCheckRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetReadinessCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetReadinessCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReadinessCheckResponse> getReadinessCheck(
            Consumer<GetReadinessCheckRequest.Builder> getReadinessCheckRequest) {
        return getReadinessCheck(GetReadinessCheckRequest.builder().applyMutation(getReadinessCheckRequest).build());
    }

    /**
     * <p>
     * Gets individual readiness status for a readiness check. To see the overall readiness status for a recovery group,
     * that considers the readiness status for all the readiness checks in the recovery group, use
     * GetRecoveryGroupReadinessSummary.
     * </p>
     *
     * @param getReadinessCheckResourceStatusRequest
     * @return A Java Future containing the result of the GetReadinessCheckResourceStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetReadinessCheckResourceStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheckResourceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReadinessCheckResourceStatusResponse> getReadinessCheckResourceStatus(
            GetReadinessCheckResourceStatusRequest getReadinessCheckResourceStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets individual readiness status for a readiness check. To see the overall readiness status for a recovery group,
     * that considers the readiness status for all the readiness checks in the recovery group, use
     * GetRecoveryGroupReadinessSummary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadinessCheckResourceStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetReadinessCheckResourceStatusRequest#builder()}
     * </p>
     *
     * @param getReadinessCheckResourceStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetReadinessCheckResourceStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetReadinessCheckResourceStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetReadinessCheckResourceStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheckResourceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReadinessCheckResourceStatusResponse> getReadinessCheckResourceStatus(
            Consumer<GetReadinessCheckResourceStatusRequest.Builder> getReadinessCheckResourceStatusRequest) {
        return getReadinessCheckResourceStatus(GetReadinessCheckResourceStatusRequest.builder()
                .applyMutation(getReadinessCheckResourceStatusRequest).build());
    }

    /**
     * <p>
     * Gets individual readiness status for a readiness check. To see the overall readiness status for a recovery group,
     * that considers the readiness status for all the readiness checks in the recovery group, use
     * GetRecoveryGroupReadinessSummary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReadinessCheckResourceStatus(software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetReadinessCheckResourceStatusPublisher publisher = client.getReadinessCheckResourceStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetReadinessCheckResourceStatusPublisher publisher = client.getReadinessCheckResourceStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReadinessCheckResourceStatus(software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getReadinessCheckResourceStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetReadinessCheckResourceStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheckResourceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReadinessCheckResourceStatusPublisher getReadinessCheckResourceStatusPaginator(
            GetReadinessCheckResourceStatusRequest getReadinessCheckResourceStatusRequest) {
        return new GetReadinessCheckResourceStatusPublisher(this, getReadinessCheckResourceStatusRequest);
    }

    /**
     * <p>
     * Gets individual readiness status for a readiness check. To see the overall readiness status for a recovery group,
     * that considers the readiness status for all the readiness checks in the recovery group, use
     * GetRecoveryGroupReadinessSummary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReadinessCheckResourceStatus(software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetReadinessCheckResourceStatusPublisher publisher = client.getReadinessCheckResourceStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetReadinessCheckResourceStatusPublisher publisher = client.getReadinessCheckResourceStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReadinessCheckResourceStatus(software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadinessCheckResourceStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetReadinessCheckResourceStatusRequest#builder()}
     * </p>
     *
     * @param getReadinessCheckResourceStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetReadinessCheckResourceStatusRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetReadinessCheckResourceStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheckResourceStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReadinessCheckResourceStatusPublisher getReadinessCheckResourceStatusPaginator(
            Consumer<GetReadinessCheckResourceStatusRequest.Builder> getReadinessCheckResourceStatusRequest) {
        return getReadinessCheckResourceStatusPaginator(GetReadinessCheckResourceStatusRequest.builder()
                .applyMutation(getReadinessCheckResourceStatusRequest).build());
    }

    /**
     * <p>
     * Gets the readiness status for an individual readiness check. To see the overall readiness status for a recovery
     * group, that considers the readiness status for all the readiness checks in a recovery group, use
     * GetRecoveryGroupReadinessSummary.
     * </p>
     *
     * @param getReadinessCheckStatusRequest
     * @return A Java Future containing the result of the GetReadinessCheckStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetReadinessCheckStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheckStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReadinessCheckStatusResponse> getReadinessCheckStatus(
            GetReadinessCheckStatusRequest getReadinessCheckStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the readiness status for an individual readiness check. To see the overall readiness status for a recovery
     * group, that considers the readiness status for all the readiness checks in a recovery group, use
     * GetRecoveryGroupReadinessSummary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadinessCheckStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetReadinessCheckStatusRequest#builder()}
     * </p>
     *
     * @param getReadinessCheckStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetReadinessCheckStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReadinessCheckStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetReadinessCheckStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheckStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReadinessCheckStatusResponse> getReadinessCheckStatus(
            Consumer<GetReadinessCheckStatusRequest.Builder> getReadinessCheckStatusRequest) {
        return getReadinessCheckStatus(GetReadinessCheckStatusRequest.builder().applyMutation(getReadinessCheckStatusRequest)
                .build());
    }

    /**
     * <p>
     * Gets the readiness status for an individual readiness check. To see the overall readiness status for a recovery
     * group, that considers the readiness status for all the readiness checks in a recovery group, use
     * GetRecoveryGroupReadinessSummary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReadinessCheckStatus(software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetReadinessCheckStatusPublisher publisher = client.getReadinessCheckStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetReadinessCheckStatusPublisher publisher = client.getReadinessCheckStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReadinessCheckStatus(software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getReadinessCheckStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetReadinessCheckStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheckStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReadinessCheckStatusPublisher getReadinessCheckStatusPaginator(
            GetReadinessCheckStatusRequest getReadinessCheckStatusRequest) {
        return new GetReadinessCheckStatusPublisher(this, getReadinessCheckStatusRequest);
    }

    /**
     * <p>
     * Gets the readiness status for an individual readiness check. To see the overall readiness status for a recovery
     * group, that considers the readiness status for all the readiness checks in a recovery group, use
     * GetRecoveryGroupReadinessSummary.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReadinessCheckStatus(software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetReadinessCheckStatusPublisher publisher = client.getReadinessCheckStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetReadinessCheckStatusPublisher publisher = client.getReadinessCheckStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReadinessCheckStatus(software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadinessCheckStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetReadinessCheckStatusRequest#builder()}
     * </p>
     *
     * @param getReadinessCheckStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetReadinessCheckStatusRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetReadinessCheckStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetReadinessCheckStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReadinessCheckStatusPublisher getReadinessCheckStatusPaginator(
            Consumer<GetReadinessCheckStatusRequest.Builder> getReadinessCheckStatusRequest) {
        return getReadinessCheckStatusPaginator(GetReadinessCheckStatusRequest.builder()
                .applyMutation(getReadinessCheckStatusRequest).build());
    }

    /**
     * <p>
     * Gets details about a recovery group, including a list of the cells that are included in it.
     * </p>
     *
     * @param getRecoveryGroupRequest
     * @return A Java Future containing the result of the GetRecoveryGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetRecoveryGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetRecoveryGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecoveryGroupResponse> getRecoveryGroup(GetRecoveryGroupRequest getRecoveryGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a recovery group, including a list of the cells that are included in it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecoveryGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetRecoveryGroupRequest#builder()}
     * </p>
     *
     * @param getRecoveryGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetRecoveryGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRecoveryGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetRecoveryGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetRecoveryGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecoveryGroupResponse> getRecoveryGroup(
            Consumer<GetRecoveryGroupRequest.Builder> getRecoveryGroupRequest) {
        return getRecoveryGroup(GetRecoveryGroupRequest.builder().applyMutation(getRecoveryGroupRequest).build());
    }

    /**
     * <p>
     * Displays a summary of information about a recovery group's readiness status. Includes the readiness checks for
     * resources in the recovery group and the readiness status of each one.
     * </p>
     *
     * @param getRecoveryGroupReadinessSummaryRequest
     * @return A Java Future containing the result of the GetRecoveryGroupReadinessSummary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetRecoveryGroupReadinessSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetRecoveryGroupReadinessSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecoveryGroupReadinessSummaryResponse> getRecoveryGroupReadinessSummary(
            GetRecoveryGroupReadinessSummaryRequest getRecoveryGroupReadinessSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a summary of information about a recovery group's readiness status. Includes the readiness checks for
     * resources in the recovery group and the readiness status of each one.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecoveryGroupReadinessSummaryRequest.Builder}
     * avoiding the need to create one manually via {@link GetRecoveryGroupReadinessSummaryRequest#builder()}
     * </p>
     *
     * @param getRecoveryGroupReadinessSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetRecoveryGroupReadinessSummaryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRecoveryGroupReadinessSummary operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetRecoveryGroupReadinessSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetRecoveryGroupReadinessSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecoveryGroupReadinessSummaryResponse> getRecoveryGroupReadinessSummary(
            Consumer<GetRecoveryGroupReadinessSummaryRequest.Builder> getRecoveryGroupReadinessSummaryRequest) {
        return getRecoveryGroupReadinessSummary(GetRecoveryGroupReadinessSummaryRequest.builder()
                .applyMutation(getRecoveryGroupReadinessSummaryRequest).build());
    }

    /**
     * <p>
     * Displays a summary of information about a recovery group's readiness status. Includes the readiness checks for
     * resources in the recovery group and the readiness status of each one.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getRecoveryGroupReadinessSummary(software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetRecoveryGroupReadinessSummaryPublisher publisher = client.getRecoveryGroupReadinessSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetRecoveryGroupReadinessSummaryPublisher publisher = client.getRecoveryGroupReadinessSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRecoveryGroupReadinessSummary(software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getRecoveryGroupReadinessSummaryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetRecoveryGroupReadinessSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetRecoveryGroupReadinessSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecoveryGroupReadinessSummaryPublisher getRecoveryGroupReadinessSummaryPaginator(
            GetRecoveryGroupReadinessSummaryRequest getRecoveryGroupReadinessSummaryRequest) {
        return new GetRecoveryGroupReadinessSummaryPublisher(this, getRecoveryGroupReadinessSummaryRequest);
    }

    /**
     * <p>
     * Displays a summary of information about a recovery group's readiness status. Includes the readiness checks for
     * resources in the recovery group and the readiness status of each one.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getRecoveryGroupReadinessSummary(software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetRecoveryGroupReadinessSummaryPublisher publisher = client.getRecoveryGroupReadinessSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetRecoveryGroupReadinessSummaryPublisher publisher = client.getRecoveryGroupReadinessSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRecoveryGroupReadinessSummary(software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecoveryGroupReadinessSummaryRequest.Builder}
     * avoiding the need to create one manually via {@link GetRecoveryGroupReadinessSummaryRequest#builder()}
     * </p>
     *
     * @param getRecoveryGroupReadinessSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetRecoveryGroupReadinessSummaryRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetRecoveryGroupReadinessSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetRecoveryGroupReadinessSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecoveryGroupReadinessSummaryPublisher getRecoveryGroupReadinessSummaryPaginator(
            Consumer<GetRecoveryGroupReadinessSummaryRequest.Builder> getRecoveryGroupReadinessSummaryRequest) {
        return getRecoveryGroupReadinessSummaryPaginator(GetRecoveryGroupReadinessSummaryRequest.builder()
                .applyMutation(getRecoveryGroupReadinessSummaryRequest).build());
    }

    /**
     * <p>
     * Displays the details about a resource set, including a list of the resources in the set.
     * </p>
     *
     * @param getResourceSetRequest
     * @return A Java Future containing the result of the GetResourceSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetResourceSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetResourceSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceSetResponse> getResourceSet(GetResourceSetRequest getResourceSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the details about a resource set, including a list of the resources in the set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetResourceSetRequest#builder()}
     * </p>
     *
     * @param getResourceSetRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResourceSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.GetResourceSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/GetResourceSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceSetResponse> getResourceSet(Consumer<GetResourceSetRequest.Builder> getResourceSetRequest) {
        return getResourceSet(GetResourceSetRequest.builder().applyMutation(getResourceSetRequest).build());
    }

    /**
     * <p>
     * Lists the cells for an account.
     * </p>
     *
     * @param listCellsRequest
     * @return A Java Future containing the result of the ListCells operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListCells
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListCells"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCellsResponse> listCells(ListCellsRequest listCellsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the cells for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCellsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCellsRequest#builder()}
     * </p>
     *
     * @param listCellsRequest
     *        A {@link Consumer} that will call methods on {@link ListCellsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCells operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListCells
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListCells"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCellsResponse> listCells(Consumer<ListCellsRequest.Builder> listCellsRequest) {
        return listCells(ListCellsRequest.builder().applyMutation(listCellsRequest).build());
    }

    /**
     * <p>
     * Lists the cells for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCells(software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListCellsPublisher publisher = client.listCellsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListCellsPublisher publisher = client.listCellsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCells(software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCellsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListCells
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListCells"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCellsPublisher listCellsPaginator(ListCellsRequest listCellsRequest) {
        return new ListCellsPublisher(this, listCellsRequest);
    }

    /**
     * <p>
     * Lists the cells for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCells(software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListCellsPublisher publisher = client.listCellsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListCellsPublisher publisher = client.listCellsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCells(software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCellsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCellsRequest#builder()}
     * </p>
     *
     * @param listCellsRequest
     *        A {@link Consumer} that will call methods on {@link ListCellsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListCells
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListCells"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCellsPublisher listCellsPaginator(Consumer<ListCellsRequest.Builder> listCellsRequest) {
        return listCellsPaginator(ListCellsRequest.builder().applyMutation(listCellsRequest).build());
    }

    /**
     * <p>
     * Lists the cross-account readiness authorizations that are in place for an account.
     * </p>
     *
     * @param listCrossAccountAuthorizationsRequest
     * @return A Java Future containing the result of the ListCrossAccountAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListCrossAccountAuthorizations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListCrossAccountAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCrossAccountAuthorizationsResponse> listCrossAccountAuthorizations(
            ListCrossAccountAuthorizationsRequest listCrossAccountAuthorizationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the cross-account readiness authorizations that are in place for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCrossAccountAuthorizationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCrossAccountAuthorizationsRequest#builder()}
     * </p>
     *
     * @param listCrossAccountAuthorizationsRequest
     *        A {@link Consumer} that will call methods on {@link ListCrossAccountAuthorizationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListCrossAccountAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListCrossAccountAuthorizations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListCrossAccountAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCrossAccountAuthorizationsResponse> listCrossAccountAuthorizations(
            Consumer<ListCrossAccountAuthorizationsRequest.Builder> listCrossAccountAuthorizationsRequest) {
        return listCrossAccountAuthorizations(ListCrossAccountAuthorizationsRequest.builder()
                .applyMutation(listCrossAccountAuthorizationsRequest).build());
    }

    /**
     * <p>
     * Lists the cross-account readiness authorizations that are in place for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCrossAccountAuthorizations(software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListCrossAccountAuthorizationsPublisher publisher = client.listCrossAccountAuthorizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListCrossAccountAuthorizationsPublisher publisher = client.listCrossAccountAuthorizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCrossAccountAuthorizations(software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCrossAccountAuthorizationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListCrossAccountAuthorizations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListCrossAccountAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCrossAccountAuthorizationsPublisher listCrossAccountAuthorizationsPaginator(
            ListCrossAccountAuthorizationsRequest listCrossAccountAuthorizationsRequest) {
        return new ListCrossAccountAuthorizationsPublisher(this, listCrossAccountAuthorizationsRequest);
    }

    /**
     * <p>
     * Lists the cross-account readiness authorizations that are in place for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCrossAccountAuthorizations(software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListCrossAccountAuthorizationsPublisher publisher = client.listCrossAccountAuthorizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListCrossAccountAuthorizationsPublisher publisher = client.listCrossAccountAuthorizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCrossAccountAuthorizations(software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCrossAccountAuthorizationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCrossAccountAuthorizationsRequest#builder()}
     * </p>
     *
     * @param listCrossAccountAuthorizationsRequest
     *        A {@link Consumer} that will call methods on {@link ListCrossAccountAuthorizationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListCrossAccountAuthorizations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListCrossAccountAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCrossAccountAuthorizationsPublisher listCrossAccountAuthorizationsPaginator(
            Consumer<ListCrossAccountAuthorizationsRequest.Builder> listCrossAccountAuthorizationsRequest) {
        return listCrossAccountAuthorizationsPaginator(ListCrossAccountAuthorizationsRequest.builder()
                .applyMutation(listCrossAccountAuthorizationsRequest).build());
    }

    /**
     * <p>
     * Lists the readiness checks for an account.
     * </p>
     *
     * @param listReadinessChecksRequest
     * @return A Java Future containing the result of the ListReadinessChecks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListReadinessChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListReadinessChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReadinessChecksResponse> listReadinessChecks(
            ListReadinessChecksRequest listReadinessChecksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the readiness checks for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadinessChecksRequest.Builder} avoiding the
     * need to create one manually via {@link ListReadinessChecksRequest#builder()}
     * </p>
     *
     * @param listReadinessChecksRequest
     *        A {@link Consumer} that will call methods on {@link ListReadinessChecksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReadinessChecks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListReadinessChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListReadinessChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReadinessChecksResponse> listReadinessChecks(
            Consumer<ListReadinessChecksRequest.Builder> listReadinessChecksRequest) {
        return listReadinessChecks(ListReadinessChecksRequest.builder().applyMutation(listReadinessChecksRequest).build());
    }

    /**
     * <p>
     * Lists the readiness checks for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReadinessChecks(software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListReadinessChecksPublisher publisher = client.listReadinessChecksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListReadinessChecksPublisher publisher = client.listReadinessChecksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadinessChecks(software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReadinessChecksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListReadinessChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListReadinessChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReadinessChecksPublisher listReadinessChecksPaginator(ListReadinessChecksRequest listReadinessChecksRequest) {
        return new ListReadinessChecksPublisher(this, listReadinessChecksRequest);
    }

    /**
     * <p>
     * Lists the readiness checks for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReadinessChecks(software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListReadinessChecksPublisher publisher = client.listReadinessChecksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListReadinessChecksPublisher publisher = client.listReadinessChecksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadinessChecks(software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadinessChecksRequest.Builder} avoiding the
     * need to create one manually via {@link ListReadinessChecksRequest#builder()}
     * </p>
     *
     * @param listReadinessChecksRequest
     *        A {@link Consumer} that will call methods on {@link ListReadinessChecksRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListReadinessChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListReadinessChecks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReadinessChecksPublisher listReadinessChecksPaginator(
            Consumer<ListReadinessChecksRequest.Builder> listReadinessChecksRequest) {
        return listReadinessChecksPaginator(ListReadinessChecksRequest.builder().applyMutation(listReadinessChecksRequest)
                .build());
    }

    /**
     * <p>
     * Lists the recovery groups in an account.
     * </p>
     *
     * @param listRecoveryGroupsRequest
     * @return A Java Future containing the result of the ListRecoveryGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListRecoveryGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListRecoveryGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecoveryGroupsResponse> listRecoveryGroups(ListRecoveryGroupsRequest listRecoveryGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the recovery groups in an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecoveryGroupsRequest#builder()}
     * </p>
     *
     * @param listRecoveryGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListRecoveryGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRecoveryGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListRecoveryGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListRecoveryGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecoveryGroupsResponse> listRecoveryGroups(
            Consumer<ListRecoveryGroupsRequest.Builder> listRecoveryGroupsRequest) {
        return listRecoveryGroups(ListRecoveryGroupsRequest.builder().applyMutation(listRecoveryGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the recovery groups in an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryGroups(software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListRecoveryGroupsPublisher publisher = client.listRecoveryGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListRecoveryGroupsPublisher publisher = client.listRecoveryGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryGroups(software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecoveryGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListRecoveryGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListRecoveryGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryGroupsPublisher listRecoveryGroupsPaginator(ListRecoveryGroupsRequest listRecoveryGroupsRequest) {
        return new ListRecoveryGroupsPublisher(this, listRecoveryGroupsRequest);
    }

    /**
     * <p>
     * Lists the recovery groups in an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryGroups(software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListRecoveryGroupsPublisher publisher = client.listRecoveryGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListRecoveryGroupsPublisher publisher = client.listRecoveryGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryGroups(software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecoveryGroupsRequest#builder()}
     * </p>
     *
     * @param listRecoveryGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListRecoveryGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListRecoveryGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListRecoveryGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryGroupsPublisher listRecoveryGroupsPaginator(
            Consumer<ListRecoveryGroupsRequest.Builder> listRecoveryGroupsRequest) {
        return listRecoveryGroupsPaginator(ListRecoveryGroupsRequest.builder().applyMutation(listRecoveryGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the resource sets in an account.
     * </p>
     *
     * @param listResourceSetsRequest
     * @return A Java Future containing the result of the ListResourceSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListResourceSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListResourceSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceSetsResponse> listResourceSets(ListResourceSetsRequest listResourceSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource sets in an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceSetsRequest.Builder} avoiding the need
     * to create one manually via {@link ListResourceSetsRequest#builder()}
     * </p>
     *
     * @param listResourceSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceSetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListResourceSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListResourceSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListResourceSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceSetsResponse> listResourceSets(
            Consumer<ListResourceSetsRequest.Builder> listResourceSetsRequest) {
        return listResourceSets(ListResourceSetsRequest.builder().applyMutation(listResourceSetsRequest).build());
    }

    /**
     * <p>
     * Lists the resource sets in an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceSets(software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListResourceSetsPublisher publisher = client.listResourceSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListResourceSetsPublisher publisher = client.listResourceSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceSets(software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListResourceSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListResourceSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSetsPublisher listResourceSetsPaginator(ListResourceSetsRequest listResourceSetsRequest) {
        return new ListResourceSetsPublisher(this, listResourceSetsRequest);
    }

    /**
     * <p>
     * Lists the resource sets in an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceSets(software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListResourceSetsPublisher publisher = client.listResourceSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListResourceSetsPublisher publisher = client.listResourceSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceSets(software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceSetsRequest.Builder} avoiding the need
     * to create one manually via {@link ListResourceSetsRequest#builder()}
     * </p>
     *
     * @param listResourceSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceSetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListResourceSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListResourceSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSetsPublisher listResourceSetsPaginator(Consumer<ListResourceSetsRequest.Builder> listResourceSetsRequest) {
        return listResourceSetsPaginator(ListResourceSetsRequest.builder().applyMutation(listResourceSetsRequest).build());
    }

    /**
     * <p>
     * Lists all readiness rules, or lists the readiness rules for a specific resource type.
     * </p>
     *
     * @param listRulesRequest
     * @return A Java Future containing the result of the ListRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRulesResponse> listRules(ListRulesRequest listRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all readiness rules, or lists the readiness rules for a specific resource type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesRequest#builder()}
     * </p>
     *
     * @param listRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListRulesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRulesResponse> listRules(Consumer<ListRulesRequest.Builder> listRulesRequest) {
        return listRules(ListRulesRequest.builder().applyMutation(listRulesRequest).build());
    }

    /**
     * <p>
     * Lists all readiness rules, or lists the readiness rules for a specific resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRules(software.amazon.awssdk.services.route53recoveryreadiness.model.ListRulesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListRulesPublisher publisher = client.listRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListRulesPublisher publisher = client.listRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.ListRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.ListRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRules(software.amazon.awssdk.services.route53recoveryreadiness.model.ListRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRulesPublisher listRulesPaginator(ListRulesRequest listRulesRequest) {
        return new ListRulesPublisher(this, listRulesRequest);
    }

    /**
     * <p>
     * Lists all readiness rules, or lists the readiness rules for a specific resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRules(software.amazon.awssdk.services.route53recoveryreadiness.model.ListRulesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListRulesPublisher publisher = client.listRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListRulesPublisher publisher = client.listRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53recoveryreadiness.model.ListRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53recoveryreadiness.model.ListRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRules(software.amazon.awssdk.services.route53recoveryreadiness.model.ListRulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesRequest#builder()}
     * </p>
     *
     * @param listRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListRulesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRulesPublisher listRulesPaginator(Consumer<ListRulesRequest.Builder> listRulesRequest) {
        return listRulesPaginator(ListRulesRequest.builder().applyMutation(listRulesRequest).build());
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     *
     * @param listTagsForResourcesRequest
     * @return A Java Future containing the result of the ListTagsForResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListTagsForResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListTagsForResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourcesResponse> listTagsForResources(
            ListTagsForResourcesRequest listTagsForResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourcesRequest#builder()}
     * </p>
     *
     * @param listTagsForResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.ListTagsForResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/ListTagsForResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourcesResponse> listTagsForResources(
            Consumer<ListTagsForResourcesRequest.Builder> listTagsForResourcesRequest) {
        return listTagsForResources(ListTagsForResourcesRequest.builder().applyMutation(listTagsForResourcesRequest).build());
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a cell to replace the list of nested cells with a new list of nested cells.
     * </p>
     *
     * @param updateCellRequest
     * @return A Java Future containing the result of the UpdateCell operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.UpdateCell
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateCell"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCellResponse> updateCell(UpdateCellRequest updateCellRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a cell to replace the list of nested cells with a new list of nested cells.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCellRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateCellRequest#builder()}
     * </p>
     *
     * @param updateCellRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCellRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateCell operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.UpdateCell
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateCell"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCellResponse> updateCell(Consumer<UpdateCellRequest.Builder> updateCellRequest) {
        return updateCell(UpdateCellRequest.builder().applyMutation(updateCellRequest).build());
    }

    /**
     * <p>
     * Updates a readiness check.
     * </p>
     *
     * @param updateReadinessCheckRequest
     *        Name of a readiness check to describe.
     * @return A Java Future containing the result of the UpdateReadinessCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.UpdateReadinessCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateReadinessCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReadinessCheckResponse> updateReadinessCheck(
            UpdateReadinessCheckRequest updateReadinessCheckRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a readiness check.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReadinessCheckRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateReadinessCheckRequest#builder()}
     * </p>
     *
     * @param updateReadinessCheckRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReadinessCheckRequest.Builder} to create a
     *        request. Name of a readiness check to describe.
     * @return A Java Future containing the result of the UpdateReadinessCheck operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.UpdateReadinessCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateReadinessCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReadinessCheckResponse> updateReadinessCheck(
            Consumer<UpdateReadinessCheckRequest.Builder> updateReadinessCheckRequest) {
        return updateReadinessCheck(UpdateReadinessCheckRequest.builder().applyMutation(updateReadinessCheckRequest).build());
    }

    /**
     * <p>
     * Updates a recovery group.
     * </p>
     *
     * @param updateRecoveryGroupRequest
     *        Name of a recovery group.
     * @return A Java Future containing the result of the UpdateRecoveryGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.UpdateRecoveryGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateRecoveryGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRecoveryGroupResponse> updateRecoveryGroup(
            UpdateRecoveryGroupRequest updateRecoveryGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a recovery group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRecoveryGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRecoveryGroupRequest#builder()}
     * </p>
     *
     * @param updateRecoveryGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRecoveryGroupRequest.Builder} to create a
     *        request. Name of a recovery group.
     * @return A Java Future containing the result of the UpdateRecoveryGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.UpdateRecoveryGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateRecoveryGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRecoveryGroupResponse> updateRecoveryGroup(
            Consumer<UpdateRecoveryGroupRequest.Builder> updateRecoveryGroupRequest) {
        return updateRecoveryGroup(UpdateRecoveryGroupRequest.builder().applyMutation(updateRecoveryGroupRequest).build());
    }

    /**
     * <p>
     * Updates a resource set.
     * </p>
     *
     * @param updateResourceSetRequest
     *        Name of a resource set.
     * @return A Java Future containing the result of the UpdateResourceSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.UpdateResourceSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateResourceSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceSetResponse> updateResourceSet(UpdateResourceSetRequest updateResourceSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a resource set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceSetRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateResourceSetRequest#builder()}
     * </p>
     *
     * @param updateResourceSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceSetRequest.Builder} to create a request.
     *        Name of a resource set.
     * @return A Java Future containing the result of the UpdateResourceSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response - Malformed query string. The query string contains a syntax
     *         error or resource not found.</li>
     *         <li>ThrottlingException 429 response - Limit exceeded exception or too many requests exception.</li>
     *         <li>ValidationException 400 response - Multiple causes. For example, you might have a malformed query
     *         string, an input parameter might be out of range, or you used parameters together incorrectly.</li>
     *         <li>InternalServerException 500 response - Internal service error or temporary service error. Retry the
     *         request.</li>
     *         <li>AccessDeniedException 403 response - Access denied exception. You do not have sufficient access to
     *         perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53RecoveryReadinessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53RecoveryReadinessAsyncClient.UpdateResourceSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-readiness-2019-12-02/UpdateResourceSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceSetResponse> updateResourceSet(
            Consumer<UpdateResourceSetRequest.Builder> updateResourceSetRequest) {
        return updateResourceSet(UpdateResourceSetRequest.builder().applyMutation(updateResourceSetRequest).build());
    }

    @Override
    default Route53RecoveryReadinessServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link Route53RecoveryReadinessAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Route53RecoveryReadinessAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Route53RecoveryReadinessAsyncClient}.
     */
    static Route53RecoveryReadinessAsyncClientBuilder builder() {
        return new DefaultRoute53RecoveryReadinessAsyncClientBuilder();
    }
}
