/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;

public class ListResourceRecordSetsIterable
implements SdkIterable<ListResourceRecordSetsResponse> {
    private final Route53Client client;
    private final ListResourceRecordSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceRecordSetsIterable(Route53Client client, ListResourceRecordSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResourceRecordSetsResponseFetcher();
    }

    public Iterator<ListResourceRecordSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceRecordSet> resourceRecordSets() {
        Function<ListResourceRecordSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceRecordSets() != null) {
                return response.resourceRecordSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceRecordSetsResponseFetcher
    implements SyncPageFetcher<ListResourceRecordSetsResponse> {
        private ListResourceRecordSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceRecordSetsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListResourceRecordSetsResponse nextPage(ListResourceRecordSetsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceRecordSetsIterable.this.client.listResourceRecordSets(ListResourceRecordSetsIterable.this.firstRequest);
            }
            return ListResourceRecordSetsIterable.this.client.listResourceRecordSets((ListResourceRecordSetsRequest)((Object)ListResourceRecordSetsIterable.this.firstRequest.toBuilder().startRecordName(previousPage.nextRecordName()).startRecordType(previousPage.nextRecordTypeAsString()).startRecordIdentifier(previousPage.nextRecordIdentifier()).build()));
        }
    }
}

