/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.DelegationSet;
import software.amazon.awssdk.services.route53.model.DelegationSetsCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReusableDelegationSetsResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListReusableDelegationSetsResponse> {
    private static final SdkField<List<DelegationSet>> DELEGATION_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DelegationSets").getter(ListReusableDelegationSetsResponse.getter(ListReusableDelegationSetsResponse::delegationSets)).setter(ListReusableDelegationSetsResponse.setter(Builder::delegationSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationSets").unmarshallLocationName("DelegationSets").build(), ListTrait.builder().memberLocationName("DelegationSet").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DelegationSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationSet").unmarshallLocationName("DelegationSet").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListReusableDelegationSetsResponse.getter(ListReusableDelegationSetsResponse::marker)).setter(ListReusableDelegationSetsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").unmarshallLocationName("Marker").build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListReusableDelegationSetsResponse.getter(ListReusableDelegationSetsResponse::isTruncated)).setter(ListReusableDelegationSetsResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").unmarshallLocationName("IsTruncated").build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListReusableDelegationSetsResponse.getter(ListReusableDelegationSetsResponse::nextMarker)).setter(ListReusableDelegationSetsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").unmarshallLocationName("NextMarker").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListReusableDelegationSetsResponse.getter(ListReusableDelegationSetsResponse::maxItems)).setter(ListReusableDelegationSetsResponse.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATION_SETS_FIELD, MARKER_FIELD, IS_TRUNCATED_FIELD, NEXT_MARKER_FIELD, MAX_ITEMS_FIELD));
    private final List<DelegationSet> delegationSets;
    private final String marker;
    private final Boolean isTruncated;
    private final String nextMarker;
    private final String maxItems;

    private ListReusableDelegationSetsResponse(BuilderImpl builder) {
        super(builder);
        this.delegationSets = builder.delegationSets;
        this.marker = builder.marker;
        this.isTruncated = builder.isTruncated;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
    }

    public final boolean hasDelegationSets() {
        return this.delegationSets != null && !(this.delegationSets instanceof SdkAutoConstructList);
    }

    public final List<DelegationSet> delegationSets() {
        return this.delegationSets;
    }

    public final String marker() {
        return this.marker;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDelegationSets() ? this.delegationSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReusableDelegationSetsResponse)) {
            return false;
        }
        ListReusableDelegationSetsResponse other = (ListReusableDelegationSetsResponse)((Object)obj);
        return this.hasDelegationSets() == other.hasDelegationSets() && Objects.equals(this.delegationSets(), other.delegationSets()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListReusableDelegationSetsResponse").add("DelegationSets", this.hasDelegationSets() ? this.delegationSets() : null).add("Marker", (Object)this.marker()).add("IsTruncated", (Object)this.isTruncated()).add("NextMarker", (Object)this.nextMarker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DelegationSets": {
                return Optional.ofNullable(clazz.cast(this.delegationSets()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReusableDelegationSetsResponse, T> g) {
        return obj -> g.apply((ListReusableDelegationSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<DelegationSet> delegationSets = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Boolean isTruncated;
        private String nextMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReusableDelegationSetsResponse model) {
            super(model);
            this.delegationSets(model.delegationSets);
            this.marker(model.marker);
            this.isTruncated(model.isTruncated);
            this.nextMarker(model.nextMarker);
            this.maxItems(model.maxItems);
        }

        public final List<DelegationSet.Builder> getDelegationSets() {
            List<DelegationSet.Builder> result = DelegationSetsCopier.copyToBuilder(this.delegationSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDelegationSets(Collection<DelegationSet.BuilderImpl> delegationSets) {
            this.delegationSets = DelegationSetsCopier.copyFromBuilder(delegationSets);
        }

        @Override
        public final Builder delegationSets(Collection<DelegationSet> delegationSets) {
            this.delegationSets = DelegationSetsCopier.copy(delegationSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegationSets(DelegationSet ... delegationSets) {
            this.delegationSets(Arrays.asList(delegationSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegationSets(Consumer<DelegationSet.Builder> ... delegationSets) {
            this.delegationSets(Stream.of(delegationSets).map(c -> (DelegationSet)((DelegationSet.Builder)DelegationSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public ListReusableDelegationSetsResponse build() {
            return new ListReusableDelegationSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReusableDelegationSetsResponse> {
        public Builder delegationSets(Collection<DelegationSet> var1);

        public Builder delegationSets(DelegationSet ... var1);

        public Builder delegationSets(Consumer<DelegationSet.Builder> ... var1);

        public Builder marker(String var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextMarker(String var1);

        public Builder maxItems(String var1);
    }
}

