/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HealthCheckType {
    HTTP("HTTP"),
    HTTPS("HTTPS"),
    HTTP_STR_MATCH("HTTP_STR_MATCH"),
    HTTPS_STR_MATCH("HTTPS_STR_MATCH"),
    TCP("TCP"),
    CALCULATED("CALCULATED"),
    CLOUDWATCH_METRIC("CLOUDWATCH_METRIC"),
    RECOVERY_CONTROL("RECOVERY_CONTROL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HealthCheckType> VALUE_MAP;
    private final String value;

    private HealthCheckType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HealthCheckType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HealthCheckType> knownValues() {
        EnumSet<HealthCheckType> knownValues = EnumSet.allOf(HealthCheckType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HealthCheckType.class, HealthCheckType::toString);
    }
}

