/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains settings for the new traffic policy instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficPolicyInstance implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficPolicyInstance.Builder, TrafficPolicyInstance> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(TrafficPolicyInstance::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId")
            .getter(getter(TrafficPolicyInstance::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId")
                    .unmarshallLocationName("HostedZoneId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(TrafficPolicyInstance::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<Long> TTL_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TTL")
            .getter(getter(TrafficPolicyInstance::ttl))
            .setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TTL").unmarshallLocationName("TTL")
                    .build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TrafficPolicyInstance::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("State").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Message")
            .getter(getter(TrafficPolicyInstance::message))
            .setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message")
                    .unmarshallLocationName("Message").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyId")
            .getter(getter(TrafficPolicyInstance::trafficPolicyId))
            .setter(setter(Builder::trafficPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId")
                    .unmarshallLocationName("TrafficPolicyId").build()).build();

    private static final SdkField<Integer> TRAFFIC_POLICY_VERSION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TrafficPolicyVersion")
            .getter(getter(TrafficPolicyInstance::trafficPolicyVersion))
            .setter(setter(Builder::trafficPolicyVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyVersion")
                    .unmarshallLocationName("TrafficPolicyVersion").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyType")
            .getter(getter(TrafficPolicyInstance::trafficPolicyTypeAsString))
            .setter(setter(Builder::trafficPolicyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyType")
                    .unmarshallLocationName("TrafficPolicyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            HOSTED_ZONE_ID_FIELD, NAME_FIELD, TTL_FIELD, STATE_FIELD, MESSAGE_FIELD, TRAFFIC_POLICY_ID_FIELD,
            TRAFFIC_POLICY_VERSION_FIELD, TRAFFIC_POLICY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String hostedZoneId;

    private final String name;

    private final Long ttl;

    private final String state;

    private final String message;

    private final String trafficPolicyId;

    private final Integer trafficPolicyVersion;

    private final String trafficPolicyType;

    private TrafficPolicyInstance(BuilderImpl builder) {
        this.id = builder.id;
        this.hostedZoneId = builder.hostedZoneId;
        this.name = builder.name;
        this.ttl = builder.ttl;
        this.state = builder.state;
        this.message = builder.message;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
        this.trafficPolicyType = builder.trafficPolicyType;
    }

    /**
     * <p>
     * The ID that Amazon Route 53 assigned to the new traffic policy instance.
     * </p>
     * 
     * @return The ID that Amazon Route 53 assigned to the new traffic policy instance.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the hosted zone that Amazon Route 53 created resource record sets in.
     * </p>
     * 
     * @return The ID of the hosted zone that Amazon Route 53 created resource record sets in.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The DNS name, such as www.example.com, for which Amazon Route 53 responds to queries by using the resource record
     * sets that are associated with this traffic policy instance.
     * </p>
     * 
     * @return The DNS name, such as www.example.com, for which Amazon Route 53 responds to queries by using the
     *         resource record sets that are associated with this traffic policy instance.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The TTL that Amazon Route 53 assigned to all of the resource record sets that it created in the specified hosted
     * zone.
     * </p>
     * 
     * @return The TTL that Amazon Route 53 assigned to all of the resource record sets that it created in the specified
     *         hosted zone.
     */
    public final Long ttl() {
        return ttl;
    }

    /**
     * <p>
     * The value of <code>State</code> is one of the following values:
     * </p>
     * <dl>
     * <dt>Applied</dt>
     * <dd>
     * <p>
     * Amazon Route 53 has finished creating resource record sets, and changes have propagated to all Route 53 edge
     * locations.
     * </p>
     * </dd>
     * <dt>Creating</dt>
     * <dd>
     * <p>
     * Route 53 is creating the resource record sets. Use <code>GetTrafficPolicyInstance</code> to confirm that the
     * <code>CreateTrafficPolicyInstance</code> request completed successfully.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * Route 53 wasn't able to create or update the resource record sets. When the value of <code>State</code> is
     * <code>Failed</code>, see <code>Message</code> for an explanation of what caused the request to fail.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return The value of <code>State</code> is one of the following values:</p>
     *         <dl>
     *         <dt>Applied</dt>
     *         <dd>
     *         <p>
     *         Amazon Route 53 has finished creating resource record sets, and changes have propagated to all Route 53
     *         edge locations.
     *         </p>
     *         </dd>
     *         <dt>Creating</dt>
     *         <dd>
     *         <p>
     *         Route 53 is creating the resource record sets. Use <code>GetTrafficPolicyInstance</code> to confirm that
     *         the <code>CreateTrafficPolicyInstance</code> request completed successfully.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         Route 53 wasn't able to create or update the resource record sets. When the value of <code>State</code>
     *         is <code>Failed</code>, see <code>Message</code> for an explanation of what caused the request to fail.
     *         </p>
     *         </dd>
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * If <code>State</code> is <code>Failed</code>, an explanation of the reason for the failure. If <code>State</code>
     * is another value, <code>Message</code> is empty.
     * </p>
     * 
     * @return If <code>State</code> is <code>Failed</code>, an explanation of the reason for the failure. If
     *         <code>State</code> is another value, <code>Message</code> is empty.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The ID of the traffic policy that Amazon Route 53 used to create resource record sets in the specified hosted
     * zone.
     * </p>
     * 
     * @return The ID of the traffic policy that Amazon Route 53 used to create resource record sets in the specified
     *         hosted zone.
     */
    public final String trafficPolicyId() {
        return trafficPolicyId;
    }

    /**
     * <p>
     * The version of the traffic policy that Amazon Route 53 used to create resource record sets in the specified
     * hosted zone.
     * </p>
     * 
     * @return The version of the traffic policy that Amazon Route 53 used to create resource record sets in the
     *         specified hosted zone.
     */
    public final Integer trafficPolicyVersion() {
        return trafficPolicyVersion;
    }

    /**
     * <p>
     * The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this traffic
     * policy instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficPolicyType}
     * will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficPolicyTypeAsString}.
     * </p>
     * 
     * @return The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this
     *         traffic policy instance.
     * @see RRType
     */
    public final RRType trafficPolicyType() {
        return RRType.fromValue(trafficPolicyType);
    }

    /**
     * <p>
     * The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this traffic
     * policy instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficPolicyType}
     * will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficPolicyTypeAsString}.
     * </p>
     * 
     * @return The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this
     *         traffic policy instance.
     * @see RRType
     */
    public final String trafficPolicyTypeAsString() {
        return trafficPolicyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPolicyInstance)) {
            return false;
        }
        TrafficPolicyInstance other = (TrafficPolicyInstance) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(name(), other.name()) && Objects.equals(ttl(), other.ttl())
                && Objects.equals(state(), other.state()) && Objects.equals(message(), other.message())
                && Objects.equals(trafficPolicyId(), other.trafficPolicyId())
                && Objects.equals(trafficPolicyVersion(), other.trafficPolicyVersion())
                && Objects.equals(trafficPolicyTypeAsString(), other.trafficPolicyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficPolicyInstance").add("Id", id()).add("HostedZoneId", hostedZoneId()).add("Name", name())
                .add("TTL", ttl()).add("State", state()).add("Message", message()).add("TrafficPolicyId", trafficPolicyId())
                .add("TrafficPolicyVersion", trafficPolicyVersion()).add("TrafficPolicyType", trafficPolicyTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TTL":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "TrafficPolicyId":
            return Optional.ofNullable(clazz.cast(trafficPolicyId()));
        case "TrafficPolicyVersion":
            return Optional.ofNullable(clazz.cast(trafficPolicyVersion()));
        case "TrafficPolicyType":
            return Optional.ofNullable(clazz.cast(trafficPolicyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficPolicyInstance, T> g) {
        return obj -> g.apply((TrafficPolicyInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficPolicyInstance> {
        /**
         * <p>
         * The ID that Amazon Route 53 assigned to the new traffic policy instance.
         * </p>
         * 
         * @param id
         *        The ID that Amazon Route 53 assigned to the new traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the hosted zone that Amazon Route 53 created resource record sets in.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that Amazon Route 53 created resource record sets in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The DNS name, such as www.example.com, for which Amazon Route 53 responds to queries by using the resource
         * record sets that are associated with this traffic policy instance.
         * </p>
         * 
         * @param name
         *        The DNS name, such as www.example.com, for which Amazon Route 53 responds to queries by using the
         *        resource record sets that are associated with this traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The TTL that Amazon Route 53 assigned to all of the resource record sets that it created in the specified
         * hosted zone.
         * </p>
         * 
         * @param ttl
         *        The TTL that Amazon Route 53 assigned to all of the resource record sets that it created in the
         *        specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Long ttl);

        /**
         * <p>
         * The value of <code>State</code> is one of the following values:
         * </p>
         * <dl>
         * <dt>Applied</dt>
         * <dd>
         * <p>
         * Amazon Route 53 has finished creating resource record sets, and changes have propagated to all Route 53 edge
         * locations.
         * </p>
         * </dd>
         * <dt>Creating</dt>
         * <dd>
         * <p>
         * Route 53 is creating the resource record sets. Use <code>GetTrafficPolicyInstance</code> to confirm that the
         * <code>CreateTrafficPolicyInstance</code> request completed successfully.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * Route 53 wasn't able to create or update the resource record sets. When the value of <code>State</code> is
         * <code>Failed</code>, see <code>Message</code> for an explanation of what caused the request to fail.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param state
         *        The value of <code>State</code> is one of the following values:</p>
         *        <dl>
         *        <dt>Applied</dt>
         *        <dd>
         *        <p>
         *        Amazon Route 53 has finished creating resource record sets, and changes have propagated to all Route
         *        53 edge locations.
         *        </p>
         *        </dd>
         *        <dt>Creating</dt>
         *        <dd>
         *        <p>
         *        Route 53 is creating the resource record sets. Use <code>GetTrafficPolicyInstance</code> to confirm
         *        that the <code>CreateTrafficPolicyInstance</code> request completed successfully.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        Route 53 wasn't able to create or update the resource record sets. When the value of
         *        <code>State</code> is <code>Failed</code>, see <code>Message</code> for an explanation of what caused
         *        the request to fail.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * If <code>State</code> is <code>Failed</code>, an explanation of the reason for the failure. If
         * <code>State</code> is another value, <code>Message</code> is empty.
         * </p>
         * 
         * @param message
         *        If <code>State</code> is <code>Failed</code>, an explanation of the reason for the failure. If
         *        <code>State</code> is another value, <code>Message</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The ID of the traffic policy that Amazon Route 53 used to create resource record sets in the specified hosted
         * zone.
         * </p>
         * 
         * @param trafficPolicyId
         *        The ID of the traffic policy that Amazon Route 53 used to create resource record sets in the specified
         *        hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);

        /**
         * <p>
         * The version of the traffic policy that Amazon Route 53 used to create resource record sets in the specified
         * hosted zone.
         * </p>
         * 
         * @param trafficPolicyVersion
         *        The version of the traffic policy that Amazon Route 53 used to create resource record sets in the
         *        specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyVersion(Integer trafficPolicyVersion);

        /**
         * <p>
         * The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this
         * traffic policy instance.
         * </p>
         * 
         * @param trafficPolicyType
         *        The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this
         *        traffic policy instance.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyType(String trafficPolicyType);

        /**
         * <p>
         * The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this
         * traffic policy instance.
         * </p>
         * 
         * @param trafficPolicyType
         *        The DNS type that Amazon Route 53 assigned to all of the resource record sets that it created for this
         *        traffic policy instance.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyType(RRType trafficPolicyType);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String hostedZoneId;

        private String name;

        private Long ttl;

        private String state;

        private String message;

        private String trafficPolicyId;

        private Integer trafficPolicyVersion;

        private String trafficPolicyType;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficPolicyInstance model) {
            id(model.id);
            hostedZoneId(model.hostedZoneId);
            name(model.name);
            ttl(model.ttl);
            state(model.state);
            message(model.message);
            trafficPolicyId(model.trafficPolicyId);
            trafficPolicyVersion(model.trafficPolicyVersion);
            trafficPolicyType(model.trafficPolicyType);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getTtl() {
            return ttl;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final Integer getTrafficPolicyVersion() {
            return trafficPolicyVersion;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        public final String getTrafficPolicyType() {
            return trafficPolicyType;
        }

        public final void setTrafficPolicyType(String trafficPolicyType) {
            this.trafficPolicyType = trafficPolicyType;
        }

        @Override
        public final Builder trafficPolicyType(String trafficPolicyType) {
            this.trafficPolicyType = trafficPolicyType;
            return this;
        }

        @Override
        public final Builder trafficPolicyType(RRType trafficPolicyType) {
            this.trafficPolicyType(trafficPolicyType == null ? null : trafficPolicyType.toString());
            return this;
        }

        @Override
        public TrafficPolicyInstance build() {
            return new TrafficPolicyInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
