/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCidrBlocksRequest extends Route53Request implements
        ToCopyableBuilder<ListCidrBlocksRequest.Builder, ListCidrBlocksRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CollectionId")
            .getter(getter(ListCidrBlocksRequest::collectionId))
            .setter(setter(Builder::collectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CidrCollectionId")
                    .unmarshallLocationName("CidrCollectionId").build()).build();

    private static final SdkField<String> LOCATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocationName")
            .getter(getter(ListCidrBlocksRequest::locationName))
            .setter(setter(Builder::locationName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("location")
                    .unmarshallLocationName("location").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListCidrBlocksRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nexttoken")
                    .unmarshallLocationName("nexttoken").build()).build();

    private static final SdkField<String> MAX_RESULTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxResults")
            .getter(getter(ListCidrBlocksRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxresults")
                    .unmarshallLocationName("maxresults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD,
            LOCATION_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String collectionId;

    private final String locationName;

    private final String nextToken;

    private final String maxResults;

    private ListCidrBlocksRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.locationName = builder.locationName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The UUID of the CIDR collection.
     * </p>
     * 
     * @return The UUID of the CIDR collection.
     */
    public final String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * The name of the CIDR collection location.
     * </p>
     * 
     * @return The name of the CIDR collection location.
     */
    public final String locationName() {
        return locationName;
    }

    /**
     * <p>
     * An opaque pagination token to indicate where the service is to begin enumerating results.
     * </p>
     * 
     * @return An opaque pagination token to indicate where the service is to begin enumerating results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Maximum number of results you want returned.
     * </p>
     * 
     * @return Maximum number of results you want returned.
     */
    public final String maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(locationName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCidrBlocksRequest)) {
            return false;
        }
        ListCidrBlocksRequest other = (ListCidrBlocksRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(locationName(), other.locationName())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCidrBlocksRequest").add("CollectionId", collectionId()).add("LocationName", locationName())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.ofNullable(clazz.cast(collectionId()));
        case "LocationName":
            return Optional.ofNullable(clazz.cast(locationName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCidrBlocksRequest, T> g) {
        return obj -> g.apply((ListCidrBlocksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, ListCidrBlocksRequest> {
        /**
         * <p>
         * The UUID of the CIDR collection.
         * </p>
         * 
         * @param collectionId
         *        The UUID of the CIDR collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * The name of the CIDR collection location.
         * </p>
         * 
         * @param locationName
         *        The name of the CIDR collection location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationName(String locationName);

        /**
         * <p>
         * An opaque pagination token to indicate where the service is to begin enumerating results.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token to indicate where the service is to begin enumerating results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Maximum number of results you want returned.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results you want returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(String maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String collectionId;

        private String locationName;

        private String nextToken;

        private String maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCidrBlocksRequest model) {
            super(model);
            collectionId(model.collectionId);
            locationName(model.locationName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final String getLocationName() {
            return locationName;
        }

        public final void setLocationName(String locationName) {
            this.locationName = locationName;
        }

        @Override
        public final Builder locationName(String locationName) {
            this.locationName = locationName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(String maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(String maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCidrBlocksRequest build() {
            return new ListCidrBlocksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
