/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrustAnchorType {
    AWS_ACM_PCA("AWS_ACM_PCA"),
    CERTIFICATE_BUNDLE("CERTIFICATE_BUNDLE"),
    SELF_SIGNED_REPOSITORY("SELF_SIGNED_REPOSITORY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrustAnchorType> VALUE_MAP;
    private final String value;

    private TrustAnchorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrustAnchorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrustAnchorType> knownValues() {
        EnumSet<TrustAnchorType> knownValues = EnumSet.allOf(TrustAnchorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrustAnchorType.class, TrustAnchorType::toString);
    }
}

