/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.ExitBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Tool
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Tool> {
    private static final SdkField<Boolean> STREAM_UI_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("streamUI").getter(Tool.getter(Tool::streamUI)).setter(Tool.setter(Builder::streamUI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamUI").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Tool.getter(Tool::name)).setter(Tool.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("command").getter(Tool.getter(Tool::command)).setter(Tool.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()}).build();
    private static final SdkField<Boolean> STREAM_OUTPUT_TO_CLOUD_WATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("streamOutputToCloudWatch").getter(Tool.getter(Tool::streamOutputToCloudWatch)).setter(Tool.setter(Builder::streamOutputToCloudWatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamOutputToCloudWatch").build()}).build();
    private static final SdkField<String> EXIT_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exitBehavior").getter(Tool.getter(Tool::exitBehaviorAsString)).setter(Tool.setter(Builder::exitBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_UI_FIELD, NAME_FIELD, COMMAND_FIELD, STREAM_OUTPUT_TO_CLOUD_WATCH_FIELD, EXIT_BEHAVIOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean streamUI;
    private final String name;
    private final String command;
    private final Boolean streamOutputToCloudWatch;
    private final String exitBehavior;

    private Tool(BuilderImpl builder) {
        this.streamUI = builder.streamUI;
        this.name = builder.name;
        this.command = builder.command;
        this.streamOutputToCloudWatch = builder.streamOutputToCloudWatch;
        this.exitBehavior = builder.exitBehavior;
    }

    public final Boolean streamUI() {
        return this.streamUI;
    }

    public final String name() {
        return this.name;
    }

    public final String command() {
        return this.command;
    }

    public final Boolean streamOutputToCloudWatch() {
        return this.streamOutputToCloudWatch;
    }

    public final ExitBehavior exitBehavior() {
        return ExitBehavior.fromValue(this.exitBehavior);
    }

    public final String exitBehaviorAsString() {
        return this.exitBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamUI());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamOutputToCloudWatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tool)) {
            return false;
        }
        Tool other = (Tool)obj;
        return Objects.equals(this.streamUI(), other.streamUI()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.streamOutputToCloudWatch(), other.streamOutputToCloudWatch()) && Objects.equals(this.exitBehaviorAsString(), other.exitBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Tool").add("StreamUI", (Object)this.streamUI()).add("Name", (Object)this.name()).add("Command", (Object)this.command()).add("StreamOutputToCloudWatch", (Object)this.streamOutputToCloudWatch()).add("ExitBehavior", (Object)this.exitBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamUI": {
                return Optional.ofNullable(clazz.cast(this.streamUI()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "streamOutputToCloudWatch": {
                return Optional.ofNullable(clazz.cast(this.streamOutputToCloudWatch()));
            }
            case "exitBehavior": {
                return Optional.ofNullable(clazz.cast(this.exitBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tool, T> g) {
        return obj -> g.apply((Tool)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean streamUI;
        private String name;
        private String command;
        private Boolean streamOutputToCloudWatch;
        private String exitBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(Tool model) {
            this.streamUI(model.streamUI);
            this.name(model.name);
            this.command(model.command);
            this.streamOutputToCloudWatch(model.streamOutputToCloudWatch);
            this.exitBehavior(model.exitBehavior);
        }

        public final Boolean getStreamUI() {
            return this.streamUI;
        }

        public final void setStreamUI(Boolean streamUI) {
            this.streamUI = streamUI;
        }

        @Override
        public final Builder streamUI(Boolean streamUI) {
            this.streamUI = streamUI;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCommand() {
            return this.command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final Boolean getStreamOutputToCloudWatch() {
            return this.streamOutputToCloudWatch;
        }

        public final void setStreamOutputToCloudWatch(Boolean streamOutputToCloudWatch) {
            this.streamOutputToCloudWatch = streamOutputToCloudWatch;
        }

        @Override
        public final Builder streamOutputToCloudWatch(Boolean streamOutputToCloudWatch) {
            this.streamOutputToCloudWatch = streamOutputToCloudWatch;
            return this;
        }

        public final String getExitBehavior() {
            return this.exitBehavior;
        }

        public final void setExitBehavior(String exitBehavior) {
            this.exitBehavior = exitBehavior;
        }

        @Override
        public final Builder exitBehavior(String exitBehavior) {
            this.exitBehavior = exitBehavior;
            return this;
        }

        @Override
        public final Builder exitBehavior(ExitBehavior exitBehavior) {
            this.exitBehavior(exitBehavior == null ? null : exitBehavior.toString());
            return this;
        }

        public Tool build() {
            return new Tool(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Tool> {
        public Builder streamUI(Boolean var1);

        public Builder name(String var1);

        public Builder command(String var1);

        public Builder streamOutputToCloudWatch(Boolean var1);

        public Builder exitBehavior(String var1);

        public Builder exitBehavior(ExitBehavior var1);
    }
}

