/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary;

public class ListRobotApplicationsIterable
implements SdkIterable<ListRobotApplicationsResponse> {
    private final RoboMakerClient client;
    private final ListRobotApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRobotApplicationsIterable(RoboMakerClient client, ListRobotApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRobotApplicationsResponseFetcher();
    }

    public Iterator<ListRobotApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RobotApplicationSummary> robotApplicationSummaries() {
        Function<ListRobotApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.robotApplicationSummaries() != null) {
                return response.robotApplicationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRobotApplicationsResponseFetcher
    implements SyncPageFetcher<ListRobotApplicationsResponse> {
        private ListRobotApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRobotApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRobotApplicationsResponse nextPage(ListRobotApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListRobotApplicationsIterable.this.client.listRobotApplications(ListRobotApplicationsIterable.this.firstRequest);
            }
            return ListRobotApplicationsIterable.this.client.listRobotApplications((ListRobotApplicationsRequest)((Object)ListRobotApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

