/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.retries.AdaptiveRetryStrategy;
import software.amazon.awssdk.retries.LegacyRetryStrategy;
import software.amazon.awssdk.retries.StandardRetryStrategy;

@SdkPublicApi
public final class DefaultRetryStrategy {
    private DefaultRetryStrategy() {
    }

    public static StandardRetryStrategy doNotRetry() {
        return ((StandardRetryStrategy.Builder)DefaultRetryStrategy.standardStrategyBuilder().maxAttempts(1)).build();
    }

    public static StandardRetryStrategy.Builder standardStrategyBuilder() {
        return StandardRetryStrategy.builder();
    }

    public static LegacyRetryStrategy.Builder legacyStrategyBuilder() {
        return LegacyRetryStrategy.builder();
    }

    public static AdaptiveRetryStrategy.Builder adaptiveStrategyBuilder() {
        return AdaptiveRetryStrategy.builder();
    }

    static final class Legacy {
        static final int MAX_ATTEMPTS = 4;
        static final Duration BASE_DELAY = Duration.ofMillis(100L);
        static final Duration THROTTLED_BASE_DELAY = Duration.ofMillis(500L);
        static final Duration MAX_BACKOFF = Duration.ofSeconds(20L);
        static final int TOKEN_BUCKET_SIZE = 500;
        static final int DEFAULT_EXCEPTION_TOKEN_COST = 5;
        static final int THROTTLE_EXCEPTION_TOKEN_COST = 0;

        private Legacy() {
        }
    }

    static final class Adaptive {
        static final int MAX_ATTEMPTS = 3;

        private Adaptive() {
        }
    }

    static final class Standard {
        static final int MAX_ATTEMPTS = 3;
        static final Duration BASE_DELAY = Duration.ofMillis(100L);
        static final Duration THROTTLED_BASE_DELAY = Duration.ofSeconds(1L);
        static final Duration MAX_BACKOFF = Duration.ofSeconds(20L);
        static final int TOKEN_BUCKET_SIZE = 500;
        static final int DEFAULT_EXCEPTION_TOKEN_COST = 5;

        private Standard() {
        }
    }
}

