/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DifferenceType {
    NOT_EQUAL("NotEqual"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DifferenceType> VALUE_MAP;
    private final String value;

    private DifferenceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DifferenceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DifferenceType> knownValues() {
        EnumSet<DifferenceType> knownValues = EnumSet.allOf(DifferenceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DifferenceType.class, DifferenceType::toString);
    }
}

