/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAppVersionResourceRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<UpdateAppVersionResourceRequest.Builder, UpdateAppVersionResourceRequest> {
    private static final SdkField<Map<String, List<String>>> ADDITIONAL_INFO_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("additionalInfo")
            .getter(getter(UpdateAppVersionResourceRequest::additionalInfo))
            .setter(setter(Builder::additionalInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInfo").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(UpdateAppVersionResourceRequest::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<List<String>> APP_COMPONENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("appComponents")
            .getter(getter(UpdateAppVersionResourceRequest::appComponents))
            .setter(setter(Builder::appComponents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(UpdateAppVersionResourceRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsRegion").getter(getter(UpdateAppVersionResourceRequest::awsRegion))
            .setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()).build();

    private static final SdkField<Boolean> EXCLUDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("excluded").getter(getter(UpdateAppVersionResourceRequest::excluded)).setter(setter(Builder::excluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excluded").build()).build();

    private static final SdkField<LogicalResourceId> LOGICAL_RESOURCE_ID_FIELD = SdkField
            .<LogicalResourceId> builder(MarshallingType.SDK_POJO).memberName("logicalResourceId")
            .getter(getter(UpdateAppVersionResourceRequest::logicalResourceId)).setter(setter(Builder::logicalResourceId))
            .constructor(LogicalResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalResourceId").build()).build();

    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("physicalResourceId").getter(getter(UpdateAppVersionResourceRequest::physicalResourceId))
            .setter(setter(Builder::physicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResourceId").build())
            .build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(UpdateAppVersionResourceRequest::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(UpdateAppVersionResourceRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_INFO_FIELD,
            APP_ARN_FIELD, APP_COMPONENTS_FIELD, AWS_ACCOUNT_ID_FIELD, AWS_REGION_FIELD, EXCLUDED_FIELD,
            LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD, RESOURCE_TYPE_FIELD));

    private final Map<String, List<String>> additionalInfo;

    private final String appArn;

    private final List<String> appComponents;

    private final String awsAccountId;

    private final String awsRegion;

    private final Boolean excluded;

    private final LogicalResourceId logicalResourceId;

    private final String physicalResourceId;

    private final String resourceName;

    private final String resourceType;

    private UpdateAppVersionResourceRequest(BuilderImpl builder) {
        super(builder);
        this.additionalInfo = builder.additionalInfo;
        this.appArn = builder.appArn;
        this.appComponents = builder.appComponents;
        this.awsAccountId = builder.awsAccountId;
        this.awsRegion = builder.awsRegion;
        this.excluded = builder.excluded;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalInfo property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalInfo() {
        return additionalInfo != null && !(additionalInfo instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Currently, there is no supported additional information for resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalInfo} method.
     * </p>
     * 
     * @return Currently, there is no supported additional information for resources.
     */
    public final Map<String, List<String>> additionalInfo() {
        return additionalInfo;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppComponents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppComponents() {
        return appComponents != null && !(appComponents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Application Components that this resource belongs to. If an Application Component is not part of the
     * Resilience Hub application, it will be added.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppComponents} method.
     * </p>
     * 
     * @return The list of Application Components that this resource belongs to. If an Application Component is not part
     *         of the Resilience Hub application, it will be added.
     */
    public final List<String> appComponents() {
        return appComponents;
    }

    /**
     * <p>
     * The Amazon Web Services account that owns the physical resource.
     * </p>
     * 
     * @return The Amazon Web Services account that owns the physical resource.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services region that owns the physical resource.
     * </p>
     * 
     * @return The Amazon Web Services region that owns the physical resource.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * Indicates if a resource is excluded from an Resilience Hub application.
     * </p>
     * <note>
     * <p>
     * You can exclude only imported resources from an Resilience Hub application.
     * </p>
     * </note>
     * 
     * @return Indicates if a resource is excluded from an Resilience Hub application.</p> <note>
     *         <p>
     *         You can exclude only imported resources from an Resilience Hub application.
     *         </p>
     */
    public final Boolean excluded() {
        return excluded;
    }

    /**
     * <p>
     * The logical identifier of the resource.
     * </p>
     * 
     * @return The logical identifier of the resource.
     */
    public final LogicalResourceId logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The physical identifier of the resource.
     * </p>
     * 
     * @return The physical identifier of the resource.
     */
    public final String physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * 
     * @return The type of resource.
     */
    public final String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalInfo() ? additionalInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppComponents() ? appComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(excluded());
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppVersionResourceRequest)) {
            return false;
        }
        UpdateAppVersionResourceRequest other = (UpdateAppVersionResourceRequest) obj;
        return hasAdditionalInfo() == other.hasAdditionalInfo() && Objects.equals(additionalInfo(), other.additionalInfo())
                && Objects.equals(appArn(), other.appArn()) && hasAppComponents() == other.hasAppComponents()
                && Objects.equals(appComponents(), other.appComponents()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(awsRegion(), other.awsRegion()) && Objects.equals(excluded(), other.excluded())
                && Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(physicalResourceId(), other.physicalResourceId())
                && Objects.equals(resourceName(), other.resourceName()) && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAppVersionResourceRequest")
                .add("AdditionalInfo", hasAdditionalInfo() ? additionalInfo() : null).add("AppArn", appArn())
                .add("AppComponents", hasAppComponents() ? appComponents() : null).add("AwsAccountId", awsAccountId())
                .add("AwsRegion", awsRegion()).add("Excluded", excluded()).add("LogicalResourceId", logicalResourceId())
                .add("PhysicalResourceId", physicalResourceId()).add("ResourceName", resourceName())
                .add("ResourceType", resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalInfo":
            return Optional.ofNullable(clazz.cast(additionalInfo()));
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appComponents":
            return Optional.ofNullable(clazz.cast(appComponents()));
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "awsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "excluded":
            return Optional.ofNullable(clazz.cast(excluded()));
        case "logicalResourceId":
            return Optional.ofNullable(clazz.cast(logicalResourceId()));
        case "physicalResourceId":
            return Optional.ofNullable(clazz.cast(physicalResourceId()));
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppVersionResourceRequest, T> g) {
        return obj -> g.apply((UpdateAppVersionResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAppVersionResourceRequest> {
        /**
         * <p>
         * Currently, there is no supported additional information for resources.
         * </p>
         * 
         * @param additionalInfo
         *        Currently, there is no supported additional information for resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(Map<String, ? extends Collection<String>> additionalInfo);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The list of Application Components that this resource belongs to. If an Application Component is not part of
         * the Resilience Hub application, it will be added.
         * </p>
         * 
         * @param appComponents
         *        The list of Application Components that this resource belongs to. If an Application Component is not
         *        part of the Resilience Hub application, it will be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponents(Collection<String> appComponents);

        /**
         * <p>
         * The list of Application Components that this resource belongs to. If an Application Component is not part of
         * the Resilience Hub application, it will be added.
         * </p>
         * 
         * @param appComponents
         *        The list of Application Components that this resource belongs to. If an Application Component is not
         *        part of the Resilience Hub application, it will be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponents(String... appComponents);

        /**
         * <p>
         * The Amazon Web Services account that owns the physical resource.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account that owns the physical resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Web Services region that owns the physical resource.
         * </p>
         * 
         * @param awsRegion
         *        The Amazon Web Services region that owns the physical resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * Indicates if a resource is excluded from an Resilience Hub application.
         * </p>
         * <note>
         * <p>
         * You can exclude only imported resources from an Resilience Hub application.
         * </p>
         * </note>
         * 
         * @param excluded
         *        Indicates if a resource is excluded from an Resilience Hub application.</p> <note>
         *        <p>
         *        You can exclude only imported resources from an Resilience Hub application.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excluded(Boolean excluded);

        /**
         * <p>
         * The logical identifier of the resource.
         * </p>
         * 
         * @param logicalResourceId
         *        The logical identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(LogicalResourceId logicalResourceId);

        /**
         * <p>
         * The logical identifier of the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogicalResourceId.Builder} avoiding the
         * need to create one manually via {@link LogicalResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogicalResourceId.Builder#build()} is called immediately and its
         * result is passed to {@link #logicalResourceId(LogicalResourceId)}.
         * 
         * @param logicalResourceId
         *        a consumer that will call methods on {@link LogicalResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logicalResourceId(LogicalResourceId)
         */
        default Builder logicalResourceId(Consumer<LogicalResourceId.Builder> logicalResourceId) {
            return logicalResourceId(LogicalResourceId.builder().applyMutation(logicalResourceId).build());
        }

        /**
         * <p>
         * The physical identifier of the resource.
         * </p>
         * 
         * @param physicalResourceId
         *        The physical identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param resourceType
         *        The type of resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private Map<String, List<String>> additionalInfo = DefaultSdkAutoConstructMap.getInstance();

        private String appArn;

        private List<String> appComponents = DefaultSdkAutoConstructList.getInstance();

        private String awsAccountId;

        private String awsRegion;

        private Boolean excluded;

        private LogicalResourceId logicalResourceId;

        private String physicalResourceId;

        private String resourceName;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppVersionResourceRequest model) {
            super(model);
            additionalInfo(model.additionalInfo);
            appArn(model.appArn);
            appComponents(model.appComponents);
            awsAccountId(model.awsAccountId);
            awsRegion(model.awsRegion);
            excluded(model.excluded);
            logicalResourceId(model.logicalResourceId);
            physicalResourceId(model.physicalResourceId);
            resourceName(model.resourceName);
            resourceType(model.resourceType);
        }

        public final Map<String, ? extends Collection<String>> getAdditionalInfo() {
            if (additionalInfo instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalInfo;
        }

        public final void setAdditionalInfo(Map<String, ? extends Collection<String>> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
        }

        @Override
        public final Builder additionalInfo(Map<String, ? extends Collection<String>> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
            return this;
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final Collection<String> getAppComponents() {
            if (appComponents instanceof SdkAutoConstructList) {
                return null;
            }
            return appComponents;
        }

        public final void setAppComponents(Collection<String> appComponents) {
            this.appComponents = AppComponentNameListCopier.copy(appComponents);
        }

        @Override
        public final Builder appComponents(Collection<String> appComponents) {
            this.appComponents = AppComponentNameListCopier.copy(appComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponents(String... appComponents) {
            appComponents(Arrays.asList(appComponents));
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final Boolean getExcluded() {
            return excluded;
        }

        public final void setExcluded(Boolean excluded) {
            this.excluded = excluded;
        }

        @Override
        public final Builder excluded(Boolean excluded) {
            this.excluded = excluded;
            return this;
        }

        public final LogicalResourceId.Builder getLogicalResourceId() {
            return logicalResourceId != null ? logicalResourceId.toBuilder() : null;
        }

        public final void setLogicalResourceId(LogicalResourceId.BuilderImpl logicalResourceId) {
            this.logicalResourceId = logicalResourceId != null ? logicalResourceId.build() : null;
        }

        @Override
        public final Builder logicalResourceId(LogicalResourceId logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppVersionResourceRequest build() {
            return new UpdateAppVersionResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
