/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a resource mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceMapping implements SdkPojo, Serializable, ToCopyableBuilder<ResourceMapping.Builder, ResourceMapping> {
    private static final SdkField<String> APP_REGISTRY_APP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appRegistryAppName").getter(getter(ResourceMapping::appRegistryAppName))
            .setter(setter(Builder::appRegistryAppName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appRegistryAppName").build())
            .build();

    private static final SdkField<String> EKS_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eksSourceName").getter(getter(ResourceMapping::eksSourceName)).setter(setter(Builder::eksSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksSourceName").build()).build();

    private static final SdkField<String> LOGICAL_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logicalStackName").getter(getter(ResourceMapping::logicalStackName))
            .setter(setter(Builder::logicalStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalStackName").build()).build();

    private static final SdkField<String> MAPPING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mappingType").getter(getter(ResourceMapping::mappingTypeAsString)).setter(setter(Builder::mappingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingType").build()).build();

    private static final SdkField<PhysicalResourceId> PHYSICAL_RESOURCE_ID_FIELD = SdkField
            .<PhysicalResourceId> builder(MarshallingType.SDK_POJO).memberName("physicalResourceId")
            .getter(getter(ResourceMapping::physicalResourceId)).setter(setter(Builder::physicalResourceId))
            .constructor(PhysicalResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResourceId").build())
            .build();

    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceGroupName").getter(getter(ResourceMapping::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupName").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(ResourceMapping::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> TERRAFORM_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("terraformSourceName").getter(getter(ResourceMapping::terraformSourceName))
            .setter(setter(Builder::terraformSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSourceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_REGISTRY_APP_NAME_FIELD,
            EKS_SOURCE_NAME_FIELD, LOGICAL_STACK_NAME_FIELD, MAPPING_TYPE_FIELD, PHYSICAL_RESOURCE_ID_FIELD,
            RESOURCE_GROUP_NAME_FIELD, RESOURCE_NAME_FIELD, TERRAFORM_SOURCE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appRegistryAppName;

    private final String eksSourceName;

    private final String logicalStackName;

    private final String mappingType;

    private final PhysicalResourceId physicalResourceId;

    private final String resourceGroupName;

    private final String resourceName;

    private final String terraformSourceName;

    private ResourceMapping(BuilderImpl builder) {
        this.appRegistryAppName = builder.appRegistryAppName;
        this.eksSourceName = builder.eksSourceName;
        this.logicalStackName = builder.logicalStackName;
        this.mappingType = builder.mappingType;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceGroupName = builder.resourceGroupName;
        this.resourceName = builder.resourceName;
        this.terraformSourceName = builder.terraformSourceName;
    }

    /**
     * <p>
     * The name of the application this resource is mapped to.
     * </p>
     * 
     * @return The name of the application this resource is mapped to.
     */
    public final String appRegistryAppName() {
        return appRegistryAppName;
    }

    /**
     * <p>
     * The name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
     * </p>
     * <note>
     * <p>
     * This parameter accepts values in "eks-cluster/namespace" format.
     * </p>
     * </note>
     * 
     * @return The name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.</p>
     *         <note>
     *         <p>
     *         This parameter accepts values in "eks-cluster/namespace" format.
     *         </p>
     */
    public final String eksSourceName() {
        return eksSourceName;
    }

    /**
     * <p>
     * The name of the CloudFormation stack this resource is mapped to.
     * </p>
     * 
     * @return The name of the CloudFormation stack this resource is mapped to.
     */
    public final String logicalStackName() {
        return logicalStackName;
    }

    /**
     * <p>
     * Specifies the type of resource mapping.
     * </p>
     * <dl>
     * <dt>AppRegistryApp</dt>
     * <dd>
     * <p>
     * The resource is mapped to another application. The name of the application is contained in the
     * <code>appRegistryAppName</code> property.
     * </p>
     * </dd>
     * <dt>CfnStack</dt>
     * <dd>
     * <p>
     * The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the
     * <code>logicalStackName</code> property.
     * </p>
     * </dd>
     * <dt>Resource</dt>
     * <dd>
     * <p>
     * The resource is mapped to another resource. The name of the resource is contained in the
     * <code>resourceName</code> property.
     * </p>
     * </dd>
     * <dt>ResourceGroup</dt>
     * <dd>
     * <p>
     * The resource is mapped to Resource Groups. The name of the resource group is contained in the
     * <code>resourceGroupName</code> property.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mappingType} will
     * return {@link ResourceMappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mappingTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of resource mapping.</p>
     *         <dl>
     *         <dt>AppRegistryApp</dt>
     *         <dd>
     *         <p>
     *         The resource is mapped to another application. The name of the application is contained in the
     *         <code>appRegistryAppName</code> property.
     *         </p>
     *         </dd>
     *         <dt>CfnStack</dt>
     *         <dd>
     *         <p>
     *         The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in
     *         the <code>logicalStackName</code> property.
     *         </p>
     *         </dd>
     *         <dt>Resource</dt>
     *         <dd>
     *         <p>
     *         The resource is mapped to another resource. The name of the resource is contained in the
     *         <code>resourceName</code> property.
     *         </p>
     *         </dd>
     *         <dt>ResourceGroup</dt>
     *         <dd>
     *         <p>
     *         The resource is mapped to Resource Groups. The name of the resource group is contained in the
     *         <code>resourceGroupName</code> property.
     *         </p>
     *         </dd>
     * @see ResourceMappingType
     */
    public final ResourceMappingType mappingType() {
        return ResourceMappingType.fromValue(mappingType);
    }

    /**
     * <p>
     * Specifies the type of resource mapping.
     * </p>
     * <dl>
     * <dt>AppRegistryApp</dt>
     * <dd>
     * <p>
     * The resource is mapped to another application. The name of the application is contained in the
     * <code>appRegistryAppName</code> property.
     * </p>
     * </dd>
     * <dt>CfnStack</dt>
     * <dd>
     * <p>
     * The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the
     * <code>logicalStackName</code> property.
     * </p>
     * </dd>
     * <dt>Resource</dt>
     * <dd>
     * <p>
     * The resource is mapped to another resource. The name of the resource is contained in the
     * <code>resourceName</code> property.
     * </p>
     * </dd>
     * <dt>ResourceGroup</dt>
     * <dd>
     * <p>
     * The resource is mapped to Resource Groups. The name of the resource group is contained in the
     * <code>resourceGroupName</code> property.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mappingType} will
     * return {@link ResourceMappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mappingTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of resource mapping.</p>
     *         <dl>
     *         <dt>AppRegistryApp</dt>
     *         <dd>
     *         <p>
     *         The resource is mapped to another application. The name of the application is contained in the
     *         <code>appRegistryAppName</code> property.
     *         </p>
     *         </dd>
     *         <dt>CfnStack</dt>
     *         <dd>
     *         <p>
     *         The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in
     *         the <code>logicalStackName</code> property.
     *         </p>
     *         </dd>
     *         <dt>Resource</dt>
     *         <dd>
     *         <p>
     *         The resource is mapped to another resource. The name of the resource is contained in the
     *         <code>resourceName</code> property.
     *         </p>
     *         </dd>
     *         <dt>ResourceGroup</dt>
     *         <dd>
     *         <p>
     *         The resource is mapped to Resource Groups. The name of the resource group is contained in the
     *         <code>resourceGroupName</code> property.
     *         </p>
     *         </dd>
     * @see ResourceMappingType
     */
    public final String mappingTypeAsString() {
        return mappingType;
    }

    /**
     * <p>
     * The identifier of this resource.
     * </p>
     * 
     * @return The identifier of this resource.
     */
    public final PhysicalResourceId physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * The name of the resource group this resource is mapped to.
     * </p>
     * 
     * @return The name of the resource group this resource is mapped to.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * The name of the resource this resource is mapped to.
     * </p>
     * 
     * @return The name of the resource this resource is mapped to.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The short name of the Terraform source.
     * </p>
     * 
     * @return The short name of the Terraform source.
     */
    public final String terraformSourceName() {
        return terraformSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appRegistryAppName());
        hashCode = 31 * hashCode + Objects.hashCode(eksSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(logicalStackName());
        hashCode = 31 * hashCode + Objects.hashCode(mappingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(terraformSourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceMapping)) {
            return false;
        }
        ResourceMapping other = (ResourceMapping) obj;
        return Objects.equals(appRegistryAppName(), other.appRegistryAppName())
                && Objects.equals(eksSourceName(), other.eksSourceName())
                && Objects.equals(logicalStackName(), other.logicalStackName())
                && Objects.equals(mappingTypeAsString(), other.mappingTypeAsString())
                && Objects.equals(physicalResourceId(), other.physicalResourceId())
                && Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(terraformSourceName(), other.terraformSourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceMapping").add("AppRegistryAppName", appRegistryAppName())
                .add("EksSourceName", eksSourceName()).add("LogicalStackName", logicalStackName())
                .add("MappingType", mappingTypeAsString()).add("PhysicalResourceId", physicalResourceId())
                .add("ResourceGroupName", resourceGroupName()).add("ResourceName", resourceName())
                .add("TerraformSourceName", terraformSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appRegistryAppName":
            return Optional.ofNullable(clazz.cast(appRegistryAppName()));
        case "eksSourceName":
            return Optional.ofNullable(clazz.cast(eksSourceName()));
        case "logicalStackName":
            return Optional.ofNullable(clazz.cast(logicalStackName()));
        case "mappingType":
            return Optional.ofNullable(clazz.cast(mappingTypeAsString()));
        case "physicalResourceId":
            return Optional.ofNullable(clazz.cast(physicalResourceId()));
        case "resourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "terraformSourceName":
            return Optional.ofNullable(clazz.cast(terraformSourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceMapping, T> g) {
        return obj -> g.apply((ResourceMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceMapping> {
        /**
         * <p>
         * The name of the application this resource is mapped to.
         * </p>
         * 
         * @param appRegistryAppName
         *        The name of the application this resource is mapped to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appRegistryAppName(String appRegistryAppName);

        /**
         * <p>
         * The name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
         * </p>
         * <note>
         * <p>
         * This parameter accepts values in "eks-cluster/namespace" format.
         * </p>
         * </note>
         * 
         * @param eksSourceName
         *        The name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.</p>
         *        <note>
         *        <p>
         *        This parameter accepts values in "eks-cluster/namespace" format.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksSourceName(String eksSourceName);

        /**
         * <p>
         * The name of the CloudFormation stack this resource is mapped to.
         * </p>
         * 
         * @param logicalStackName
         *        The name of the CloudFormation stack this resource is mapped to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalStackName(String logicalStackName);

        /**
         * <p>
         * Specifies the type of resource mapping.
         * </p>
         * <dl>
         * <dt>AppRegistryApp</dt>
         * <dd>
         * <p>
         * The resource is mapped to another application. The name of the application is contained in the
         * <code>appRegistryAppName</code> property.
         * </p>
         * </dd>
         * <dt>CfnStack</dt>
         * <dd>
         * <p>
         * The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the
         * <code>logicalStackName</code> property.
         * </p>
         * </dd>
         * <dt>Resource</dt>
         * <dd>
         * <p>
         * The resource is mapped to another resource. The name of the resource is contained in the
         * <code>resourceName</code> property.
         * </p>
         * </dd>
         * <dt>ResourceGroup</dt>
         * <dd>
         * <p>
         * The resource is mapped to Resource Groups. The name of the resource group is contained in the
         * <code>resourceGroupName</code> property.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param mappingType
         *        Specifies the type of resource mapping.</p>
         *        <dl>
         *        <dt>AppRegistryApp</dt>
         *        <dd>
         *        <p>
         *        The resource is mapped to another application. The name of the application is contained in the
         *        <code>appRegistryAppName</code> property.
         *        </p>
         *        </dd>
         *        <dt>CfnStack</dt>
         *        <dd>
         *        <p>
         *        The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in
         *        the <code>logicalStackName</code> property.
         *        </p>
         *        </dd>
         *        <dt>Resource</dt>
         *        <dd>
         *        <p>
         *        The resource is mapped to another resource. The name of the resource is contained in the
         *        <code>resourceName</code> property.
         *        </p>
         *        </dd>
         *        <dt>ResourceGroup</dt>
         *        <dd>
         *        <p>
         *        The resource is mapped to Resource Groups. The name of the resource group is contained in the
         *        <code>resourceGroupName</code> property.
         *        </p>
         *        </dd>
         * @see ResourceMappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceMappingType
         */
        Builder mappingType(String mappingType);

        /**
         * <p>
         * Specifies the type of resource mapping.
         * </p>
         * <dl>
         * <dt>AppRegistryApp</dt>
         * <dd>
         * <p>
         * The resource is mapped to another application. The name of the application is contained in the
         * <code>appRegistryAppName</code> property.
         * </p>
         * </dd>
         * <dt>CfnStack</dt>
         * <dd>
         * <p>
         * The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the
         * <code>logicalStackName</code> property.
         * </p>
         * </dd>
         * <dt>Resource</dt>
         * <dd>
         * <p>
         * The resource is mapped to another resource. The name of the resource is contained in the
         * <code>resourceName</code> property.
         * </p>
         * </dd>
         * <dt>ResourceGroup</dt>
         * <dd>
         * <p>
         * The resource is mapped to Resource Groups. The name of the resource group is contained in the
         * <code>resourceGroupName</code> property.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param mappingType
         *        Specifies the type of resource mapping.</p>
         *        <dl>
         *        <dt>AppRegistryApp</dt>
         *        <dd>
         *        <p>
         *        The resource is mapped to another application. The name of the application is contained in the
         *        <code>appRegistryAppName</code> property.
         *        </p>
         *        </dd>
         *        <dt>CfnStack</dt>
         *        <dd>
         *        <p>
         *        The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in
         *        the <code>logicalStackName</code> property.
         *        </p>
         *        </dd>
         *        <dt>Resource</dt>
         *        <dd>
         *        <p>
         *        The resource is mapped to another resource. The name of the resource is contained in the
         *        <code>resourceName</code> property.
         *        </p>
         *        </dd>
         *        <dt>ResourceGroup</dt>
         *        <dd>
         *        <p>
         *        The resource is mapped to Resource Groups. The name of the resource group is contained in the
         *        <code>resourceGroupName</code> property.
         *        </p>
         *        </dd>
         * @see ResourceMappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceMappingType
         */
        Builder mappingType(ResourceMappingType mappingType);

        /**
         * <p>
         * The identifier of this resource.
         * </p>
         * 
         * @param physicalResourceId
         *        The identifier of this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(PhysicalResourceId physicalResourceId);

        /**
         * <p>
         * The identifier of this resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link PhysicalResourceId.Builder} avoiding the
         * need to create one manually via {@link PhysicalResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PhysicalResourceId.Builder#build()} is called immediately and its
         * result is passed to {@link #physicalResourceId(PhysicalResourceId)}.
         * 
         * @param physicalResourceId
         *        a consumer that will call methods on {@link PhysicalResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalResourceId(PhysicalResourceId)
         */
        default Builder physicalResourceId(Consumer<PhysicalResourceId.Builder> physicalResourceId) {
            return physicalResourceId(PhysicalResourceId.builder().applyMutation(physicalResourceId).build());
        }

        /**
         * <p>
         * The name of the resource group this resource is mapped to.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group this resource is mapped to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The name of the resource this resource is mapped to.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource this resource is mapped to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The short name of the Terraform source.
         * </p>
         * 
         * @param terraformSourceName
         *        The short name of the Terraform source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terraformSourceName(String terraformSourceName);
    }

    static final class BuilderImpl implements Builder {
        private String appRegistryAppName;

        private String eksSourceName;

        private String logicalStackName;

        private String mappingType;

        private PhysicalResourceId physicalResourceId;

        private String resourceGroupName;

        private String resourceName;

        private String terraformSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceMapping model) {
            appRegistryAppName(model.appRegistryAppName);
            eksSourceName(model.eksSourceName);
            logicalStackName(model.logicalStackName);
            mappingType(model.mappingType);
            physicalResourceId(model.physicalResourceId);
            resourceGroupName(model.resourceGroupName);
            resourceName(model.resourceName);
            terraformSourceName(model.terraformSourceName);
        }

        public final String getAppRegistryAppName() {
            return appRegistryAppName;
        }

        public final void setAppRegistryAppName(String appRegistryAppName) {
            this.appRegistryAppName = appRegistryAppName;
        }

        @Override
        public final Builder appRegistryAppName(String appRegistryAppName) {
            this.appRegistryAppName = appRegistryAppName;
            return this;
        }

        public final String getEksSourceName() {
            return eksSourceName;
        }

        public final void setEksSourceName(String eksSourceName) {
            this.eksSourceName = eksSourceName;
        }

        @Override
        public final Builder eksSourceName(String eksSourceName) {
            this.eksSourceName = eksSourceName;
            return this;
        }

        public final String getLogicalStackName() {
            return logicalStackName;
        }

        public final void setLogicalStackName(String logicalStackName) {
            this.logicalStackName = logicalStackName;
        }

        @Override
        public final Builder logicalStackName(String logicalStackName) {
            this.logicalStackName = logicalStackName;
            return this;
        }

        public final String getMappingType() {
            return mappingType;
        }

        public final void setMappingType(String mappingType) {
            this.mappingType = mappingType;
        }

        @Override
        public final Builder mappingType(String mappingType) {
            this.mappingType = mappingType;
            return this;
        }

        @Override
        public final Builder mappingType(ResourceMappingType mappingType) {
            this.mappingType(mappingType == null ? null : mappingType.toString());
            return this;
        }

        public final PhysicalResourceId.Builder getPhysicalResourceId() {
            return physicalResourceId != null ? physicalResourceId.toBuilder() : null;
        }

        public final void setPhysicalResourceId(PhysicalResourceId.BuilderImpl physicalResourceId) {
            this.physicalResourceId = physicalResourceId != null ? physicalResourceId.build() : null;
        }

        @Override
        public final Builder physicalResourceId(PhysicalResourceId physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getTerraformSourceName() {
            return terraformSourceName;
        }

        public final void setTerraformSourceName(String terraformSourceName) {
            this.terraformSourceName = terraformSourceName;
        }

        @Override
        public final Builder terraformSourceName(String terraformSourceName) {
            this.terraformSourceName = terraformSourceName;
            return this;
        }

        @Override
        public ResourceMapping build() {
            return new ResourceMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
